/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.navigation.actions.TypeDeclarationPlaceAwareProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaTypeDeclarationProvider
implements TypeDeclarationPlaceAwareProvider {
    @Override
    public PsiElement[] getSymbolTypeDeclarations(@NotNull PsiElement symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/intellij/codeInsight/navigation/actions/JavaTypeDeclarationProvider", "getSymbolTypeDeclarations"));
        }
        return this.getSymbolTypeDeclarations(symbol, null, -1);
    }

    @Override
    @Nullable
    public PsiElement[] getSymbolTypeDeclarations(@NotNull PsiElement targetElement, Editor editor, int offset) {
        PsiElement[] psiElementArray;
        PsiClass psiClass;
        PsiReference reference;
        PsiType type;
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "com/intellij/codeInsight/navigation/actions/JavaTypeDeclarationProvider", "getSymbolTypeDeclarations"));
        }
        if (targetElement instanceof PsiVariable) {
            type = ((PsiVariable)targetElement).getType();
        } else if (targetElement instanceof PsiMethod) {
            type = ((PsiMethod)targetElement).getReturnType();
        } else {
            return null;
        }
        if (type == null) {
            return null;
        }
        if (editor != null && (reference = TargetElementUtil.findReference(editor, offset)) instanceof PsiJavaReference) {
            JavaResolveResult resolveResult = ((PsiJavaReference)reference).advancedResolve(true);
            type = resolveResult.getSubstitutor().substitute(type);
        }
        if ((psiClass = PsiUtil.resolveClassInType((PsiType)type)) == null) {
            psiElementArray = null;
        } else {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = psiClass;
        }
        return psiElementArray;
    }
}

