/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ReloadComponentStoreStatus;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.components.impl.stores.StateStorageBase;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.Messages;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u0001\u001a&\u0010\u000b\u001a\u00020\f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0002\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0001H\u0002\u00a8\u0006\u000e"}, d2={"askToRestart", "", "store", "Lcom/intellij/openapi/components/impl/stores/IComponentStore;", "notReloadableComponents", "", "", "changedStorages", "", "Lcom/intellij/openapi/components/StateStorage;", "isApp", "reloadStore", "Lcom/intellij/configurationStore/ReloadComponentStoreStatus;", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "configuration-store-impl"})
public final class StoreAwareProjectManagerKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ReloadComponentStoreStatus reloadStore(Set<? extends StateStorage> changedStorages, ComponentStoreImpl store, boolean isApp) {
        boolean willBeReloaded = false;
        try {
            Collection<String> notReloadableComponents;
            try {
                notReloadableComponents = store.reload(changedStorages);
            }
            catch (Throwable e) {
                ComponentStoreImplKt.getLOG().warn(e);
                Messages.showWarningDialog((String)ProjectBundle.message((String)"project.reload.failed", (Object[])new Object[]{e.getMessage()}), (String)ProjectBundle.message((String)"project.reload.failed.title", (Object[])new Object[0]));
                ReloadComponentStoreStatus reloadComponentStoreStatus = ReloadComponentStoreStatus.ERROR;
                if (!willBeReloaded) {
                    for (StateStorage stateStorage : changedStorages) {
                        if (!(stateStorage instanceof StateStorageBase)) continue;
                        ((StateStorageBase)stateStorage).enableSaving();
                    }
                }
                return reloadComponentStoreStatus;
            }
            if (notReloadableComponents == null || notReloadableComponents.isEmpty()) {
                ReloadComponentStoreStatus reloadComponentStoreStatus = ReloadComponentStoreStatus.SUCCESS;
                return reloadComponentStoreStatus;
            }
            willBeReloaded = StoreAwareProjectManagerKt.askToRestart(store, notReloadableComponents, changedStorages, isApp);
            ReloadComponentStoreStatus reloadComponentStoreStatus = willBeReloaded ? ReloadComponentStoreStatus.RESTART_AGREED : ReloadComponentStoreStatus.RESTART_CANCELLED;
            return reloadComponentStoreStatus;
        }
        finally {
            if (!willBeReloaded) {
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).enableSaving();
                }
            }
        }
    }

    public static final boolean askToRestart(@NotNull IComponentStore store, @NotNull Collection<String> notReloadableComponents, @Nullable Set<? extends StateStorage> changedStorages, boolean isApp) {
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        Intrinsics.checkParameterIsNotNull(notReloadableComponents, (String)"notReloadableComponents");
        StringBuilder message = new StringBuilder();
        String storeName = store instanceof IProjectStore ? "Project" : "Application";
        message.append(storeName).append(' ');
        message.append("components were changed externally and cannot be reloaded:\n\n");
        int count = 0;
        for (String string : notReloadableComponents) {
            if (count == 10) {
                message.append('\n').append("and ").append(notReloadableComponents.size() - count).append(" more").append('\n');
                continue;
            }
            message.append(string).append('\n');
            ++count;
        }
        message.append("\nWould you like to ");
        if (isApp) {
            message.append(ApplicationManager.getApplication().isRestartCapable() ? "restart" : "shutdown").append(' ');
            message.append(ApplicationNamesInfo.getInstance().getProductName()).append('?');
        } else {
            message.append("reload project?");
        }
        if (Messages.showYesNoDialog((String)message.toString(), (String)(storeName + " Files Changed"), (Icon)Messages.getQuestionIcon()) == 0) {
            if (changedStorages != null) {
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).disableSaving();
                }
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static final /* synthetic */ ReloadComponentStoreStatus access$reloadStore(@NotNull Set changedStorages, @NotNull ComponentStoreImpl store, boolean isApp) {
        return StoreAwareProjectManagerKt.reloadStore(changedStorages, store, isApp);
    }
}

