/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.designer.DesignerEditorState;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class DesignerEditor
extends UserDataHolderBase
implements FileEditor {
    protected final DesignerEditorPanel myDesignerPanel;

    public DesignerEditor(Project project, VirtualFile file2) {
        if (file2 instanceof LightVirtualFile) {
            file2 = ((LightVirtualFile)file2).getOriginalFile();
        }
        this.myDesignerPanel = this.createDesignerPanel(project, this.findModule(project, file2), file2);
    }

    protected abstract Module findModule(Project var1, VirtualFile var2);

    @NotNull
    protected abstract DesignerEditorPanel createDesignerPanel(Project var1, Module var2, VirtualFile var3);

    public final DesignerEditorPanel getDesignerPanel() {
        return this.myDesignerPanel;
    }

    @NotNull
    public final JComponent getComponent() {
        DesignerEditorPanel designerEditorPanel = this.myDesignerPanel;
        if (designerEditorPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/DesignerEditor", "getComponent"));
        }
        return designerEditorPanel;
    }

    public final JComponent getPreferredFocusedComponent() {
        return this.myDesignerPanel.getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        if ("Design" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/DesignerEditor", "getName"));
        }
        return "Design";
    }

    public void dispose() {
        this.myDesignerPanel.dispose();
    }

    public void selectNotify() {
        this.myDesignerPanel.activate();
    }

    public void deselectNotify() {
        this.myDesignerPanel.deactivate();
    }

    public boolean isValid() {
        return this.myDesignerPanel.isEditorValid();
    }

    public boolean isModified() {
        return false;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/designer/DesignerEditor", "getState"));
        }
        DesignerEditorState designerEditorState = this.myDesignerPanel.createState();
        if (designerEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/DesignerEditor", "getState"));
        }
        return designerEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/designer/DesignerEditor", "setState"));
        }
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/designer/DesignerEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/designer/DesignerEditor", "removePropertyChangeListener"));
        }
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }
}

