/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.console.IdeConsoleRootType;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.script.IdeScriptBindings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.script.IdeScriptEngine;
import org.jetbrains.ide.script.IdeScriptEngineManager;

public class RunIdeConsoleAction
extends DumbAwareAction {
    private static final String DEFAULT_FILE_NAME = "ide-scripting";
    private static final Key<WeakReference<RunContentDescriptor>> DESCRIPTOR_KEY = Key.create((String)"DESCRIPTOR_KEY");
    private static final Logger LOG = Logger.getInstance(RunIdeConsoleAction.class);

    public void update(AnActionEvent e) {
        IdeScriptEngineManager manager = IdeScriptEngineManager.getInstance();
        e.getPresentation().setVisible(e.getProject() != null);
        e.getPresentation().setEnabled(manager.isInitialized() && !manager.getLanguages().isEmpty());
    }

    public void actionPerformed(AnActionEvent e) {
        List<String> languages = IdeScriptEngineManager.getInstance().getLanguages();
        if (languages.size() == 1) {
            this.runConsole(e, languages.iterator().next());
            return;
        }
        DefaultActionGroup actions = new DefaultActionGroup(ContainerUtil.map(languages, (Function)new NotNullFunction<String, AnAction>(){

            @NotNull
            public AnAction fun(final String language) {
                DumbAwareAction dumbAwareAction = new DumbAwareAction(language){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/console/RunIdeConsoleAction$1$1", "actionPerformed"));
                        }
                        RunIdeConsoleAction.this.runConsole(e, language);
                    }
                };
                if (dumbAwareAction == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/RunIdeConsoleAction$1", "fun"));
                }
                return dumbAwareAction;
            }
        }));
        JBPopupFactory.getInstance().createActionGroupPopup("Script Engine", (ActionGroup)actions, e.getDataContext(), JBPopupFactory.ActionSelectionAid.NUMBERING, false).showInBestPositionFor(e.getDataContext());
    }

    protected void runConsole(@NotNull AnActionEvent e, @NotNull String language) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/console/RunIdeConsoleAction", "runConsole"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/execution/console/RunIdeConsoleAction", "runConsole"));
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        List<String> extensions = IdeScriptEngineManager.getInstance().getFileExtensions(language);
        try {
            String pathName = PathUtil.makeFileName((String)DEFAULT_FILE_NAME, (String)((String)ContainerUtil.getFirstItem(extensions)));
            VirtualFile virtualFile = IdeConsoleRootType.getInstance().findFile(project, pathName, ScratchFileService.Option.create_if_missing);
            if (virtualFile != null) {
                FileEditorManager.getInstance((Project)project).openFile(virtualFile, true);
            }
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex);
        }
    }

    public static void configureConsole(@NotNull VirtualFile file2, @NotNull FileEditorManager source) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/RunIdeConsoleAction", "configureConsole"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/execution/console/RunIdeConsoleAction", "configureConsole"));
        }
        MyRunAction runAction = new MyRunAction();
        for (FileEditor fileEditor : source.getEditors(file2)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor = ((TextEditor)fileEditor).getEditor();
            runAction.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, editor.getComponent());
        }
    }

    private static void executeQuery(@NotNull Project project, @NotNull VirtualFile file2, @NotNull Editor editor, @NotNull IdeScriptEngine engine) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/RunIdeConsoleAction", "executeQuery"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/RunIdeConsoleAction", "executeQuery"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/RunIdeConsoleAction", "executeQuery"));
        }
        if (engine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/execution/console/RunIdeConsoleAction", "executeQuery"));
        }
        String command = RunIdeConsoleAction.getCommandText(editor);
        String profile = RunIdeConsoleAction.getProfileText(file2);
        RunContentDescriptor descriptor = RunIdeConsoleAction.getConsoleView(project, file2);
        ConsoleViewImpl consoleView = (ConsoleViewImpl)descriptor.getExecutionConsole();
        RunIdeConsoleAction.prepareEngine(project, engine, descriptor);
        try {
            consoleView.print("> " + command, ConsoleViewContentType.USER_INPUT);
            consoleView.print("\n", ConsoleViewContentType.USER_INPUT);
            String script = profile == null ? command : profile + "\n" + command;
            Object o = engine.eval(script);
            consoleView.print("=> " + o, ConsoleViewContentType.NORMAL_OUTPUT);
            consoleView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        catch (Throwable e) {
            Throwable ex = ExceptionUtil.getRootCause((Throwable)e);
            consoleView.print(ex.getClass().getSimpleName() + ": " + ex.getMessage(), ConsoleViewContentType.ERROR_OUTPUT);
            consoleView.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
        }
        RunIdeConsoleAction.selectContent(descriptor);
    }

    private static void prepareEngine(@NotNull Project project, @NotNull IdeScriptEngine engine, @NotNull RunContentDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/RunIdeConsoleAction", "prepareEngine"));
        }
        if (engine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/execution/console/RunIdeConsoleAction", "prepareEngine"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/console/RunIdeConsoleAction", "prepareEngine"));
        }
        IdeScriptBindings.ensureIdeIsBound(project, engine);
        RunIdeConsoleAction.ensureOutputIsRedirected(engine, descriptor);
    }

    @Nullable
    private static String getProfileText(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/RunIdeConsoleAction", "getProfileText"));
        }
        try {
            VirtualFile folder = file2.getParent();
            VirtualFile profileChild = folder == null ? null : folder.findChild(".profile." + file2.getExtension());
            return profileChild == null ? null : StringUtil.nullize((String)VfsUtilCore.loadText(profileChild));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @NotNull
    private static String getCommandText(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/RunIdeConsoleAction", "getCommandText"));
        }
        TextRange selectedRange = EditorUtil.getSelectionInAnyMode(editor);
        Document document = editor.getDocument();
        if (selectedRange.getLength() == 0) {
            int line = document.getLineNumber(selectedRange.getStartOffset());
            selectedRange = TextRange.create((int)document.getLineStartOffset(line), (int)document.getLineEndOffset(line));
        }
        String string = document.getText(selectedRange);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/RunIdeConsoleAction", "getCommandText"));
        }
        return string;
    }

    private static void selectContent(RunContentDescriptor descriptor) {
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        ConsoleViewImpl consoleView = (ConsoleViewImpl)ObjectUtils.assertNotNull((Object)((ConsoleViewImpl)descriptor.getExecutionConsole()));
        ExecutionManager.getInstance((Project)consoleView.getProject()).getContentManager().toFrontRunContent(executor, descriptor);
    }

    @NotNull
    private static RunContentDescriptor getConsoleView(@NotNull Project project, @NotNull VirtualFile file2) {
        RunContentDescriptor descriptor;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/RunIdeConsoleAction", "getConsoleView"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/RunIdeConsoleAction", "getConsoleView"));
        }
        PsiFile psiFile = (PsiFile)ObjectUtils.assertNotNull((Object)PsiManager.getInstance((Project)project).findFile(file2));
        WeakReference ref = (WeakReference)psiFile.getCopyableUserData(DESCRIPTOR_KEY);
        RunContentDescriptor runContentDescriptor = descriptor = ref == null ? null : (RunContentDescriptor)ref.get();
        if (descriptor == null || descriptor.getExecutionConsole() == null) {
            descriptor = RunIdeConsoleAction.createConsoleView(project, psiFile);
            psiFile.putCopyableUserData(DESCRIPTOR_KEY, new WeakReference<RunContentDescriptor>(descriptor));
        }
        RunContentDescriptor runContentDescriptor2 = descriptor;
        if (runContentDescriptor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/RunIdeConsoleAction", "getConsoleView"));
        }
        return runContentDescriptor2;
    }

    @NotNull
    private static RunContentDescriptor createConsoleView(@NotNull Project project, @NotNull PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/RunIdeConsoleAction", "createConsoleView"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/execution/console/RunIdeConsoleAction", "createConsoleView"));
        }
        ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)consoleView.getComponent(), "Center");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarActions, false);
        toolbar.setTargetComponent(consoleView.getComponent());
        panel.add((Component)toolbar.getComponent(), "West");
        RunContentDescriptor descriptor = new RunContentDescriptor((ExecutionConsole)consoleView, null, panel, psiFile.getName()){

            public boolean isContentReuseProhibited() {
                return true;
            }
        };
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        toolbarActions.addAll(consoleView.createConsoleActions());
        toolbarActions.add((AnAction)new CloseAction(executor, descriptor, project));
        ExecutionManager.getInstance((Project)project).getContentManager().showRunContent(executor, descriptor);
        RunContentDescriptor runContentDescriptor = descriptor;
        if (runContentDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/RunIdeConsoleAction", "createConsoleView"));
        }
        return runContentDescriptor;
    }

    private static void ensureOutputIsRedirected(@NotNull IdeScriptEngine engine, @NotNull RunContentDescriptor descriptor) {
        if (engine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/execution/console/RunIdeConsoleAction", "ensureOutputIsRedirected"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/console/RunIdeConsoleAction", "ensureOutputIsRedirected"));
        }
        ConsoleWriter stdOutWriter = (ConsoleWriter)ObjectUtils.tryCast((Object)engine.getStdOut(), ConsoleWriter.class);
        ConsoleWriter stdErrWriter = (ConsoleWriter)ObjectUtils.tryCast((Object)engine.getStdErr(), ConsoleWriter.class);
        if (stdOutWriter != null && stdOutWriter.getDescriptor() == descriptor && stdErrWriter != null && stdErrWriter.getDescriptor() == descriptor) {
            return;
        }
        WeakReference<RunContentDescriptor> ref = new WeakReference<RunContentDescriptor>(descriptor);
        engine.setStdOut(new ConsoleWriter(ref, ConsoleViewContentType.NORMAL_OUTPUT));
        engine.setStdErr(new ConsoleWriter(ref, ConsoleViewContentType.ERROR_OUTPUT));
    }

    private static class ConsoleWriter
    extends Writer {
        private final WeakReference<RunContentDescriptor> myDescriptor;
        private final ConsoleViewContentType myOutputType;

        private ConsoleWriter(@NotNull WeakReference<RunContentDescriptor> descriptor, @NotNull ConsoleViewContentType outputType) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/console/RunIdeConsoleAction$ConsoleWriter", "<init>"));
            }
            if (outputType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "com/intellij/execution/console/RunIdeConsoleAction$ConsoleWriter", "<init>"));
            }
            this.myDescriptor = descriptor;
            this.myOutputType = outputType;
        }

        @Nullable
        public RunContentDescriptor getDescriptor() {
            return (RunContentDescriptor)this.myDescriptor.get();
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            RunContentDescriptor descriptor = (RunContentDescriptor)this.myDescriptor.get();
            ConsoleViewImpl console = (ConsoleViewImpl)ObjectUtils.tryCast((Object)(descriptor != null ? descriptor.getExecutionConsole() : null), ConsoleViewImpl.class);
            if (console == null) {
                throw new IOException("The console is not available.");
            }
            console.print(new String(cbuf, off, len), this.myOutputType);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class MyRunAction
    extends DumbAwareAction {
        private IdeScriptEngine engine;

        private MyRunAction() {
        }

        public void update(AnActionEvent e) {
            Project project = e.getProject();
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
            VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
            e.getPresentation().setEnabledAndVisible(project != null && editor != null && virtualFile != null);
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = e.getProject();
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
            VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
            if (project == null || editor == null || virtualFile == null) {
                return;
            }
            String extension = virtualFile.getExtension();
            if (!(extension == null || this.engine != null && this.engine.getFileExtensions().contains(extension))) {
                this.engine = IdeScriptEngineManager.getInstance().getEngineForFileExtension(extension, null);
            }
            if (this.engine == null) {
                LOG.warn("Script engine not found for: " + virtualFile.getName());
            } else {
                RunIdeConsoleAction.executeQuery(project, virtualFile, editor, this.engine);
            }
        }
    }
}

