/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.todo.ToDoSettings;
import com.intellij.ide.todo.ToDoSummary;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructureBase;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoPattern;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class TodoTreeStructure
extends AbstractTreeStructureBase
implements ToDoSettings {
    protected TodoTreeBuilder myBuilder;
    protected AbstractTreeNode myRootElement;
    protected final ToDoSummary mySummaryElement = new ToDoSummary();
    private boolean myFlattenPackages;
    protected boolean myArePackagesShown = true;
    private boolean myAreModulesShown;
    protected final PsiTodoSearchHelper mySearchHelper;
    protected TodoFilter myTodoFilter;

    public TodoTreeStructure(Project project) {
        super(project);
        this.mySearchHelper = PsiTodoSearchHelper.SERVICE.getInstance((Project)project);
    }

    final void setTreeBuilder(TodoTreeBuilder builder) {
        this.myBuilder = builder;
        this.myRootElement = this.createRootElement();
    }

    protected abstract AbstractTreeNode createRootElement();

    public abstract boolean accept(PsiFile var1);

    protected void validateCache() {
    }

    public final boolean isPackagesShown() {
        return this.myArePackagesShown;
    }

    final void setShownPackages(boolean state) {
        this.myArePackagesShown = state;
    }

    public final boolean areFlattenPackages() {
        return this.myFlattenPackages;
    }

    public final void setFlattenPackages(boolean state) {
        this.myFlattenPackages = state;
    }

    final void setTodoFilter(TodoFilter todoFilter) {
        this.myTodoFilter = todoFilter;
    }

    abstract Object getFirstSelectableElement();

    public final int getTodoItemCount(PsiFile psiFile) {
        int count = 0;
        if (psiFile != null) {
            if (this.myTodoFilter != null) {
                Iterator<TodoPattern> i = this.myTodoFilter.iterator();
                while (i.hasNext()) {
                    TodoPattern pattern = i.next();
                    count += this.getSearchHelper().getTodoItemsCount(psiFile, pattern);
                }
            } else {
                count = this.getSearchHelper().getTodoItemsCount(psiFile);
            }
        }
        return count;
    }

    boolean isAutoExpandNode(NodeDescriptor descriptor) {
        Object element = descriptor.getElement();
        return element == this.getRootElement() || element == this.mySummaryElement;
    }

    public final void commit() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
    }

    public boolean hasSomethingToCommit() {
        return PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments();
    }

    @NotNull
    public ActionCallback asyncCommit() {
        ActionCallback actionCallback = TodoTreeStructure.asyncCommitDocuments((Project)this.myProject);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/TodoTreeStructure", "asyncCommit"));
        }
        return actionCallback;
    }

    public final Object getRootElement() {
        return this.myRootElement;
    }

    public boolean getIsFlattenPackages() {
        return this.myFlattenPackages;
    }

    public PsiTodoSearchHelper getSearchHelper() {
        return this.mySearchHelper;
    }

    public TodoFilter getTodoFilter() {
        return this.myTodoFilter;
    }

    @Override
    public List<TreeStructureProvider> getProviders() {
        return Collections.emptyList();
    }

    void setShownModules(boolean state) {
        this.myAreModulesShown = state;
    }

    @Override
    public boolean isModulesShown() {
        return this.myAreModulesShown;
    }
}

