/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.facet.impl.ui.libraries.LibraryCompositionSettings;
import com.intellij.facet.impl.ui.libraries.LibraryOptionsPanel;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.framework.FrameworkGroup;
import com.intellij.framework.FrameworkVersion;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.framework.addSupport.FrameworkVersionListener;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportUtil;
import com.intellij.ide.util.newProjectWizard.FrameworkGroupNode;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportNode;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportNodeBase;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportOptionsComponent;
import com.intellij.ide.util.newProjectWizard.FrameworkVersionComponent;
import com.intellij.ide.util.newProjectWizard.FrameworksTree;
import com.intellij.ide.util.newProjectWizard.OldFrameworkSupportProviderWrapper;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportCommunicator;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.roots.IdeaModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddSupportForFrameworksPanel
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.newProjectWizard.AddSupportForFrameworksStep");
    @NonNls
    private static final String EMPTY_CARD = "empty";
    private JPanel myMainPanel;
    private JPanel myFrameworksPanel;
    private JLabel myLabel;
    private List<FrameworkSupportInModuleProvider> myProviders;
    private List<FrameworkSupportNodeBase> myRoots;
    private final LibrariesContainer myLibrariesContainer;
    private final FrameworkSupportModelBase myModel;
    private final JPanel myOptionsPanel;
    private final FrameworksTree myFrameworksTree;
    private final Map<FrameworkSupportNode, FrameworkSupportOptionsComponent> myInitializedOptionsComponents;
    private final Map<FrameworkGroup<?>, JPanel> myInitializedGroupPanels;
    private FrameworkSupportNodeBase myLastSelectedNode;
    private Collection<FrameworkSupportNodeBase> myAssociatedFrameworks;
    @Nullable
    private final JPanel myAssociatedFrameworksPanel;

    public AddSupportForFrameworksPanel(List<FrameworkSupportInModuleProvider> providers, FrameworkSupportModelBase model, boolean vertical, @Nullable JPanel associatedFrameworksPanel) {
        this.$$$setupUI$$$();
        this.myInitializedOptionsComponents = new HashMap<FrameworkSupportNode, FrameworkSupportOptionsComponent>();
        this.myInitializedGroupPanels = new HashMap();
        this.myModel = model;
        this.myAssociatedFrameworksPanel = associatedFrameworksPanel;
        this.myLibrariesContainer = model.getLibrariesContainer();
        this.myLabel.setVisible(!vertical);
        Splitter splitter = vertical ? new Splitter(true, 0.6f, 0.2f, 0.8f) : new Splitter(false, 0.3f, 0.3f, 0.7f);
        splitter.setHonorComponentsMinimumSize(false);
        this.myFrameworksTree = new FrameworksTree(model){

            protected void onNodeStateChanged(CheckedTreeNode node) {
                if (!(node instanceof FrameworkSupportNode)) {
                    return;
                }
                FrameworkSupportNode frameworkSupportNode = (FrameworkSupportNode)node;
                if (frameworkSupportNode == AddSupportForFrameworksPanel.this.getSelectedNode()) {
                    AddSupportForFrameworksPanel.this.updateOptionsPanel();
                }
                FrameworkSupportInModuleConfigurable configurable = frameworkSupportNode.getConfigurable();
                configurable.onFrameworkSelectionChanged(node.isChecked());
                AddSupportForFrameworksPanel.this.myModel.onFrameworkSelectionChanged(frameworkSupportNode);
                AddSupportForFrameworksPanel.this.onFrameworkStateChanged();
            }
        };
        model.addFrameworkVersionListener(new FrameworkVersionListener(){

            @Override
            public void versionChanged(FrameworkVersion version) {
                ((DefaultTreeModel)AddSupportForFrameworksPanel.this.myFrameworksTree.getModel()).nodeChanged((TreeNode)((Object)AddSupportForFrameworksPanel.this.getSelectedNode()));
            }
        }, this);
        this.myFrameworksTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                AddSupportForFrameworksPanel.this.onSelectionChanged();
            }
        });
        JPanel treePanel = new JPanel(new BorderLayout());
        treePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myFrameworksTree)), "Center");
        treePanel.setMinimumSize((Dimension)JBUI.size((int)200, (int)300));
        splitter.setFirstComponent((JComponent)treePanel);
        this.myOptionsPanel = new JPanel(new CardLayout());
        JPanel emptyCard = new JPanel();
        emptyCard.setPreferredSize((Dimension)JBUI.size((int)400, (int)100));
        this.myOptionsPanel.add(EMPTY_CARD, emptyCard);
        splitter.setSecondComponent((JComponent)this.myOptionsPanel);
        this.myFrameworksPanel.add((Component)splitter, "Center");
        this.setProviders(providers);
    }

    public void setProviders(List<FrameworkSupportInModuleProvider> providers) {
        this.setProviders(providers, Collections.<String>emptySet(), Collections.<String>emptySet());
    }

    public void setProviders(List<FrameworkSupportInModuleProvider> providers, Set<String> associated, Set<String> preselected) {
        this.myProviders = providers;
        this.myAssociatedFrameworks = this.createNodes(this.myProviders, associated, preselected);
        for (FrameworkSupportNodeBase node : this.myRoots) {
            if (!preselected.contains(node.getId())) continue;
            node.setChecked(true);
        }
        this.setAssociatedFrameworks();
        this.myFrameworksTree.setRoots(this.myRoots);
        this.myFrameworksTree.setSelectionRow(0);
    }

    public void setAssociatedFrameworks() {
        if (this.myAssociatedFrameworksPanel == null) {
            return;
        }
        for (FrameworkSupportNodeBase nodeBase : this.myAssociatedFrameworks) {
            if (nodeBase instanceof FrameworkSupportNode) {
                ((FrameworkSupportNode)nodeBase).getConfigurable().onFrameworkSelectionChanged(true);
                FrameworkSupportOptionsComponent component = this.initializeOptionsPanel((FrameworkSupportNode)nodeBase, false);
                AddSupportForFrameworksPanel.addAssociatedFrameworkComponent(component.getMainPanel(), this.myAssociatedFrameworksPanel);
                continue;
            }
            JPanel panel = this.initializeGroupPanel((FrameworkGroup)nodeBase.getUserObject(), false);
            AddSupportForFrameworksPanel.addAssociatedFrameworkComponent(panel, this.myAssociatedFrameworksPanel);
        }
    }

    private static void addAssociatedFrameworkComponent(JPanel component, JPanel panel) {
        panel.add((Component)component, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void onFrameworkStateChanged() {
    }

    private void onSelectionChanged() {
        FrameworkSupportNodeBase selectedNode;
        if (!this.myFrameworksTree.isProcessingMouseEventOnCheckbox()) {
            this.updateOptionsPanel();
        }
        if (!Comparing.equal((Object)((Object)(selectedNode = this.getSelectedNode())), (Object)((Object)this.myLastSelectedNode))) {
            this.applyLibraryOptionsForSelected();
            this.myLastSelectedNode = selectedNode;
        }
    }

    public void dispose() {
    }

    private void applyLibraryOptionsForSelected() {
        LibraryOptionsPanel optionsPanel;
        FrameworkSupportOptionsComponent optionsComponent;
        if (this.myLastSelectedNode instanceof FrameworkSupportNode && (optionsComponent = this.myInitializedOptionsComponents.get((Object)((FrameworkSupportNode)this.myLastSelectedNode))) != null && (optionsPanel = optionsComponent.getLibraryOptionsPanel()) != null) {
            optionsPanel.apply();
        }
    }

    private void updateOptionsPanel() {
        FrameworkSupportNodeBase node = this.getSelectedNode();
        if (node instanceof FrameworkSupportNode) {
            FrameworkSupportNode frameworkSupportNode = (FrameworkSupportNode)node;
            this.initializeOptionsPanel(frameworkSupportNode, true);
            this.showCard(frameworkSupportNode.getId());
            UIUtil.setEnabled((Component)this.myOptionsPanel, (boolean)frameworkSupportNode.isChecked(), (boolean)true);
            frameworkSupportNode.getConfigurable().onFrameworkSelectionChanged(node.isChecked());
        } else if (node instanceof FrameworkGroupNode) {
            FrameworkGroup group = (FrameworkGroup)((FrameworkGroupNode)node).getUserObject();
            this.initializeGroupPanel(group, true);
            this.showCard(group.getId());
            UIUtil.setEnabled((Component)this.myOptionsPanel, (boolean)true, (boolean)true);
        } else {
            this.showCard(EMPTY_CARD);
        }
    }

    private JPanel initializeGroupPanel(FrameworkGroup<?> group, boolean addToOptions) {
        JPanel panel = this.myInitializedGroupPanels.get(group);
        if (panel == null) {
            FrameworkVersionComponent component = new FrameworkVersionComponent(this.myModel, group.getId(), group.getGroupVersions(), group.getPresentableName() + " version:");
            panel = component.getMainPanel();
            this.myInitializedGroupPanels.put(group, panel);
            if (addToOptions) {
                this.myOptionsPanel.add(group.getId(), AddSupportForFrameworksPanel.wrapInScrollPane(panel));
            }
        }
        return panel;
    }

    @Nullable
    public FrameworkSupportNodeBase getSelectedNode() {
        FrameworkSupportNodeBase[] nodes = (FrameworkSupportNodeBase[])this.myFrameworksTree.getSelectedNodes(FrameworkSupportNodeBase.class, null);
        return nodes.length == 1 ? nodes[0] : null;
    }

    private FrameworkSupportOptionsComponent initializeOptionsPanel(FrameworkSupportNode node, boolean addToOptions) {
        FrameworkSupportOptionsComponent component = this.myInitializedOptionsComponents.get((Object)node);
        if (component == null) {
            FrameworkSupportNodeBase parentNode = node.getParentNode();
            if (parentNode instanceof FrameworkSupportNode) {
                this.initializeOptionsPanel((FrameworkSupportNode)parentNode, addToOptions);
            } else if (parentNode instanceof FrameworkGroupNode) {
                this.initializeGroupPanel((FrameworkGroup)((FrameworkGroupNode)parentNode).getUserObject(), addToOptions);
            }
            component = new FrameworkSupportOptionsComponent(this.myModel, this.myLibrariesContainer, this, (FrameworkSupportInModuleProvider)node.getUserObject(), node.getConfigurable());
            if (addToOptions) {
                this.myOptionsPanel.add(node.getId(), AddSupportForFrameworksPanel.wrapInScrollPane(component.getMainPanel()));
            }
            this.myInitializedOptionsComponents.put(node, component);
        }
        return component;
    }

    private static JScrollPane wrapInScrollPane(JPanel panel) {
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add(panel);
        wrapper.setBorder(IdeBorderFactory.createEmptyBorder((int)5));
        return ScrollPaneFactory.createScrollPane((Component)wrapper, (int)20, (int)31);
    }

    private void showCard(String cardName) {
        ((CardLayout)this.myOptionsPanel.getLayout()).show(this.myOptionsPanel, cardName);
    }

    private List<LibraryCompositionSettings> getLibrariesCompositionSettingsList() {
        ArrayList<LibraryCompositionSettings> list = new ArrayList<LibraryCompositionSettings>();
        List<FrameworkSupportNode> selected = this.getSelectedNodes();
        for (FrameworkSupportNode node : selected) {
            ContainerUtil.addIfNotNull(list, (Object)this.getLibraryCompositionSettings(node));
        }
        return list;
    }

    @Nullable
    private LibraryCompositionSettings getLibraryCompositionSettings(FrameworkSupportNode node) {
        FrameworkSupportOptionsComponent optionsComponent = this.myInitializedOptionsComponents.get((Object)node);
        return optionsComponent != null ? optionsComponent.getLibraryCompositionSettings() : null;
    }

    public boolean downloadLibraries() {
        final Ref result2 = Ref.create((Object)true);
        DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

            @Override
            public void run() {
                AddSupportForFrameworksPanel.this.applyLibraryOptionsForSelected();
                List list = AddSupportForFrameworksPanel.this.getLibrariesCompositionSettingsList();
                for (LibraryCompositionSettings compositionSettings : list) {
                    if (compositionSettings.downloadFiles(AddSupportForFrameworksPanel.this.myMainPanel)) continue;
                    result2.set((Object)false);
                    return;
                }
            }
        });
        return (Boolean)result2.get();
    }

    private Collection<FrameworkSupportNodeBase> createNodes(List<FrameworkSupportInModuleProvider> providers, Set<String> associated, final Set<String> preselected) {
        HashMap<String, FrameworkSupportNode> nodes = new HashMap<String, FrameworkSupportNode>();
        HashMap groups = new HashMap();
        ArrayList<FrameworkSupportNodeBase> roots = new ArrayList<FrameworkSupportNodeBase>();
        LinkedHashMap<String, FrameworkSupportNodeBase> associatedNodes = new LinkedHashMap<String, FrameworkSupportNodeBase>();
        for (FrameworkSupportInModuleProvider provider : providers) {
            this.createNode(provider, nodes, groups, roots, providers, associated, associatedNodes);
        }
        FrameworkSupportNodeBase.sortByName(roots, new Comparator<FrameworkSupportNodeBase>(){

            @Override
            public int compare(FrameworkSupportNodeBase o1, FrameworkSupportNodeBase o2) {
                return Comparing.compare((boolean)preselected.contains(o2.getId()), (boolean)preselected.contains(o1.getId()));
            }
        });
        this.myRoots = roots;
        return associatedNodes.values();
    }

    @Nullable
    private FrameworkSupportNode createNode(FrameworkSupportInModuleProvider provider, Map<String, FrameworkSupportNode> nodes, Map<FrameworkGroup<?>, FrameworkGroupNode> groupNodes, List<FrameworkSupportNodeBase> roots, List<FrameworkSupportInModuleProvider> providers, Set<String> associated, Map<String, FrameworkSupportNodeBase> associatedNodes) {
        String id = provider.getFrameworkType().getId();
        FrameworkSupportNode node = nodes.get(id);
        if (node != null || associatedNodes.containsKey(id)) {
            return node;
        }
        String underlyingTypeId = provider.getFrameworkType().getUnderlyingFrameworkTypeId();
        FrameworkSupportNodeBase parentNode = null;
        FrameworkGroup<?> group = provider.getFrameworkType().getParentGroup();
        if (underlyingTypeId != null) {
            FrameworkSupportInModuleProvider parentProvider = FrameworkSupportUtil.findProvider(underlyingTypeId, providers);
            if (parentProvider == null) {
                LOG.info("Cannot find id = " + underlyingTypeId);
                return null;
            }
            parentNode = this.createNode(parentProvider, nodes, groupNodes, roots, providers, associated, associatedNodes);
        } else if (group != null && (parentNode = (FrameworkSupportNodeBase)groupNodes.get(group)) == null) {
            FrameworkGroupNode groupNode = new FrameworkGroupNode(group, null);
            if (associated.contains(groupNode.getId())) {
                associatedNodes.put(groupNode.getId(), groupNode);
            } else {
                groupNodes.put(group, groupNode);
                parentNode = groupNode;
                roots.add(groupNode);
            }
        }
        node = new FrameworkSupportNode(provider, parentNode, this.myModel, this);
        if (associated.contains(id)) {
            associatedNodes.put(id, node);
        } else {
            nodes.put(id, node);
            if (parentNode == null) {
                roots.add(node);
            }
        }
        return node;
    }

    public JComponent getMainPanel() {
        return this.myMainPanel;
    }

    public FrameworksTree getFrameworksTree() {
        return this.myFrameworksTree;
    }

    public boolean hasSelectedFrameworks() {
        return !this.getSelectedNodes().isEmpty();
    }

    public List<FrameworkSupportNode> getSelectedNodes() {
        ArrayList<FrameworkSupportNode> list = new ArrayList<FrameworkSupportNode>();
        if (this.myRoots != null) {
            AddSupportForFrameworksPanel.addChildFrameworks(this.myRoots, list);
        }
        list.addAll(ContainerUtil.mapNotNull(this.myAssociatedFrameworks, (Function)new Function.InstanceOf(FrameworkSupportNode.class)));
        return list;
    }

    private static void addChildFrameworks(List<FrameworkSupportNodeBase> list, List<FrameworkSupportNode> result2) {
        for (FrameworkSupportNodeBase node : list) {
            if (!node.isChecked() && !(node instanceof FrameworkGroupNode)) continue;
            if (node instanceof FrameworkSupportNode) {
                result2.add((FrameworkSupportNode)node);
            }
            AddSupportForFrameworksPanel.addChildFrameworks(node.getChildren(), result2);
        }
    }

    public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ide/util/newProjectWizard/AddSupportForFrameworksPanel", "addSupport"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/ide/util/newProjectWizard/AddSupportForFrameworksPanel", "addSupport"));
        }
        ArrayList<Library> addedLibraries = new ArrayList<Library>();
        List<FrameworkSupportNode> selectedFrameworks = this.getSelectedNodes();
        this.sortFrameworks(selectedFrameworks);
        ArrayList<FrameworkSupportConfigurable> selectedConfigurables = new ArrayList<FrameworkSupportConfigurable>();
        IdeaModifiableModelsProvider modifiableModelsProvider = new IdeaModifiableModelsProvider();
        for (FrameworkSupportNode node : selectedFrameworks) {
            LibraryCompositionSettings settings;
            Library library;
            FrameworkSupportInModuleConfigurable configurable = node.getConfigurable();
            if (configurable instanceof OldFrameworkSupportProviderWrapper.FrameworkSupportConfigurableWrapper) {
                selectedConfigurables.add(((OldFrameworkSupportProviderWrapper.FrameworkSupportConfigurableWrapper)configurable).getConfigurable());
            }
            Library library2 = library = (settings = this.getLibraryCompositionSettings(node)) != null ? settings.addLibraries(rootModel, addedLibraries, this.myLibrariesContainer) : null;
            if (configurable instanceof OldFrameworkSupportProviderWrapper.FrameworkSupportConfigurableWrapper) {
                ((OldFrameworkSupportProviderWrapper.FrameworkSupportConfigurableWrapper)configurable).getConfigurable().addSupport(module, rootModel, library);
                continue;
            }
            configurable.addSupport(module, rootModel, modifiableModelsProvider);
        }
        for (FrameworkSupportNode node : selectedFrameworks) {
            FrameworkSupportProvider oldProvider;
            FrameworkSupportInModuleProvider provider = (FrameworkSupportInModuleProvider)node.getUserObject();
            if (!(provider instanceof OldFrameworkSupportProviderWrapper) || !((oldProvider = ((OldFrameworkSupportProviderWrapper)provider).getProvider()) instanceof FacetBasedFrameworkSupportProvider) || addedLibraries.isEmpty()) continue;
            ((FacetBasedFrameworkSupportProvider)oldProvider).processAddedLibraries(module, addedLibraries);
        }
        for (FrameworkSupportCommunicator communicator : (FrameworkSupportCommunicator[])FrameworkSupportCommunicator.EP_NAME.getExtensions()) {
            communicator.onFrameworkSupportAdded(module, rootModel, selectedConfigurables, this.myModel);
        }
    }

    private void sortFrameworks(List<FrameworkSupportNode> nodes) {
        final Comparator<FrameworkSupportInModuleProvider> comparator2 = FrameworkSupportUtil.getFrameworkSupportProvidersComparator(this.myProviders);
        Collections.sort(nodes, new Comparator<FrameworkSupportNode>(){

            @Override
            public int compare(FrameworkSupportNode o1, FrameworkSupportNode o2) {
                return comparator2.compare(o1.getUserObject(), o2.getUserObject());
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ProjectBundle").getString("label.text.please.select.desired.technologies"));
        Font font = jLabel.getFont();
        jLabel.setFont(new Font(font.getName(), font.getStyle(), font.getSize()));
        ((Component)jLabel).setEnabled(true);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFrameworksPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

