/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullProducer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.MessageDecoder;

public final class SocketLock {
    private static final String PORT_FILE = "port";
    private static final String PORT_LOCK_FILE = "port.lock";
    private static final String TOKEN_FILE = "token";
    private static final String ACTIVATE_COMMAND = "activate ";
    private static final String PATHS_EOT_RESPONSE = "---";
    private static final String OK_RESPONSE = "ok";
    private final String myConfigPath;
    private final String mySystemPath;
    private final AtomicReference<Consumer<List<String>>> myActivateListener;
    private String myToken;
    private BuiltInServer myServer;

    public SocketLock(@NotNull String configPath, @NotNull String systemPath) {
        if (configPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "com/intellij/idea/SocketLock", "<init>"));
        }
        if (systemPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemPath", "com/intellij/idea/SocketLock", "<init>"));
        }
        this.myActivateListener = new AtomicReference();
        this.myConfigPath = SocketLock.canonicalPath(configPath);
        this.mySystemPath = SocketLock.canonicalPath(systemPath);
    }

    public void setExternalInstanceListener(@Nullable Consumer<List<String>> consumer) {
        this.myActivateListener.set(consumer);
    }

    public void dispose() {
        SocketLock.log("enter: dispose()", new Object[0]);
        BuiltInServer server = this.myServer;
        if (server == null) {
            return;
        }
        try {
            Disposer.dispose((Disposable)server);
        }
        catch (Throwable throwable) {
            try {
                this.underLocks(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        FileUtil.delete((File)new File(SocketLock.this.myConfigPath, SocketLock.PORT_FILE));
                        FileUtil.delete((File)new File(SocketLock.this.mySystemPath, SocketLock.PORT_FILE));
                        FileUtil.delete((File)new File(SocketLock.this.mySystemPath, SocketLock.TOKEN_FILE));
                        return null;
                    }
                });
            }
            catch (Exception e) {
                Logger.getInstance(SocketLock.class).warn((Throwable)e);
            }
            throw throwable;
        }
        try {
            this.underLocks(new /* invalid duplicate definition of identical inner class */);
        }
        catch (Exception e) {
            Logger.getInstance(SocketLock.class).warn((Throwable)e);
        }
    }

    @Nullable
    public BuiltInServer getServer() {
        return this.myServer;
    }

    @NotNull
    public ActivateStatus lock() throws Exception {
        ActivateStatus activateStatus = this.lock(ArrayUtil.EMPTY_STRING_ARRAY);
        if (activateStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "lock"));
        }
        return activateStatus;
    }

    @NotNull
    public ActivateStatus lock(final @NotNull String[] args) throws Exception {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/idea/SocketLock", "lock"));
        }
        SocketLock.log("enter: lock(config=%s system=%s)", this.myConfigPath, this.mySystemPath);
        ActivateStatus activateStatus = this.underLocks(new Callable<ActivateStatus>(){

            @Override
            public ActivateStatus call() throws Exception {
                File portMarkerC = new File(SocketLock.this.myConfigPath, SocketLock.PORT_FILE);
                File portMarkerS = new File(SocketLock.this.mySystemPath, SocketLock.PORT_FILE);
                List ports = ContainerUtil.newSmartList();
                SocketLock.addExistingPort(portMarkerC, ports);
                SocketLock.addExistingPort(portMarkerS, ports);
                if (!ports.isEmpty()) {
                    Iterator iterator = ports.iterator();
                    while (iterator.hasNext()) {
                        int port = (Integer)iterator.next();
                        ActivateStatus status = SocketLock.tryActivate(port, SocketLock.this.myConfigPath, SocketLock.this.mySystemPath, args);
                        if (status == ActivateStatus.NO_INSTANCE) continue;
                        return status;
                    }
                }
                SocketLock.this.myToken = UUID.randomUUID().toString();
                final String[] lockedPaths = new String[]{SocketLock.this.myConfigPath, SocketLock.this.mySystemPath};
                int workerCount = PlatformUtils.isIdeaCommunity() || PlatformUtils.isDatabaseIDE() || PlatformUtils.isCidr() ? 1 : 2;
                SocketLock.this.myServer = BuiltInServer.startNioOrOio(workerCount, 6942, 50, false, new NotNullProducer<ChannelHandler>(){

                    @NotNull
                    public ChannelHandler produce() {
                        MyChannelInboundHandler myChannelInboundHandler = new MyChannelInboundHandler(lockedPaths, SocketLock.this.myActivateListener, SocketLock.this.myToken);
                        if (myChannelInboundHandler == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock$2$1", "produce"));
                        }
                        return myChannelInboundHandler;
                    }
                });
                byte[] portBytes = Integer.toString(SocketLock.this.myServer.getPort()).getBytes(CharsetToolkit.UTF8_CHARSET);
                FileUtil.writeToFile((File)portMarkerC, (byte[])portBytes);
                FileUtil.writeToFile((File)portMarkerS, (byte[])portBytes);
                File tokenFile = new File(SocketLock.this.mySystemPath, SocketLock.TOKEN_FILE);
                FileUtil.writeToFile((File)tokenFile, (byte[])SocketLock.this.myToken.getBytes(CharsetToolkit.UTF8_CHARSET));
                if (SystemInfo.isUnix) {
                    tokenFile.setReadable(false, false);
                    tokenFile.setWritable(false, false);
                    tokenFile.setReadable(true, true);
                    tokenFile.setWritable(true, true);
                }
                SocketLock.log("exit: lock(): succeed", new Object[0]);
                return ActivateStatus.NO_INSTANCE;
            }
        });
        if (activateStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "lock"));
        }
        return activateStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V underLocks(@NotNull Callable<V> action) throws Exception {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/idea/SocketLock", "underLocks"));
        }
        FileUtilRt.createDirectory((File)new File(this.myConfigPath));
        FileOutputStream lock1 = new FileOutputStream(new File(this.myConfigPath, PORT_LOCK_FILE), true);
        try {
            V v;
            FileUtilRt.createDirectory((File)new File(this.mySystemPath));
            FileOutputStream lock2 = new FileOutputStream(new File(this.mySystemPath, PORT_LOCK_FILE), true);
            try {
                v = action.call();
            }
            catch (Throwable throwable) {
                lock2.close();
                throw throwable;
            }
            lock2.close();
            return v;
        }
        finally {
            lock1.close();
        }
    }

    private static void addExistingPort(@NotNull File portMarker, @NotNull List<Integer> ports) {
        if (portMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "portMarker", "com/intellij/idea/SocketLock", "addExistingPort"));
        }
        if (ports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ports", "com/intellij/idea/SocketLock", "addExistingPort"));
        }
        if (portMarker.exists()) {
            try {
                int port = Integer.parseInt(FileUtilRt.loadFile((File)portMarker));
                if (!ports.contains(port)) {
                    ports.add(port);
                }
            }
            catch (Exception e) {
                SocketLock.log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static ActivateStatus tryActivate(int portNumber, @NotNull String configPath, @NotNull String systemPath, @NotNull String[] args) {
        if (configPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", new Object[]{"configPath", "com/intellij/idea/SocketLock", "tryActivate"}));
        }
        if (systemPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", new Object[]{"systemPath", "com/intellij/idea/SocketLock", "tryActivate"}));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", new Object[]{"args", "com/intellij/idea/SocketLock", "tryActivate"}));
        }
        SocketLock.log("trying: port=%s", new Object[]{portNumber});
        try {
            socket = new Socket(NetUtils.getLoopbackAddress(), portNumber);
            try {
                socket.setSoTimeout(1000);
                result = false;
                in = new DataInputStream(socket.getInputStream());
                ** try [egrp 2[TRYBLOCK] [0 : 174->233)] { 
lbl15:
                // 1 sources

                ** GOTO lbl-1000
            }
            catch (Throwable var11_14) {
                throw var11_14;
lbl-1000:
                // 1 sources

                {
                    while (true) {
                        path = in.readUTF();
                        SocketLock.log("read: path=%s", new Object[]{path});
                        if (!"---".equals(path)) {
                            if (!configPath.equals(path) && !systemPath.equals(path)) continue;
                            result = true;
                            continue;
                        }
                        break;
                    }
                }
lbl26:
                // 1 sources

                catch (IOException e) {
                    SocketLock.log("read: %s", new Object[]{e.getMessage()});
                }
                if (result) {
                    block18: {
                        token = FileUtil.loadFile((File)new File(systemPath, "token"));
                        out = new DataOutputStream(socket.getOutputStream());
                        out.writeUTF("activate " + token + "\u0000" + new File(".").getAbsolutePath() + "\u0000" + StringUtil.join((String[])args, (String)"\u0000"));
                        out.flush();
                        response = in.readUTF();
                        SocketLock.log("read: response=%s", new Object[]{response});
                        if (!response.equals("ok")) break block18;
                        var10_13 = ActivateStatus.ACTIVATED;
                        socket.close();
                        v0 = var10_13;
                        if (v0 != null) return v0;
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/idea/SocketLock", "tryActivate"}));
                    }
                    ** try [egrp 5[TRYBLOCK] [4 : 437->452)] { 
lbl44:
                    // 1 sources

                    return ActivateStatus.CANNOT_ACTIVATE;
                    catch (IOException e) {
                        SocketLock.log(e);
                    }
                    return ActivateStatus.CANNOT_ACTIVATE;
                }
                socket.close();
            }
lbl50:
            // 1 sources

            finally {
                socket.close();
            }
        }
        catch (IOException e) {
            SocketLock.log(e);
        }
        v1 = ActivateStatus.NO_INSTANCE;
        if (v1 != null) return v1;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/idea/SocketLock", "tryActivate"}));
    }

    @NotNull
    private static String canonicalPath(@NotNull String configPath) {
        String string;
        if (configPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "com/intellij/idea/SocketLock", "canonicalPath"));
        }
        try {
            string = new File(configPath).getCanonicalPath();
        }
        catch (IOException ignore) {
            String string2 = configPath;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "canonicalPath"));
            }
            return string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "canonicalPath"));
        }
        return string;
    }

    private static void log(Exception e) {
        Logger.getInstance(SocketLock.class).warn((Throwable)e);
    }

    private static void log(String format, Object ... args) {
        Logger logger = Logger.getInstance(SocketLock.class);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format(format, args));
        }
    }

    private static class MyChannelInboundHandler
    extends MessageDecoder {
        private final String[] myLockedPaths;
        private final AtomicReference<Consumer<List<String>>> myActivateListener;
        private final String myToken;
        private State myState;

        public MyChannelInboundHandler(@NotNull String[] lockedPaths, @NotNull AtomicReference<Consumer<List<String>>> activateListener, @NotNull String token) {
            if (lockedPaths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lockedPaths", "com/intellij/idea/SocketLock$MyChannelInboundHandler", "<init>"));
            }
            if (activateListener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activateListener", "com/intellij/idea/SocketLock$MyChannelInboundHandler", "<init>"));
            }
            if (token == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", SocketLock.TOKEN_FILE, "com/intellij/idea/SocketLock$MyChannelInboundHandler", "<init>"));
            }
            this.myState = State.HEADER;
            this.myLockedPaths = lockedPaths;
            this.myActivateListener = activateListener;
            this.myToken = token;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelActive(ChannelHandlerContext context) throws Exception {
            ByteBuf buffer = context.alloc().ioBuffer(1024);
            boolean success = false;
            try {
                ByteBufOutputStream out = new ByteBufOutputStream(buffer);
                for (String path : this.myLockedPaths) {
                    out.writeUTF(path);
                }
                out.writeUTF(SocketLock.PATHS_EOT_RESPONSE);
                out.close();
                success = true;
            }
            finally {
                if (!success) {
                    buffer.release();
                }
            }
            context.writeAndFlush((Object)buffer);
        }

        @Override
        protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull ByteBuf input) throws Exception {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/idea/SocketLock$MyChannelInboundHandler", "messageReceived"));
            }
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/idea/SocketLock$MyChannelInboundHandler", "messageReceived"));
            }
            while (true) {
                switch (this.myState) {
                    case HEADER: {
                        ByteBuf buffer = this.getBufferIfSufficient(input, 2, context);
                        if (buffer == null) {
                            return;
                        }
                        this.contentLength = buffer.readUnsignedShort();
                        if (this.contentLength > 8192) {
                            context.close();
                            return;
                        }
                        this.myState = State.CONTENT;
                        break;
                    }
                    case CONTENT: {
                        CharSequence command = this.readChars(input);
                        if (command == null) {
                            return;
                        }
                        if (StringUtil.startsWith((CharSequence)command, (CharSequence)SocketLock.ACTIVATE_COMMAND) && command.length() <= 8192) {
                            boolean tokenOK;
                            List args = StringUtil.split((String)command.subSequence(SocketLock.ACTIVATE_COMMAND.length(), command.length()).toString(), (String)"\u0000");
                            boolean bl = tokenOK = !args.isEmpty() && this.myToken.equals(args.get(0));
                            if (!tokenOK) {
                                SocketLock.log(new UnsupportedOperationException("unauthorized request: " + command));
                                Notifications.Bus.notify((Notification)new Notification("System Messages", IdeBundle.message((String)"activation.auth.title", (Object[])new Object[0]), IdeBundle.message((String)"activation.auth.message", (Object[])new Object[0]), NotificationType.WARNING));
                            } else {
                                Consumer<List<String>> listener = this.myActivateListener.get();
                                if (listener != null) {
                                    listener.consume(args.subList(1, args.size()));
                                }
                            }
                            ByteBuf buffer = context.alloc().ioBuffer(4);
                            ByteBufOutputStream out = new ByteBufOutputStream(buffer);
                            out.writeUTF(SocketLock.OK_RESPONSE);
                            out.close();
                            context.writeAndFlush((Object)buffer);
                        }
                        context.close();
                    }
                }
            }
        }

        private static enum State {
            HEADER,
            CONTENT;

        }
    }

    public static enum ActivateStatus {
        ACTIVATED,
        NO_INSTANCE,
        CANNOT_ACTIVATE;

    }
}

