/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.CaretStateTransferableData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClipboardTextPerCaretSplitter {
    @NotNull
    public List<String> split(@NotNull String input, @Nullable CaretStateTransferableData caretData, int caretCount) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/openapi/editor/ClipboardTextPerCaretSplitter", "split"));
        }
        if (caretCount <= 0) {
            throw new IllegalArgumentException("Caret count must be positive");
        }
        if (caretCount == 1) {
            List<String> list = Collections.singletonList(input);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ClipboardTextPerCaretSplitter", "split"));
            }
            return list;
        }
        ArrayList<String> result2 = new ArrayList<String>(caretCount);
        int sourceCaretCount = caretData == null ? -1 : caretData.startOffsets.length;
        String[] lines = sourceCaretCount == 1 || sourceCaretCount == caretCount ? null : input.split("\n", -1);
        for (int i = 0; i < caretCount; ++i) {
            if (sourceCaretCount == 1) {
                result2.add(input);
                continue;
            }
            if (sourceCaretCount == caretCount) {
                result2.add(new String(input.substring(caretData.startOffsets[i], caretData.endOffsets[i])));
                continue;
            }
            if (lines.length == 0) {
                result2.add("");
                continue;
            }
            if (lines.length == 1) {
                result2.add(lines[0]);
                continue;
            }
            if (lines.length % caretCount == 0) {
                StringBuilder b = new StringBuilder();
                int linesPerSegment = lines.length / caretCount;
                for (int j = 0; j < linesPerSegment; ++j) {
                    if (j > 0) {
                        b.append('\n');
                    }
                    b.append(lines[i * linesPerSegment + j]);
                }
                result2.add(b.toString());
                continue;
            }
            result2.add(i < lines.length ? lines[i] : "");
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ClipboardTextPerCaretSplitter", "split"));
        }
        return arrayList;
    }
}

