/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectSetProcessor;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OpenProjectSetProcessor
extends ProjectSetProcessor {
    public String getId() {
        return "project";
    }

    public void processEntries(@NotNull List<Pair<String, String>> entries, @NotNull ProjectSetProcessor.Context context, @NotNull Runnable runNext) {
        Project project;
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/openapi/vcs/OpenProjectSetProcessor", "processEntries"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/OpenProjectSetProcessor", "processEntries"));
        }
        if (runNext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runNext", "com/intellij/openapi/vcs/OpenProjectSetProcessor", "processEntries"));
        }
        final String root = context.directory == null || context.directoryName == null ? null : context.directory.getPath() + "/" + context.directoryName;
        for (final Pair<String, String> entry : entries) {
            if (!"project".equals(entry.getFirst())) continue;
            context.project = (Project)UIUtil.invokeAndWaitIfNeeded((Computable)new Computable<Project>(){

                public Project compute() {
                    String path;
                    String string = path = root == null ? (String)entry.getSecond() : root + "/" + (String)entry.getSecond();
                    if (!OpenProjectSetProcessor.warnAboutOpening(path)) {
                        return null;
                    }
                    return ProjectUtil.openProject(path, null, true);
                }
            });
            if (context.project != null) {
                runNext.run();
            }
            return;
        }
        if (!OpenProjectSetProcessor.warnAboutOpening(root)) {
            return;
        }
        VirtualFile dir = LocalFileSystem.getInstance().refreshAndFindFileByPath(root);
        if (dir != null && (project = PlatformProjectOpenProcessor.getInstance().doOpenProject(dir, null, false)) != null) {
            runNext.run();
        }
    }

    private static boolean warnAboutOpening(String path) {
        boolean remotePath;
        return RecentProjectsManager.getInstance().hasPath(path) || ProjectUtil.confirmLoadingFromRemotePath(path, (remotePath = ProjectUtil.isRemotePath(path)) ? "warning.load.project.from.share" : "warning.load.local.project", remotePath ? "title.load.project.from.share" : "title.load.local.project");
    }
}

