/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.OutOfSourcesChecker;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckinHandlerUtil {
    public static List<VirtualFile> filterOutGeneratedAndExcludedFiles(@NotNull Collection<VirtualFile> files, @NotNull Project project) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil", "filterOutGeneratedAndExcludedFiles"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil", "filterOutGeneratedAndExcludedFiles"));
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(files.size());
        for (VirtualFile file2 : files) {
            if (fileIndex.isExcluded(file2) || GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file2, (Project)project)) continue;
            result2.add(file2);
        }
        return result2;
    }

    public static PsiFile[] getPsiFiles(Project project, Collection<VirtualFile> selectedFiles) {
        VirtualFile baseDir;
        ArrayList<PsiFile> result2 = new ArrayList<PsiFile>();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        VirtualFile projectFileDir = null;
        if (ProjectUtil.isDirectoryBased(project) && (baseDir = project.getBaseDir()) != null) {
            projectFileDir = baseDir.findChild(".idea");
        }
        for (VirtualFile file2 : selectedFiles) {
            PsiFile psiFile;
            if (!file2.isValid() || CheckinHandlerUtil.isUnderProjectFileDir(projectFileDir, file2) || !CheckinHandlerUtil.isFileUnderSourceRoot(project, file2) || CheckinHandlerUtil.isOutOfSources(project, file2) || (psiFile = psiManager.findFile(file2)) == null) continue;
            result2.add(psiFile);
        }
        return PsiUtilCore.toPsiFileArray(result2);
    }

    private static boolean isUnderProjectFileDir(@Nullable VirtualFile projectFileDir, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil", "isUnderProjectFileDir"));
        }
        return projectFileDir != null && VfsUtilCore.isAncestor((VirtualFile)projectFileDir, (VirtualFile)file2, (boolean)false);
    }

    private static boolean isFileUnderSourceRoot(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil", "isFileUnderSourceRoot"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil", "isFileUnderSourceRoot"));
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return index.isInContent(file2) && !index.isInLibrarySource(file2);
    }

    private static boolean isOutOfSources(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil", "isOutOfSources"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil", "isOutOfSources"));
        }
        for (OutOfSourcesChecker checker : (OutOfSourcesChecker[])OutOfSourcesChecker.EP_NAME.getExtensions()) {
            if (checker.getFileType() != file2.getFileType() || !checker.isOutOfSources(project, file2)) continue;
            return true;
        }
        return false;
    }

    static void disableWhenDumb(@NotNull Project project, @NotNull JCheckBox checkBox, @NotNull String tooltip) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil", "disableWhenDumb"));
        }
        if (checkBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkBox", "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil", "disableWhenDumb"));
        }
        if (tooltip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tooltip", "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil", "disableWhenDumb"));
        }
        boolean dumb = DumbService.isDumb((Project)project);
        checkBox.setEnabled(!dumb);
        checkBox.setToolTipText(dumb ? tooltip : "");
    }
}

