/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.refResolve;

import com.intellij.openapi.Disposable;
import com.intellij.util.ArrayUtil;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

class PersistentIntList
implements Disposable {
    public static final int MAX_DATA_BYTES = 500000000;
    public static final int MAX_LIST_LENGTH = 100000000;
    private final FileChannel data;
    public int gap;
    private IntArray pointers;
    private final Empty EMPTY;

    public PersistentIntList(@NotNull File dataFile, int initialSize) throws IOException {
        int pointersBase;
        if (dataFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFile", "com/intellij/psi/refResolve/PersistentIntList", "<init>"));
        }
        this.data = new RandomAccessFile(dataFile, "rw").getChannel();
        int initialCapacity = Math.min((initialSize + 1) * 2, initialSize + 256);
        if (initialSize == 0) {
            pointersBase = PersistentIntList.readInt(this.data, 0);
        } else {
            PersistentIntList.writeInt(this.data, 0, 4);
            PersistentIntList.writeInt(this.data, 4, initialSize);
            PersistentIntList.writeInt(this.data, 8, initialCapacity);
            PersistentIntList.fillWithZeros(this.data, 12, initialCapacity * 4);
            pointersBase = 4;
        }
        this.pointers = new IntArray(this.data, pointersBase);
        if (initialSize != 0) {
            assert (this.pointers.size == initialSize);
            assert (this.pointers.capacity == initialCapacity);
            assert (this.pointers.base == 4);
        }
        this.EMPTY = new Empty(this.data);
    }

    public synchronized int getSize() {
        return this.pointers.size;
    }

    private static void fillWithZeros(FileChannel data, int from, int length) throws IOException {
        ByteBuffer zeros = ByteBuffer.allocateDirect(Math.min(8192, length));
        while (length > 0) {
            ByteBuffer toWrite = length < zeros.limit() ? ByteBuffer.allocateDirect(length) : zeros;
            toWrite.position(0);
            int written = data.write(toWrite, from);
            length -= written;
            from += written;
        }
    }

    private static void writeInt(FileChannel data, int off, int value) throws IOException {
        ByteBuffer b = ByteBuffer.allocate(4);
        b.putInt(0, value);
        data.write(b, off);
    }

    private static int readInt(FileChannel data, int off) throws IOException {
        ByteBuffer b = ByteBuffer.allocate(4);
        int read = data.read(b, off);
        if (read != 4) {
            throw new IOException(read + " bytes instead of 4");
        }
        return b.getInt(0);
    }

    public void dispose() {
        try {
            this.data.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public synchronized int[] get(int id) {
        block4: {
            block5: {
                PersistentIntList.assertPointer(id);
                try {
                    if (id < this.pointers.size) break block4;
                    if (ArrayUtil.EMPTY_INT_ARRAY != null) break block5;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/refResolve/PersistentIntList", "get"));
            }
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
        int arrayBase = this.pointers.get(id);
        IntArray array = arrayBase == 0 ? this.EMPTY : new IntArray(this.data, arrayBase);
        int[] nArray = array.toArray();
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/refResolve/PersistentIntList", "get"));
        }
        return nArray;
    }

    public synchronized void addAll(int id, @NotNull int[] values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/psi/refResolve/PersistentIntList", "addAll"));
        }
        assert (0 < values.length && values.length <= 100000000) : values.length;
        assert (id > 0);
        Arrays.sort(values);
        try {
            int arrayBase;
            IntArray array;
            IntArray newArray;
            if (id >= this.pointers.size) {
                this.pointers = this.pointers.reallocWith(this.pointers.toBuffer(), id + 1);
                PersistentIntList.writeInt(this.data, 0, this.pointers.base);
                assert (this.pointers.size > id) : id + " > " + IntArray.access$000(this.pointers);
            }
            if ((newArray = (array = (arrayBase = this.pointers.get(id)) == 0 ? this.EMPTY : new IntArray(this.data, arrayBase)).addAll(values)) != null) {
                this.pointers.put(id, newArray.base);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int[] ids = this.get(id);
        PersistentIntList.assertSorted(ids);
        TIntHashSet set = new TIntHashSet(ids);
        assert (set.containsAll(values)) : "ids: " + Arrays.toString(ids) + ";\n values:" + Arrays.toString(values);
    }

    private static void assertSorted(int[] oldIds) {
        for (int i = 1; i < oldIds.length; ++i) {
            assert (oldIds[i - 1] < oldIds[i]) : oldIds[i - 1] + ", " + oldIds[i];
        }
    }

    private static int[] fromBytes(@NotNull ByteBuffer bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/psi/refResolve/PersistentIntList", "fromBytes"));
        }
        IntBuffer intBuffer = bytes.asIntBuffer();
        int[] result2 = new int[intBuffer.limit()];
        intBuffer.get(result2);
        return result2;
    }

    private static void assertPointer(int pointer) {
        assert (0 < pointer && pointer <= 500000000) : pointer;
    }

    public synchronized void flush() throws IOException {
        this.data.force(true);
    }

    private static class IntArray {
        private final FileChannel data;
        private final int base;
        private int size;
        private final int capacity;

        public IntArray(FileChannel data, int base) throws IOException {
            this.data = data;
            this.base = base;
            this.size = PersistentIntList.readInt(data, base);
            this.capacity = PersistentIntList.readInt(data, base + 4);
            this.assertListLength();
        }

        private IntArray(FileChannel data) {
            this.data = data;
            this.base = 0;
            this.size = 0;
            this.capacity = 0;
        }

        public int get(int i) throws IOException {
            if (i < 0 || i >= this.size) {
                throw new IndexOutOfBoundsException("i=" + i + "; size=" + this.size);
            }
            return PersistentIntList.readInt(this.data, this.base + 8 + i * 4);
        }

        public void put(int i, int value) throws IOException {
            if (i < 0 || i >= this.size) {
                throw new IndexOutOfBoundsException("i=" + i + "; size=" + this.size);
            }
            PersistentIntList.writeInt(this.data, this.base + 8 + i * 4, value);
        }

        public IntArray addAll(int[] values) throws IOException {
            int[] old = this.toArray();
            PersistentIntList.assertSorted(old);
            this.assertListLength();
            ByteBuffer mergedBytes = ByteBuffer.allocateDirect(this.size * 4 + values.length * 4);
            int i = 0;
            int j = 0;
            while (i < this.size || j < values.length) {
                int value;
                int stored = i < this.size ? old[i] : Integer.MAX_VALUE;
                int n = value = j < values.length ? values[j] : Integer.MAX_VALUE;
                if (stored < value) {
                    mergedBytes.putInt(stored);
                    ++i;
                    continue;
                }
                if (stored > value) {
                    mergedBytes.putInt(value);
                    ++j;
                    continue;
                }
                mergedBytes.putInt(value);
                ++j;
                ++i;
            }
            mergedBytes.limit(mergedBytes.position());
            mergedBytes.position(0);
            int[] mergedInts = PersistentIntList.fromBytes(mergedBytes);
            PersistentIntList.assertSorted(mergedInts);
            int newSize = mergedInts.length;
            if (newSize > this.capacity) {
                IntArray realloc = this.reallocWith(mergedBytes, newSize);
                assert (realloc.size == newSize);
                return realloc;
            }
            this.data.write(mergedBytes, this.base + 8);
            PersistentIntList.writeInt(this.data, this.base, newSize);
            this.size = newSize;
            this.assertListLength();
            return null;
        }

        private IntArray reallocWith(ByteBuffer bytes, int maxSize) throws IOException {
            assert (maxSize > 0 && maxSize < 100000000) : maxSize;
            int newSize = Math.max(maxSize, bytes.limit() / 4);
            int newCapacity = newSize < 10 ? (newSize + 1) * 2 : newSize * 3 / 2;
            int newBase = (int)this.data.size();
            PersistentIntList.writeInt(this.data, newBase, newSize);
            PersistentIntList.writeInt(this.data, newBase + 4, newCapacity);
            bytes.position(0);
            this.data.write(bytes, newBase + 8);
            PersistentIntList.fillWithZeros(this.data, newBase + 8 + newSize * 4, (newCapacity - newSize) * 4);
            IntArray array = new IntArray(this.data, newBase);
            assert (array.size == newSize);
            assert (array.capacity == newCapacity);
            assert (array.base == newBase);
            array.assertListLength();
            return array;
        }

        public int[] toArray() throws IOException {
            return PersistentIntList.fromBytes(this.toBuffer());
        }

        private ByteBuffer toBuffer() throws IOException {
            this.assertListLength();
            int listLength = this.size;
            ByteBuffer bytes = ByteBuffer.allocateDirect(listLength * 4);
            int read = this.data.read(bytes, this.base + 8);
            if (read != listLength * 4) {
                throw new IOException(read + " instead of " + listLength * 4);
            }
            bytes.position(0);
            assert (bytes.limit() == listLength * 4);
            return bytes;
        }

        void assertListLength() {
            int listLength = this.size;
            assert (0 <= listLength && listLength <= 100000000) : "size = " + listLength + ", capacity=" + this.capacity;
            assert (0 < this.capacity && this.capacity <= 100000000) : "size = " + listLength + ", capacity=" + this.capacity;
            assert (this.capacity >= listLength) : "size = " + listLength + ", capacity=" + this.capacity;
            assert (listLength == 0 || this.capacity <= (listLength + 1) * 2) : "size = " + listLength + ", capacity=" + this.capacity;
        }
    }

    private static class Empty
    extends IntArray {
        public Empty(FileChannel data) {
            super(data);
        }

        @Override
        public int[] toArray() {
            return ArrayUtil.EMPTY_INT_ARRAY;
        }

        @Override
        void assertListLength() {
        }
    }
}

