/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inlineSuperClass;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.inlineSuperClass.InlineSuperClassRefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Collection;

public class InlineSuperClassRefactoringHandler
extends JavaInlineActionHandler {
    public static final String REFACTORING_NAME = "Inline Super Class";

    public boolean isEnabledOnElement(PsiElement element) {
        return element instanceof PsiClass;
    }

    public boolean canInlineElement(PsiElement element) {
        if (!(element instanceof PsiClass)) {
            return false;
        }
        if (element.getLanguage() != StdLanguages.JAVA) {
            return false;
        }
        Collection inheritors = DirectClassInheritorsSearch.search((PsiClass)((PsiClass)element)).findAll();
        return inheritors.size() > 0;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        PsiElement gParent;
        PsiElement parent;
        PsiElement referenceElement;
        PsiElement resolve;
        PsiReference reference;
        PsiClass superClass = (PsiClass)element;
        Collection inheritors = DirectClassInheritorsSearch.search((PsiClass)((PsiClass)element)).findAll();
        if (!superClass.getManager().isInProject((PsiElement)superClass)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Cannot inline non-project class", (String)REFACTORING_NAME, null);
            return;
        }
        for (PsiClass inheritor : inheritors) {
            if (PsiTreeUtil.isAncestor((PsiElement)superClass, (PsiElement)inheritor, (boolean)false)) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)("Cannot inline into the inner class. Move '" + inheritor.getName() + "' to upper level"), (String)REFACTORING_NAME, null);
                return;
            }
            if (!(inheritor instanceof PsiAnonymousClass)) continue;
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Cannot inline into anonymous class.", (String)REFACTORING_NAME, null);
            return;
        }
        PsiClass chosen = null;
        PsiReference psiReference = reference = editor != null ? TargetElementUtil.findReference(editor, editor.getCaretModel().getOffset()) : null;
        if (reference != null && (resolve = reference.resolve()) == superClass && (referenceElement = reference.getElement()) != null && (parent = referenceElement.getParent()) instanceof PsiReferenceList && (gParent = parent.getParent()) instanceof PsiClass && inheritors.contains(gParent)) {
            chosen = (PsiClass)gParent;
        }
        new InlineSuperClassRefactoringDialog(project, superClass, chosen, inheritors.toArray(new PsiClass[inheritors.size()])).show();
    }
}

