/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.CommonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.move.FileReferenceContextUtil;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveMultipleElementsViewDescriptor;
import com.intellij.refactoring.move.moveClassesOrPackages.CommonMoveUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesHelper;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveDirectoryWithClassesProcessor
extends BaseRefactoringProcessor {
    private final PsiDirectory[] myDirectories;
    private final PsiDirectory myTargetDirectory;
    private final boolean mySearchInComments;
    private final boolean mySearchInNonJavaFiles;
    private final Map<PsiFile, TargetDirectoryWrapper> myFilesToMove;
    private final Map<PsiDirectory, TargetDirectoryWrapper> myNestedDirsToMove;
    private NonCodeUsageInfo[] myNonCodeUsages;
    private final MoveCallback myMoveCallback;

    public MoveDirectoryWithClassesProcessor(Project project, PsiDirectory[] directories, PsiDirectory targetDirectory, boolean searchInComments, boolean searchInNonJavaFiles, boolean includeSelf, MoveCallback moveCallback) {
        super(project);
        if (targetDirectory != null) {
            ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>(Arrays.asList(directories));
            Iterator iterator = dirs.iterator();
            while (iterator.hasNext()) {
                PsiDirectory directory = (PsiDirectory)iterator.next();
                if (!targetDirectory.equals(directory.getParentDirectory()) && !targetDirectory.equals(directory)) continue;
                iterator.remove();
            }
            directories = dirs.toArray(new PsiDirectory[dirs.size()]);
        }
        this.myDirectories = directories;
        this.myTargetDirectory = targetDirectory;
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
        this.myMoveCallback = moveCallback;
        this.myFilesToMove = new HashMap<PsiFile, TargetDirectoryWrapper>();
        this.myNestedDirsToMove = new HashMap<PsiDirectory, TargetDirectoryWrapper>();
        for (PsiDirectory dir : directories) {
            MoveDirectoryWithClassesProcessor.collectFiles2Move(this.myFilesToMove, this.myNestedDirsToMove, dir, includeSelf ? dir.getParentDirectory() : dir, this.getTargetDirectory(dir));
        }
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/move/moveClassesOrPackages/MoveDirectoryWithClassesProcessor", "createUsageViewDescriptor"));
        }
        PsiElement[] elements = new PsiElement[this.myFilesToMove.size()];
        PsiFile[] classes = PsiUtilCore.toPsiFileArray(this.myFilesToMove.keySet());
        System.arraycopy(classes, 0, elements, 0, classes.length);
        MoveMultipleElementsViewDescriptor moveMultipleElementsViewDescriptor = new MoveMultipleElementsViewDescriptor(elements, this.getTargetName());
        if (moveMultipleElementsViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/move/moveClassesOrPackages/MoveDirectoryWithClassesProcessor", "createUsageViewDescriptor"));
        }
        return moveMultipleElementsViewDescriptor;
    }

    protected String getTargetName() {
        return RefactoringUIUtil.getDescription((PsiElement)this.getTargetDirectory(null).getTargetDirectory(), false);
    }

    @Override
    @NotNull
    public UsageInfo[] findUsages() {
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (MoveDirectoryWithClassesHelper helper : MoveDirectoryWithClassesHelper.findAll()) {
            helper.findUsages(this.myFilesToMove.keySet(), this.myDirectories, usages, this.mySearchInComments, this.mySearchInNonJavaFiles, this.myProject);
        }
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages(usages.toArray(new UsageInfo[usages.size()]));
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/move/moveClassesOrPackages/MoveDirectoryWithClassesProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/move/moveClassesOrPackages/MoveDirectoryWithClassesProcessor", "preprocessUsages"));
        }
        MultiMap conflicts = new MultiMap();
        for (PsiFile psiFile : this.myFilesToMove.keySet()) {
            try {
                this.myFilesToMove.get(psiFile).checkMove(psiFile);
            }
            catch (IncorrectOperationException e) {
                conflicts.putValue((Object)psiFile, (Object)e.getMessage());
            }
        }
        for (MoveDirectoryWithClassesHelper helper : MoveDirectoryWithClassesHelper.findAll()) {
            helper.preprocessUsages(this.myProject, this.myFilesToMove.keySet(), (UsageInfo[])refUsages.get(), this.myTargetDirectory, (MultiMap<PsiElement, String>)conflicts);
        }
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts, (UsageInfo[])refUsages.get());
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/move/moveClassesOrPackages/MoveDirectoryWithClassesProcessor", "refreshElements"));
        }
    }

    @Override
    public void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/move/moveClassesOrPackages/MoveDirectoryWithClassesProcessor", "performRefactoring"));
        }
        try {
            for (PsiDirectory directory : this.myDirectories) {
                this.getResultDirectory(directory).findOrCreateTargetDirectory();
            }
            for (PsiDirectory directory : this.myNestedDirsToMove.keySet()) {
                this.myNestedDirsToMove.get(directory).findOrCreateTargetDirectory();
            }
            for (PsiFile psiFile : this.myFilesToMove.keySet()) {
                this.myFilesToMove.get(psiFile).findOrCreateTargetDirectory();
            }
        }
        catch (IncorrectOperationException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
            return;
        }
        try {
            ArrayList<PsiFile> movedFiles = new ArrayList<PsiFile>();
            HashMap<PsiElement, PsiElement> oldToNewElementsMapping = new HashMap<PsiElement, PsiElement>();
            for (PsiFile psiFile : this.myFilesToMove.keySet()) {
                MoveDirectoryWithClassesHelper helper;
                boolean processed;
                for (MoveDirectoryWithClassesHelper helper2 : MoveDirectoryWithClassesHelper.findAll()) {
                    helper2.beforeMove(psiFile);
                }
                RefactoringElementListener listener = this.getTransaction().getElementListener((PsiElement)psiFile);
                PsiDirectory psiDirectory = this.myFilesToMove.get(psiFile).getTargetDirectory();
                MoveDirectoryWithClassesHelper[] moveDirectoryWithClassesHelperArray = MoveDirectoryWithClassesHelper.findAll();
                int helper2 = moveDirectoryWithClassesHelperArray.length;
                for (int i = 0; i < helper2 && !(processed = (helper = moveDirectoryWithClassesHelperArray[i]).move(psiFile, psiDirectory, oldToNewElementsMapping, movedFiles, listener)); ++i) {
                }
            }
            for (PsiElement newElement : oldToNewElementsMapping.values()) {
                for (MoveDirectoryWithClassesHelper helper : MoveDirectoryWithClassesHelper.findAll()) {
                    helper.afterMove(newElement);
                }
            }
            for (PsiFile movedFile : movedFiles) {
                MoveFileHandler.forElement(movedFile).updateMovedFile(movedFile);
                FileReferenceContextUtil.decodeFileReferences((PsiElement)movedFile);
            }
            this.myNonCodeUsages = CommonMoveUtil.retargetUsages(usages, oldToNewElementsMapping);
            for (Iterator<Object> iterator : MoveDirectoryWithClassesHelper.findAll()) {
                ((MoveDirectoryWithClassesHelper)((Object)iterator)).postProcessUsages(usages, new Function<PsiDirectory, PsiDirectory>(){

                    public PsiDirectory fun(PsiDirectory dir) {
                        return MoveDirectoryWithClassesProcessor.this.getResultDirectory(dir).getTargetDirectory();
                    }
                });
            }
            for (Iterator<Object> iterator : this.myDirectories) {
                TargetDirectoryWrapper wrapper = this.myNestedDirsToMove.get(iterator);
                PsiDirectory targetDirectory = wrapper.getTargetDirectory();
                if (targetDirectory != null && PsiTreeUtil.isAncestor(iterator, (PsiElement)targetDirectory, (boolean)false)) continue;
                iterator.delete();
            }
        }
        catch (IncorrectOperationException e) {
            this.myNonCodeUsages = new NonCodeUsageInfo[0];
            RefactoringUIUtil.processIncorrectOperation(this.myProject, e);
        }
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.move";
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElements((PsiElement[])this.myDirectories);
        return data;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/move/moveClassesOrPackages/MoveDirectoryWithClassesProcessor", "getAfterData"));
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.myTargetDirectory);
        return data;
    }

    private TargetDirectoryWrapper getResultDirectory(PsiDirectory dir) {
        return this.myTargetDirectory != null ? new TargetDirectoryWrapper(this.myTargetDirectory, dir.getName()) : this.getTargetDirectory(dir);
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        if (this.myNonCodeUsages == null) {
            return;
        }
        RenameUtil.renameNonCodeUsages(this.myProject, this.myNonCodeUsages);
        if (this.myMoveCallback != null) {
            this.myMoveCallback.refactoringCompleted();
        }
    }

    private static void collectFiles2Move(Map<PsiFile, TargetDirectoryWrapper> files2Move, Map<PsiDirectory, TargetDirectoryWrapper> nestedDirsToMove, PsiDirectory directory, PsiDirectory rootDirectory, @NotNull TargetDirectoryWrapper targetDirectory) {
        if (targetDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDirectory", "com/intellij/refactoring/move/moveClassesOrPackages/MoveDirectoryWithClassesProcessor", "collectFiles2Move"));
        }
        PsiElement[] children2 = directory.getChildren();
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)directory.getVirtualFile(), (VirtualFile)rootDirectory.getVirtualFile(), (char)'/');
        TargetDirectoryWrapper newTargetDirectory = relativePath.length() == 0 ? targetDirectory : targetDirectory.findOrCreateChild(relativePath);
        nestedDirsToMove.put(directory, newTargetDirectory);
        for (PsiElement child : children2) {
            if (child instanceof PsiFile) {
                files2Move.put((PsiFile)child, newTargetDirectory);
                continue;
            }
            if (!(child instanceof PsiDirectory)) continue;
            MoveDirectoryWithClassesProcessor.collectFiles2Move(files2Move, nestedDirsToMove, (PsiDirectory)child, directory, newTargetDirectory);
        }
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"moving.directories.command");
    }

    public TargetDirectoryWrapper getTargetDirectory(PsiDirectory dir) {
        return new TargetDirectoryWrapper(this.myTargetDirectory);
    }

    public static class TargetDirectoryWrapper {
        private TargetDirectoryWrapper myParentDirectory;
        private PsiDirectory myTargetDirectory;
        private String myRelativePath;

        public TargetDirectoryWrapper(PsiDirectory targetDirectory) {
            this.myTargetDirectory = targetDirectory;
        }

        public TargetDirectoryWrapper(TargetDirectoryWrapper parentDirectory, String relativePath) {
            this.myParentDirectory = parentDirectory;
            this.myRelativePath = relativePath;
        }

        public TargetDirectoryWrapper(PsiDirectory parentDirectory, String relativePath) {
            this.myTargetDirectory = parentDirectory.findSubdirectory(relativePath);
            this.myParentDirectory = new TargetDirectoryWrapper(parentDirectory);
            this.myRelativePath = relativePath;
        }

        public PsiDirectory findOrCreateTargetDirectory() throws IncorrectOperationException {
            if (this.myTargetDirectory == null) {
                String[] pathComponents;
                PsiDirectory root = this.myParentDirectory.findOrCreateTargetDirectory();
                for (String component : pathComponents = this.myRelativePath.split("/")) {
                    this.myTargetDirectory = root.findSubdirectory(component);
                    if (this.myTargetDirectory == null) {
                        this.myTargetDirectory = root.createSubdirectory(component);
                    }
                    root = this.myTargetDirectory;
                }
            }
            return this.myTargetDirectory;
        }

        @Nullable
        public PsiDirectory getTargetDirectory() {
            return this.myTargetDirectory;
        }

        public TargetDirectoryWrapper findOrCreateChild(String relativePath) {
            PsiDirectory psiDirectory;
            if (this.myTargetDirectory != null && (psiDirectory = this.myTargetDirectory.findSubdirectory(relativePath)) != null) {
                return new TargetDirectoryWrapper(psiDirectory);
            }
            return new TargetDirectoryWrapper(this, relativePath);
        }

        public void checkMove(PsiFile psiFile) throws IncorrectOperationException {
            if (this.myTargetDirectory != null) {
                MoveFilesOrDirectoriesUtil.checkMove((PsiElement)psiFile, (PsiElement)this.myTargetDirectory);
            }
        }
    }
}

