/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiReplacementUtil {
    private static final Logger LOG = Logger.getInstance((String)("#" + PsiReplacementUtil.class.getName()));

    public static void replaceExpression(@NotNull PsiExpression expression, @NotNull @NonNls String newExpressionText) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/PsiReplacementUtil", "replaceExpression"));
        }
        if (newExpressionText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpressionText", "com/siyeh/ig/PsiReplacementUtil", "replaceExpression"));
        }
        Project project = expression.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression newExpression = factory.createExpressionFromText(newExpressionText, (PsiElement)expression);
        PsiElement replacementExpression = expression.replace((PsiElement)newExpression);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        styleManager.reformat(replacementExpression);
    }

    public static PsiElement replaceExpressionAndShorten(@NotNull PsiExpression expression, @NotNull @NonNls String newExpressionText) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/PsiReplacementUtil", "replaceExpressionAndShorten"));
        }
        if (newExpressionText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpressionText", "com/siyeh/ig/PsiReplacementUtil", "replaceExpressionAndShorten"));
        }
        Project project = expression.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression newExpression = factory.createExpressionFromText(newExpressionText, (PsiElement)expression);
        PsiElement replacementExp = expression.replace((PsiElement)newExpression);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        javaCodeStyleManager.shortenClassReferences(replacementExp);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        return styleManager.reformat(replacementExp);
    }

    public static PsiElement replaceStatement(@NotNull PsiStatement statement, @NotNull @NonNls String newStatementText) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/PsiReplacementUtil", "replaceStatement"));
        }
        if (newStatementText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStatementText", "com/siyeh/ig/PsiReplacementUtil", "replaceStatement"));
        }
        Project project = statement.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiStatement newStatement = factory.createStatementFromText(newStatementText, (PsiElement)statement);
        PsiElement replacementExp = statement.replace((PsiElement)newStatement);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        return styleManager.reformat(replacementExp);
    }

    public static void replaceStatementAndShortenClassNames(@NotNull PsiStatement statement, @NotNull @NonNls String newStatementText) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/PsiReplacementUtil", "replaceStatementAndShortenClassNames"));
        }
        if (newStatementText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStatementText", "com/siyeh/ig/PsiReplacementUtil", "replaceStatementAndShortenClassNames"));
        }
        Project project = statement.getProject();
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        JavaCodeStyleManager javaStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        if (FileTypeUtils.isInServerPageFile((PsiElement)statement)) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            PsiFile jspFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)statement);
            if (jspFile == null) {
                return;
            }
            Document document = documentManager.getDocument(jspFile);
            if (document == null) {
                return;
            }
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            TextRange textRange = statement.getTextRange();
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)newStatementText);
            documentManager.commitDocument(document);
            FileViewProvider viewProvider = jspFile.getViewProvider();
            PsiElement elementAt = viewProvider.findElementAt(textRange.getStartOffset(), (Language)JavaLanguage.INSTANCE);
            if (elementAt == null) {
                return;
            }
            int endOffset = textRange.getStartOffset() + newStatementText.length();
            while (elementAt.getTextRange().getEndOffset() < endOffset || !(elementAt instanceof PsiStatement)) {
                if ((elementAt = elementAt.getParent()) != null) continue;
                LOG.error("Cannot decode statement");
                return;
            }
            PsiStatement newStatement = (PsiStatement)elementAt;
            javaStyleManager.shortenClassReferences((PsiElement)newStatement);
            TextRange newTextRange = newStatement.getTextRange();
            Language baseLanguage = viewProvider.getBaseLanguage();
            PsiFile element = viewProvider.getPsi(baseLanguage);
            if (element != null) {
                styleManager.reformatRange((PsiElement)element, newTextRange.getStartOffset(), newTextRange.getEndOffset());
            }
        } else {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = facade.getElementFactory();
            PsiStatement newStatement = factory.createStatementFromText(newStatementText, (PsiElement)statement);
            newStatement = (PsiStatement)statement.replace((PsiElement)newStatement);
            javaStyleManager.shortenClassReferences((PsiElement)newStatement);
            styleManager.reformat((PsiElement)newStatement);
        }
    }

    public static void replaceExpressionWithReferenceTo(@NotNull PsiExpression expression, @NotNull PsiMember target) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/PsiReplacementUtil", "replaceExpressionWithReferenceTo"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/siyeh/ig/PsiReplacementUtil", "replaceExpressionWithReferenceTo"));
        }
        Project project = expression.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiReferenceExpression newExpression = (PsiReferenceExpression)factory.createExpressionFromText("xxx", (PsiElement)expression);
        PsiReferenceExpression replacementExpression = (PsiReferenceExpression)expression.replace((PsiElement)newExpression);
        PsiElement element = replacementExpression.bindToElement((PsiElement)target);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
        styleManager.shortenClassReferences(element);
    }

    @NotNull
    public static String getElementText(@NotNull PsiElement element, @Nullable PsiElement elementToReplace, @Nullable String replacement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/PsiReplacementUtil", "getElementText"));
        }
        StringBuilder out = new StringBuilder();
        PsiReplacementUtil.getElementText(element, elementToReplace, replacement, out);
        String string = out.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/PsiReplacementUtil", "getElementText"));
        }
        return string;
    }

    private static void getElementText(@NotNull PsiElement element, @Nullable PsiElement elementToReplace, @Nullable String replacement, @NotNull StringBuilder out) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/PsiReplacementUtil", "getElementText"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/siyeh/ig/PsiReplacementUtil", "getElementText"));
        }
        if (element.equals(elementToReplace)) {
            out.append(replacement);
            return;
        }
        PsiElement[] children2 = element.getChildren();
        if (children2.length == 0) {
            out.append(element.getText());
            return;
        }
        for (PsiElement child : children2) {
            PsiReplacementUtil.getElementText(child, elementToReplace, replacement, out);
        }
    }
}

