/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.NetUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServer;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandlerKt;
import org.jetbrains.io.NettyKt;
import org.jetbrains.io.Responses;
import org.jetbrains.notification.SingletonNotificationManager;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0017\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001d\u001a*\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0010\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020'\u001a\u0010\u0010&\u001a\u0004\u0018\u00010)2\u0006\u0010(\u001a\u00020)\u001a\b\u0010*\u001a\u00020\u0016H\u0000\u001a\b\u0010+\u001a\u00020\u0016H\u0000\u001a\u0010\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u0001H\u0000\u001a\u001a\u0010.\u001a\u0004\u0018\u00010\u00012\u0006\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u000201H\u0002\u001a \u00102\u001a\u00020\u00162\u0006\u0010!\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u0010\u001f\u001a\u00020 H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u001a\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\"\u000e\u0010\r\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\f\u001a\u0004\b\u0010\u0010\u0011\"N\u0010\u0013\u001aB\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00010\u0001\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00160\u0016 \u0015* \u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00010\u0001\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00160\u0016\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"IDE_TOKEN_FILE", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "STANDARD_COOKIE", "Lio/netty/handler/codec/http/cookie/DefaultCookie;", "getSTANDARD_COOKIE", "()Lio/netty/handler/codec/http/cookie/DefaultCookie;", "STANDARD_COOKIE$delegate", "Lkotlin/Lazy;", "TOKEN_PARAM_NAME", "notificationManager", "Lorg/jetbrains/notification/SingletonNotificationManager;", "getNotificationManager", "()Lorg/jetbrains/notification/SingletonNotificationManager;", "notificationManager$delegate", "tokens", "Lcom/google/common/cache/Cache;", "kotlin.jvm.PlatformType", "", "acquireToken", "canBeAccessedDirectly", "path", "compareNameAndProjectBasePath", "projectName", "project", "Lcom/intellij/openapi/project/Project;", "doProcess", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "projectNameAsHost", "findIndexFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "basedir", "Ljava/io/File;", "isActivatable", "isCookieValidated", "isOwnHostName", "host", "toIdeaPath", "decodedPath", "offset", "", "validateToken", "Lio/netty/handler/codec/http/HttpRequest;", "channel", "Lio/netty/channel/Channel;", "built-in-server"})
public final class BuiltInWebServerKt {
    private static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private static final Logger LOG;
    private static final String IDE_TOKEN_FILE = "user.web.token";
    private static final Lazy<SingletonNotificationManager> notificationManager$delegate;
    @NotNull
    public static final String TOKEN_PARAM_NAME = "__ij-st";
    private static final Lazy<DefaultCookie> STANDARD_COOKIE$delegate;
    private static final Cache<String, Boolean> tokens;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(BuiltInWebServerKt.class, (String)"built-in-server"), "notificationManager", "getNotificationManager()Lorg/jetbrains/notification/SingletonNotificationManager;")), (KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(BuiltInWebServerKt.class, (String)"built-in-server"), "STANDARD_COOKIE", "getSTANDARD_COOKIE()Lio/netty/handler/codec/http/cookie/DefaultCookie;"))};
        LOG = Logger.getInstance(BuiltInWebServer.class);
        notificationManager$delegate = LazyKt.lazy((Function0)notificationManager.2.INSTANCE);
        STANDARD_COOKIE$delegate = LazyKt.lazy((Function0)STANDARD_COOKIE.2.INSTANCE);
        tokens = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    }

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    /*
     * WARNING - void declaration
     */
    private static final SingletonNotificationManager getNotificationManager() {
        void $receiver$iv;
        Lazy<SingletonNotificationManager> lazy = notificationManager$delegate;
        Object var1_1 = null;
        KProperty property$iv = $$delegatedProperties[0];
        return (SingletonNotificationManager)$receiver$iv.getValue();
    }

    public static final boolean isCookieValidated() {
        return Registry.is((String)"ide.built.in.web.server.cookie.validated", (boolean)false);
    }

    public static final boolean isActivatable() {
        return Registry.is((String)"ide.built.in.web.server.activatable", (boolean)false);
    }

    /*
     * WARNING - void declaration
     */
    private static final DefaultCookie getSTANDARD_COOKIE() {
        void $receiver$iv;
        Lazy<DefaultCookie> lazy = STANDARD_COOKIE$delegate;
        Object var1_1 = null;
        KProperty property$iv = $$delegatedProperties[1];
        return (DefaultCookie)$receiver$iv.getValue();
    }

    @NotNull
    public static final String acquireToken() {
        String token = (String)CollectionsKt.firstOrNull((Iterable)tokens.asMap().keySet());
        if (token == null) {
            token = UUID.randomUUID().toString();
            tokens.put((Object)token, (Object)Boolean.TRUE);
        }
        return token;
    }

    /*
     * Unable to fully structure code
     */
    private static final boolean doProcess(QueryStringDecoder urlDecoder, FullHttpRequest request, ChannelHandlerContext context, String projectNameAsHost) {
        block19: {
            decodedPath = URLUtil.unescapePercentSequences((String)urlDecoder.path());
            offset = new Ref.IntRef();
            isEmptyPath = new Ref.BooleanRef();
            isCustomHost = projectNameAsHost != null;
            projectName = new Ref.ObjectRef();
            if (isCustomHost) {
                v0 = projectNameAsHost;
                if (v0 == null) {
                    Intrinsics.throwNpe();
                }
                projectName.element = v0;
                offset.element = 0;
                var9_9 = decodedPath;
                var19_10 = isEmptyPath;
                var19_10.element = var20_11 = $receiver$iv.length() == 0;
            } else {
                offset.element = StringsKt.indexOf$default((CharSequence)decodedPath, (char)'/', (int)1, (boolean)false, (int)4, null);
                $receiver$iv = decodedPath;
                $i$f$isEmpty = true;
                var11_15 = offset.element == -1 ? decodedPath.length() : offset.element;
                var19_10 = projectName;
                v1 = $receiver$iv;
                if (v1 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                v2 = v1.substring((int)startIndex$iv, (int)endIndex$iv);
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                var20_12 = v2;
                var19_10.element = var20_12;
                isEmptyPath.element = offset.element == -1;
            }
            $receiver$iv = new Ref.ObjectRef();
            $receiver$iv.element = null;
            endIndex$iv = ProjectManager.getInstance().getOpenProjects();
            for ($i$f$substring = 0; $i$f$substring < ((void)$receiver$iv).length; ++$i$f$substring) {
                block21: {
                    block22: {
                        block20: {
                            element$iv = $receiver$iv[$i$f$substring];
                            project = (Project)element$iv;
                            if (!project.isDisposed()) break block20;
                            v3 = false;
                            break block21;
                        }
                        name = project.getName();
                        if (!isCustomHost) break block22;
                        if (!StringsKt.equals((String)((String)projectName.element), (String)name, (boolean)true)) ** GOTO lbl-1000
                        if (!SystemInfoRt.isFileSystemCaseSensitive) {
                            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
                            projectName.element = projectName.element;
                        }
                        v3 = true;
                        break block21;
                    }
                    v4 = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"name");
                    if (!StringsKt.regionMatches((String)decodedPath, (int)1, (String)v4, (int)0, (int)name.length(), (boolean)(SystemInfoRt.isFileSystemCaseSensitive == false))) ** GOTO lbl-1000
                    v5 = isEmptyPathCandidate = decodedPath.length() == name.length() + 1;
                    if (isEmptyPathCandidate || decodedPath.charAt(name.length() + 1) == '/') {
                        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
                        projectName.element = projectName.element;
                        offset.element = name.length() + 1;
                        isEmptyPath.element = isEmptyPathCandidate;
                        v3 = true;
                    } else lbl-1000:
                    // 3 sources

                    {
                        if ((Project)candidateByDirectoryName.element == null && BuiltInWebServerKt.compareNameAndProjectBasePath((String)projectName.element, project)) {
                            candidateByDirectoryName.element = project;
                        }
                        v3 = false;
                    }
                }
                if (!v3) continue;
                v6 = element$iv;
                break block19;
            }
            v6 = null;
        }
        if ((v7 = (Project)v6) == null) {
            v7 = (Project)candidateByDirectoryName.element;
        }
        if (v7 == null) {
            return false;
        }
        project = v7;
        if (BuiltInWebServerKt.isActivatable() && !PropertiesComponent.getInstance().getBoolean("ide.built.in.web.server.active")) {
            BuiltInWebServerKt.getNotificationManager().notify("Built-in web server is deactivated, to activate, please use Open in Browser", (Project)null);
            return false;
        }
        if (isEmptyPath.element) {
            v8 = (HttpRequest)request;
            v9 = context.channel();
            Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"context.channel()");
            WebServerPathHandlerKt.redirectToDirectory(v8, v9, (String)projectName.element);
            return true;
        }
        v10 = decodedPath;
        Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"decodedPath");
        path = BuiltInWebServerKt.toIdeaPath(v10, offset.element);
        if (path == null) {
            BuiltInWebServerKt.LOG.warn(decodedPath + " is not valid");
            Responses.sendStatus(HttpResponseStatus.NOT_FOUND, context.channel(), (HttpRequest)request);
            return true;
        }
        v11 = (HttpRequest)request;
        v12 = context.channel();
        Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"context.channel()");
        if (!BuiltInWebServerKt.validateToken(v11, v12, urlDecoder)) {
            return true;
        }
        var14_21 = (WebServerPathHandler[])WebServerPathHandler.Companion.getEP_NAME$built_in_server().getExtensions();
        for (var13_20 = 0; var13_20 < var14_21.length; ++var13_20) {
            pathHandler = var14_21[var13_20];
            name = BuiltInWebServerKt.LOG;
            try {
                v13 = (String)projectName.element;
                v14 = decodedPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"decodedPath");
                if (!pathHandler.process(path, project, request, context, v13, v14, isCustomHost)) continue;
                return true;
            }
            catch (ProcessCanceledException e$iv) {
                continue;
            }
            catch (Throwable e$iv) {
                $receiver$iv.error(e$iv);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean validateToken(HttpRequest request, Channel channel, QueryStringDecoder urlDecoder) {
        Object object;
        if (!BuiltInWebServerKt.isCookieValidated()) {
            return true;
        }
        String cookieString = request.headers().get((CharSequence)HttpHeaderNames.COOKIE);
        if (cookieString != null) {
            Set cookies = ServerCookieDecoder.STRICT.decode(cookieString);
            for (String cookie : cookies) {
                if (!Intrinsics.areEqual((Object)cookie.name(), (Object)BuiltInWebServerKt.getSTANDARD_COOKIE().name())) continue;
                if (!Intrinsics.areEqual((Object)cookie.value(), (Object)BuiltInWebServerKt.getSTANDARD_COOKIE().value())) break;
                return true;
            }
        }
        if ((object = (List)urlDecoder.parameters().get(TOKEN_PARAM_NAME)) == null || (object = (String)CollectionsKt.firstOrNull((List)object)) == null) {
            String string = NettyKt.getReferrer(request);
            if (string != null) {
                void $receiver$iv;
                String cookie;
                cookie = string;
                String it = (String)$receiver$iv;
                List list = (List)new QueryStringDecoder(it).parameters().get(TOKEN_PARAM_NAME);
                object = list != null ? (String)CollectionsKt.firstOrNull((List)list) : null;
            } else {
                object = null;
            }
        }
        Object token = object;
        StringBuilder stringBuilder = new StringBuilder().append(NettyKt.getUriScheme(channel)).append("://");
        String string = NettyKt.getHost(request);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String url = stringBuilder.append(string).append(urlDecoder.path()).toString();
        if (token != null && tokens.getIfPresent(token) != null) {
            tokens.invalidate(token);
            FullHttpResponse response = Responses.response(HttpResponseStatus.TEMPORARY_REDIRECT);
            response.headers().add((CharSequence)HttpHeaderNames.LOCATION, (Object)url);
            response.headers().set((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)ServerCookieEncoder.STRICT.encode((Cookie)BuiltInWebServerKt.getSTANDARD_COOKIE()));
            Responses.send((HttpResponse)response, channel, request);
            return true;
        }
        SwingUtilities.invokeAndWait(new Runnable(url){
            final /* synthetic */ String $url;

            public final void run() {
                ProjectUtil.focusProjectWindow(null, true);
                if (((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"", (String)("Page '" + StringUtil.trimMiddle((String)this.$url, (int)50) + "' requested without authorization, " + "\nyou can copy URL and open it in browser to trust it.")).icon(Messages.getWarningIcon())).yesText("Copy authorization URL to clipboard")).show() == 0) {
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(this.$url + "?" + BuiltInWebServerKt.TOKEN_PARAM_NAME + "=" + BuiltInWebServerKt.acquireToken()));
                }
            }
            {
                this.$url = string;
            }
        });
        Responses.sendStatus(HttpResponseStatus.NOT_FOUND, channel, request);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final String toIdeaPath(String decodedPath, int offset) {
        void startIndex$iv;
        String $receiver$iv = decodedPath;
        String string = $receiver$iv;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.substring(offset);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String path = string2;
        if (!StringsKt.startsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null)) {
            return null;
        }
        $receiver$iv = FileUtil.toCanonicalPath((String)path, (char)'/');
        boolean $i$f$substring = true;
        String string3 = $receiver$iv;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring((int)startIndex$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        return string4;
    }

    public static final boolean compareNameAndProjectBasePath(@NotNull String projectName, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String basePath = project.getBasePath();
        return basePath != null && FileUtilKt.endsWithName(basePath, projectName);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final VirtualFile findIndexFile(@NotNull VirtualFile basedir) {
        void elements$iv;
        VirtualFile[] children2;
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)basedir, (String)"basedir");
                children2 = basedir.getChildren();
                if (children2 == null) break block6;
                Object[] $receiver$iv = children2;
                if (!($receiver$iv.length == 0)) break block7;
            }
            return null;
        }
        String[] stringArray = new String[]{"index.", "default."};
        String[] stringArray2 = (String[])((Object[])elements$iv);
        for (int i = 0; i < stringArray2.length; ++i) {
            String indexNamePrefix = stringArray2[i];
            VirtualFile index = null;
            String preferredName = indexNamePrefix + "html";
            for (int j = 0; j < children2.length; ++j) {
                VirtualFile child = children2[j];
                if (child.isDirectory()) continue;
                String name = child.getName();
                if (Intrinsics.areEqual((Object)name, (Object)preferredName)) {
                    return child;
                }
                if (index != null || !StringsKt.startsWith$default((String)name, (String)indexNamePrefix, (boolean)false, (int)2, null)) continue;
                index = child;
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final File findIndexFile(@NotNull File basedir) {
        void elements$iv;
        File[] children2;
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)basedir, (String)"basedir");
                children2 = basedir.listFiles(findIndexFile.children.1.INSTANCE);
                if (children2 == null) break block6;
                Object[] $receiver$iv = children2;
                if (!($receiver$iv.length == 0)) break block7;
            }
            return null;
        }
        String[] stringArray = new String[]{"index.", "default."};
        String[] stringArray2 = (String[])((Object[])elements$iv);
        for (int i = 0; i < stringArray2.length; ++i) {
            String indexNamePrefix = stringArray2[i];
            File index = null;
            String preferredName = indexNamePrefix + "html";
            for (int j = 0; j < children2.length; ++j) {
                File child = children2[j];
                if (child.isDirectory()) continue;
                String name = child.getName();
                if (Intrinsics.areEqual((Object)name, (Object)preferredName)) {
                    return child;
                }
                if (index != null || !StringsKt.startsWith$default((String)name, (String)indexNamePrefix, (boolean)false, (int)2, null)) continue;
                index = child;
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    public static final boolean isOwnHostName(@NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (NetUtils.isLocalhost((String)host)) {
            return true;
        }
        try {
            InetAddress address = InetAddress.getByName(host);
            if (Intrinsics.areEqual((Object)host, (Object)address.getHostAddress()) || StringsKt.equals((String)host, (String)address.getCanonicalHostName(), (boolean)true)) {
                return true;
            }
            String localHostName = InetAddress.getLocalHost().getHostName();
            return StringsKt.equals((String)localHostName, (String)host, (boolean)true) || StringsKt.endsWith$default((String)host, (String)".local", (boolean)false, (int)2, null) && StringsKt.regionMatches((String)localHostName, (int)0, (String)host, (int)0, (int)(host.length() - ".local".length()), (boolean)true);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static final boolean canBeAccessedDirectly(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        WebServerFileHandler[] webServerFileHandlerArray = (WebServerFileHandler[])WebServerFileHandler.Companion.getEP_NAME$built_in_server().getExtensions();
        for (int i = 0; i < webServerFileHandlerArray.length; ++i) {
            WebServerFileHandler fileHandler = webServerFileHandlerArray[i];
            String[] stringArray = fileHandler.getPageFileExtensions();
            for (int j = 0; j < stringArray.length; ++j) {
                String ext = stringArray[j];
                if (!FileUtilRt.extensionEquals((String)path, (String)ext)) continue;
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean access$doProcess(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context, @Nullable String projectNameAsHost) {
        return BuiltInWebServerKt.doProcess(urlDecoder, request, context, projectNameAsHost);
    }

    @NotNull
    public static final /* synthetic */ String access$getIDE_TOKEN_FILE$p() {
        return IDE_TOKEN_FILE;
    }
}

