/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.StaticFileHandlerKt;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"checkAccess", "", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "channel", "Lio/netty/channel/Channel;", "request", "Lio/netty/handler/codec/http/HttpRequest;", "built-in-server"})
public final class DefaultWebServerPathHandlerKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkAccess(PathInfo pathInfo, Channel channel, HttpRequest request) {
        block9: {
            File file2;
            block8: {
                if (pathInfo.getIoFile() != null) break block8;
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                if (!virtualFile.isInLocalFileSystem()) break block9;
            }
            if ((file2 = pathInfo.getIoFile()) == null) {
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                File file3 = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                file2 = file3;
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"VfsUtilCore.virtualToIoFile(pathInfo.file!!)");
            }
            File file4 = file2;
            if (file4.isDirectory()) {
                Responses.sendStatus(HttpResponseStatus.NOT_FOUND, channel, request);
                return false;
            }
            File file5 = VfsUtilCore.virtualToIoFile((VirtualFile)pathInfo.getRoot());
            Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"VfsUtilCore.virtualToIoFile(pathInfo.root)");
            if (StaticFileHandlerKt.checkAccess(channel, file4, request, file5)) return true;
            return false;
        }
        VirtualFile virtualFile = pathInfo.getFile();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        if (!virtualFile.is(VFileProperty.HIDDEN)) return true;
        Responses.sendStatus(HttpResponseStatus.NOT_FOUND, channel, request);
        return false;
    }

    public static final /* synthetic */ boolean access$checkAccess(@NotNull PathInfo pathInfo, @NotNull Channel channel, @NotNull HttpRequest request) {
        return DefaultWebServerPathHandlerKt.checkAccess(pathInfo, channel, request);
    }
}

