/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerEx;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CharIterator;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.fileClasses.NoResolveFileClassesProvider;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager;
import org.jetbrains.kotlin.idea.debugger.KotlinStackFrame;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches;
import org.jetbrains.kotlin.idea.decompiler.classFile.KtClsFile;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.idea.search.usagesSearch.UtilsKt;
import org.jetbrains.kotlin.idea.util.DebuggerUtils;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00142\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0016H\u0016J\"\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\r2\u0006\u0010(\u001a\u00020)H\u0002J*\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0011\u001a\u00020-2\u0006\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u0006\u0010.\u001a\u00020\rH\u0016J&\u0010/\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u00103\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u00104\u001a\u0002052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u00107\u001a\b\u0012\u0004\u0012\u0002080\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020<H\u0002J\u001a\u0010=\u001a\u0004\u0018\u00010\r2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u00020\r2\u0006\u0010C\u001a\u00020DH\u0002J \u0010E\u001a\u00020\r2\u0006\u00100\u001a\u0002012\u0006\u0010F\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010G\u001a\u0004\u0018\u00010\t2\b\u0010H\u001a\u0004\u0018\u00010\u001aH\u0002J0\u0010I\u001a\u00020J2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010@\u001a\u00020A2\u0006\u0010C\u001a\u00020D2\u0006\u0010K\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010L\u001a\u0004\u0018\u00010\r2\u0006\u0010@\u001a\u00020A2\u0006\u0010M\u001a\u00020?H\u0002J\u0016\u0010N\u001a\u00020\r2\u0006\u0010@\u001a\u00020A2\u0006\u0010O\u001a\u00020PJ\"\u0010Q\u001a\u0004\u0018\u0001012\u0006\u0010(\u001a\u00020)2\u0006\u0010C\u001a\u00020D2\u0006\u0010R\u001a\u00020SH\u0002J\"\u0010T\u001a\u0004\u0018\u00010U2\u0006\u0010(\u001a\u00020)2\u0006\u0010C\u001a\u00020D2\u0006\u0010R\u001a\u00020SH\u0002J\u0012\u0010V\u001a\u0004\u0018\u00010W2\u0006\u0010(\u001a\u00020)H\u0002J\u0014\u0010X\u001a\u0004\u0018\u00010\u00162\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u001e\u0010Y\u001a\b\u0012\u0004\u0012\u00020)0\u00142\u0006\u0010Z\u001a\u0002082\u0006\u0010!\u001a\u00020\u0016H\u0016J\u0010\u0010[\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u0016J\u001a\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010]\u001a\u00020\u0018*\u000208H\u0002J\f\u0010^\u001a\u00020\r*\u00020\rH\u0002R\u001e\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinPositionManager;", "Lcom/intellij/debugger/MultiRequestPositionManager;", "Lcom/intellij/debugger/engine/PositionManagerEx;", "myDebugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "(Lcom/intellij/debugger/engine/DebugProcess;)V", "TYPES_TO_CALCULATE_CLASSNAME", "", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/psi/KtElement;", "[Ljava/lang/Class;", "classNamesForCrossInlineParameters", "", "", "usedParameters", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "classNamesForPosition", "", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "withInlines", "", "element", "Lcom/intellij/psi/PsiElement;", "createPrepareRequest", "Lcom/sun/jdi/request/ClassPrepareRequest;", "classPrepareRequestor", "Lcom/intellij/debugger/requests/ClassPrepareRequestor;", "createPrepareRequests", "requestor", "position", "createStackFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "defaultInternalName", "evaluateCondition", "Lcom/intellij/util/ThreeState;", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "expression", "findCrossInlineArguments", "argument", "Lorg/jetbrains/kotlin/psi/KtFunction;", "parameterDescriptor", "findInlinedCalls", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "findLambdas", "getAllClasses", "Lcom/sun/jdi/ReferenceType;", "getArgumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "it", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "getClassNameForClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "typeMapper", "Lorg/jetbrains/kotlin/codegen/state/JetTypeMapper;", "getClassNameForFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getCrossInlineArgumentClassName", "inlineFunctionName", "getElementToCalculateClassName", "notPositionedElement", "getInternalClassNameForElement", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "isInLibrary", "getJvmInternalNameForImpl", "ktClass", "getJvmInternalNameForPropertyOwner", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getLambdaOrFunIfInside", "lineNumber", "", "getParameterIfInConstructor", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getPsiFileByLocation", "Lcom/intellij/psi/PsiFile;", "getSourcePosition", "locationsOfLine", "type", "originalClassNameForPosition", "containsCrossInlineParameterUsages", "containsKotlinStrata", "substringIndex", "idea"})
public final class KotlinPositionManager
extends PositionManagerEx
implements MultiRequestPositionManager {
    private final Class<? extends KtElement>[] TYPES_TO_CALCULATE_CLASSNAME;
    private final DebugProcess myDebugProcess;

    @Nullable
    public ThreeState evaluateCondition(@NotNull EvaluationContext context, @NotNull StackFrameProxyImpl frame, @NotNull Location location2, @NotNull String expression2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        return ThreeState.UNSURE;
    }

    @Nullable
    public XStackFrame createStackFrame(@NotNull StackFrameProxyImpl frame, @NotNull DebugProcessImpl debugProcess, @NotNull Location location2) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        if (this.containsKotlinStrata(location2.declaringType())) {
            return (XStackFrame)new KotlinStackFrame(frame);
        }
        return null;
    }

    @Nullable
    public SourcePosition getSourcePosition(@Nullable Location location2) {
        int e2;
        if (location2 == null) {
            Throwable throwable = (Throwable)NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
            throw throwable;
        }
        PsiFile psiFile = this.getPsiFileByLocation(location2);
        if (psiFile == null) {
            boolean isKotlinStrataAvailable = this.containsKotlinStrata(location2.declaringType());
            if (isKotlinStrataAvailable) {
                try {
                    Project project;
                    String javaSourceFileName = location2.sourceName("Java");
                    JvmClassName javaClassName = JvmClassName.byInternalName(this.defaultInternalName(location2));
                    Project project2 = project = this.myDebugProcess.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                    GlobalSearchScope globalSearchScope = this.myDebugProcess.getSearchScope();
                    Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"myDebugProcess.searchScope");
                    JvmClassName jvmClassName = javaClassName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"javaClassName");
                    String string = javaSourceFileName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaSourceFileName");
                    KtFile defaultPsiFile = DebuggerUtils.INSTANCE.findSourceFileForClass(project2, globalSearchScope, jvmClassName, string);
                    if (defaultPsiFile != null) {
                        return SourcePosition.createFromLine((PsiFile)((PsiFile)defaultPsiFile), (int)0);
                    }
                }
                catch (AbsentInformationException e2) {
                    // empty catch block
                }
            }
            Throwable throwable = (Throwable)NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
            throw throwable;
        }
        try {
            e2 = location2.lineNumber() - 1;
        }
        catch (InternalError e3) {
            e2 = -1;
        }
        int lineNumber = e2;
        if (lineNumber >= 0) {
            PsiFile psiFile2 = psiFile;
            if (psiFile2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            }
            KtFunction lambdaOrFunIfInside = this.getLambdaOrFunIfInside(location2, (KtFile)psiFile2, lineNumber);
            if (lambdaOrFunIfInside != null) {
                KtExpression ktExpression = lambdaOrFunIfInside.getBodyExpression();
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                return SourcePosition.createFromElement((PsiElement)((PsiElement)ktExpression));
            }
            KtParameter property2 = this.getParameterIfInConstructor(location2, (KtFile)psiFile, lineNumber);
            if (property2 != null) {
                return SourcePosition.createFromElement((PsiElement)property2);
            }
            return SourcePosition.createFromLine((PsiFile)psiFile, (int)lineNumber);
        }
        Throwable throwable = (Throwable)NoDataException.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
        throw throwable;
    }

    /*
     * Unable to fully structure code
     */
    private final KtParameter getParameterIfInConstructor(Location location, KtFile file, int lineNumber) {
        block9: {
            block11: {
                block10: {
                    block8: {
                        v0 = JetRefactoringUtilKt.getLineStartOffset((PsiFile)file, lineNumber);
                        if (v0 == null) {
                            return null;
                        }
                        lineStartOffset = ((Number)v0).intValue();
                        elementAt = file.findElementAt(lineStartOffset);
                        contextElement = KotlinCodeFragmentFactory.Companion.getContextElement(elementAt);
                        methodName = location.method().name();
                        if (!(contextElement instanceof KtClass) || !JvmAbi.isGetterName(methodName)) break block9;
                        v1 = ((KtClass)contextElement).getPrimaryConstructor();
                        if (v1 == null || (v1 = v1.getValueParameters()) == null) break block10;
                        var9_8 = (Iterable)v1;
                        for (T element$iv : $receiver$iv) {
                            it = (KtParameter)element$iv;
                            if (!it.hasValOrVar() || it.getName() == null) ** GOTO lbl-1000
                            v2 = it.getName();
                            if (v2 == null) {
                                Intrinsics.throwNpe();
                            }
                            if (Intrinsics.areEqual((Object)JvmAbi.getterName(v2), (Object)methodName)) {
                                v3 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v3 = false;
                            }
                            if (!v3) continue;
                            v4 = element$iv;
                            break block8;
                        }
                        v4 = null;
                    }
                    if ((v1 = (KtParameter)v4) != null) break block11;
                }
                return null;
            }
            parameterForGetter = v1;
            return parameterForGetter;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final KtFunction getLambdaOrFunIfInside(Location location2, KtFile file, int lineNumber) {
        PsiElement elementAt;
        String string = location2.declaringType().name();
        if (string == null) {
            return null;
        }
        String currentLocationFqName = string;
        Integer start = CodeInsightUtils.getStartLineOffset((PsiFile)file, lineNumber);
        Integer end = CodeInsightUtils.getEndLineOffset((PsiFile)file, lineNumber);
        if (start == null || end == null) {
            return null;
        }
        List<KtFunction> literalsOrFunctions = BreakpointTypeUtilsKt.getLambdasAtLineIfAny(file, lineNumber);
        if (literalsOrFunctions.isEmpty()) {
            return null;
        }
        PsiElement psiElement = file.findElementAt(((Number)start).intValue());
        if (psiElement == null) {
            return null;
        }
        PsiElement psiElement2 = elementAt = psiElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"elementAt");
        JetTypeMapper typeMapper = KotlinDebuggerCaches.Companion.getOrCreateTypeMapper(psiElement2);
        String currentLocationClassName = JvmClassName.byFqNameWithoutInnerClasses(new FqName(currentLocationFqName)).getInternalName();
        for (KtFunction literal : literalsOrFunctions) {
            boolean bl;
            block8: {
                void $receiver$iv;
                if (InlineUtil.isInlinedArgument(literal, typeMapper.getBindingContext(), true)) {
                    DebugProcess debugProcess = this.myDebugProcess;
                    if (debugProcess == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.debugger.engine.DebugProcessImpl");
                    }
                    if (!DebuggerUtilKt.isInsideInlineArgument(literal, location2, (DebugProcessImpl)debugProcess)) continue;
                    return literal;
                }
                List<String> internalClassNames = this.classNamesForPosition(literal.getFirstChild(), true);
                Iterable iterable = internalClassNames;
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    if (!Intrinsics.areEqual((Object)it, (Object)currentLocationClassName)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
            if (!bl) continue;
            return literal;
        }
        return null;
    }

    private final PsiFile getPsiFileByLocation(Location location2) {
        Project project;
        String referenceInternalName;
        String sourceName;
        try {
            String string = location2.sourceName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"location.sourceName()");
            sourceName = string;
        }
        catch (AbsentInformationException e) {
            return null;
        }
        catch (InternalError e) {
            return null;
        }
        try {
            referenceInternalName = this.containsKotlinStrata(location2.declaringType()) ? StringsKt.replace$default((String)location2.sourcePath(), (char)'\\', (char)'/', (boolean)false, (int)4, null) : this.defaultInternalName(location2);
        }
        catch (AbsentInformationException e) {
            referenceInternalName = this.defaultInternalName(location2);
        }
        JvmClassName className = JvmClassName.byInternalName(referenceInternalName);
        Project project2 = project = this.myDebugProcess.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        GlobalSearchScope globalSearchScope = this.myDebugProcess.getSearchScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"myDebugProcess.searchScope");
        JvmClassName jvmClassName = className;
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
        return (PsiFile)DebuggerUtils.INSTANCE.findSourceFileForClass(project2, globalSearchScope, jvmClassName, sourceName);
    }

    private final String defaultInternalName(Location location2) {
        String referenceFqName = location2.declaringType().name();
        return StringsKt.replace$default((String)referenceFqName, (char)'.', (char)'/', (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition2, (String)"sourcePosition");
        PsiFile psiFile = sourcePosition2.getFile();
        if (psiFile instanceof KtFile) {
            ArrayList result2 = new ArrayList();
            PsiElement psiElement = (PsiElement)psiFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"psiFile");
            if (!ProjectRootsUtil.isInProjectOrLibSource(psiElement)) {
                return result2;
            }
            List<String> names = this.classNamesForPosition(sourcePosition2, true);
            for (String name2 : names) {
                result2.addAll(this.myDebugProcess.getVirtualMachineProxy().classesByName(name2));
            }
            return result2;
        }
        if (psiFile instanceof ClsFileImpl) {
            void $receiver$iv;
            PsiFile names = psiFile;
            PsiFile decompiledPsiFile = (PsiFile)ApplicationUtilsKt.runReadAction((Function0)new Function0<PsiFile>((Object)$receiver$iv){
                final /* synthetic */ Object receiver$0;

                public final PsiFile invoke() {
                    ClsFileImpl it = (ClsFileImpl)this.receiver$0;
                    return it.getDecompiledPsiFile();
                }
                {
                    this.receiver$0 = object;
                    super(0);
                }
            });
            if (decompiledPsiFile instanceof KtClsFile && sourcePosition2.getLine() == -1) {
                String className = FileClasses.getInternalNameWithoutInnerClasses(JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)decompiledPsiFile).getFileClassFqName());
                List list2 = this.myDebugProcess.getVirtualMachineProxy().classesByName(className);
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"myDebugProcess.virtualMa\u2026.classesByName(className)");
                return list2;
            }
        }
        Throwable throwable = (Throwable)NoDataException.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
        throw throwable;
    }

    @Nullable
    public final String originalClassNameForPosition(@NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition2, (String)"sourcePosition");
        return (String)CollectionsKt.firstOrNull(this.classNamesForPosition(sourcePosition2, false));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> classNamesForPosition(SourcePosition sourcePosition2, boolean withInlines) {
        void $receiver$iv;
        SourcePosition sourcePosition3 = sourcePosition2;
        PsiElement psiElement = (PsiElement)ApplicationUtilsKt.runReadAction((Function0)new Function0<PsiElement>((Object)$receiver$iv){
            final /* synthetic */ Object receiver$0;

            public final PsiElement invoke() {
                SourcePosition it = (SourcePosition)this.receiver$0;
                return it.getElementAt();
            }
            {
                this.receiver$0 = object;
                super(0);
            }
        });
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement element2 = psiElement;
        List<String> names = this.classNamesForPosition(element2, withInlines);
        Collection<String> lambdas = this.findLambdas(sourcePosition2);
        if (lambdas.isEmpty()) {
            return names;
        }
        return CollectionsKt.plus((Collection)names, (Iterable)lambdas);
    }

    private final List<String> classNamesForPosition(PsiElement element2, boolean withInlines) {
        if (DumbService.getInstance((Project)this.myDebugProcess.getProject()).isDumb()) {
            return CollectionsKt.emptyList();
        }
        KtElement ktElement = this.getElementToCalculateClassName(element2);
        if (ktElement == null) {
            return CollectionsKt.emptyList();
        }
        KtElement baseElement = ktElement;
        return KotlinDebuggerCaches.Companion.getOrComputeClassNames((PsiElement)baseElement, (Function1)new Function1<KtElement, KotlinDebuggerCaches.ComputedClassNames>(this, withInlines){
            final /* synthetic */ KotlinPositionManager this$0;
            final /* synthetic */ boolean $withInlines;

            @NotNull
            public final KotlinDebuggerCaches.ComputedClassNames invoke(@NotNull KtElement element2) {
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                KtElement $receiver$iv = element2;
                KtFile file = (KtFile)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtFile>((Object)$receiver$iv){
                    final /* synthetic */ Object receiver$0;

                    public final KtFile invoke() {
                        KtElement it = (KtElement)this.receiver$0;
                        PsiFile psiFile = it.getContainingFile();
                        if (psiFile == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                        }
                        return (KtFile)psiFile;
                    }
                    {
                        this.receiver$0 = object;
                        super(0);
                    }
                });
                boolean isInLibrary = LibraryUtil.findLibraryEntry((VirtualFile)file.getVirtualFile(), (Project)file.getProject()) != null;
                JetTypeMapper typeMapper = KotlinDebuggerCaches.Companion.getOrCreateTypeMapper((PsiElement)element2);
                return KotlinPositionManager.access$getInternalClassNameForElement(this.this$0, element2, typeMapper, file, isInLibrary, this.$withInlines);
            }
            {
                this.this$0 = kotlinPositionManager;
                this.$withInlines = bl;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<String> findLambdas(SourcePosition sourcePosition2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Object $receiver$iv = sourcePosition2;
        List lambdas = (List)ApplicationUtilsKt.runReadAction((Function0)new Function0<List<? extends KtFunction>>($receiver$iv){
            final /* synthetic */ Object receiver$0;

            public final List<? extends KtFunction> invoke() {
                SourcePosition it = (SourcePosition)this.receiver$0;
                return BreakpointTypeUtilsKt.getLambdasAtLineIfAny(it);
            }
            {
                this.receiver$0 = object;
                super(0);
            }
        });
        $receiver$iv = lambdas;
        Object $i$f$readAction = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtFunction it = (KtFunction)element$iv$iv;
            Iterable list$iv$iv = this.classNamesForPosition(it, true);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type2, @NotNull SourcePosition position) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        if (!(position.getFile() instanceof KtFile)) {
            Throwable throwable = (Throwable)NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
            throw throwable;
        }
        try {
            List<Location> locations;
            int line = position.getLine() + 1;
            List<Location> list2 = locations = this.myDebugProcess.getVirtualMachineProxy().versionHigher("1.4") ? type2.locationsOfLine("Kotlin", null, line) : type2.locationsOfLine(line);
            if (locations == null || locations.isEmpty()) {
                Throwable throwable = (Throwable)NoDataException.INSTANCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
                throw throwable;
            }
            return locations;
        }
        catch (AbsentInformationException e) {
            Throwable throwable = (Throwable)NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
            throw throwable;
        }
    }

    @Deprecated(message="Since Idea 14.0.3 use createPrepareRequests fun")
    @Nullable
    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor classPrepareRequestor, @NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkParameterIsNotNull((Object)classPrepareRequestor, (String)"classPrepareRequestor");
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition2, (String)"sourcePosition");
        return (ClassPrepareRequest)CollectionsKt.firstOrNull(this.createPrepareRequests(classPrepareRequestor, sourcePosition2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) {
        void destination$iv$iv;
        void $receiver$iv$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        if (!(position.getFile() instanceof KtFile)) {
            Throwable throwable = (Throwable)NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
            throw throwable;
        }
        Iterable $receiver$iv = this.classNamesForPosition(position, true);
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        void var6_6 = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Boolean bl;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            String className = (String)element$iv$iv;
            if (this.myDebugProcess.getRequestsManager().createClassPrepareRequest(requestor, StringsKt.replace$default((String)className, (char)'/', (char)'.', (boolean)false, (int)4, null)) != null) {
                void $receiver$iv$iv$iv2;
                void it$iv$iv = $receiver$iv$iv$iv2;
                bl = destination$iv$iv.add(it$iv$iv);
                continue;
            }
            bl = null;
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final KotlinDebuggerCaches.ComputedClassNames getInternalClassNameForElement(KtElement element2, JetTypeMapper typeMapper, KtFile file, boolean isInLibrary, boolean withInlines) {
        String string;
        String string2;
        Collection crossInlineParameterUsages;
        void $receiver$iv;
        KtElement $receiver$iv2;
        KtElement ktElement = element2;
        KtElement parent2 = (KtElement)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtElement>((Object)$receiver$iv2, this){
            final /* synthetic */ Object receiver$0;
            final /* synthetic */ KotlinPositionManager this$0;

            public final KtElement invoke() {
                KtElement it = (KtElement)this.receiver$0;
                return KotlinPositionManager.access$getElementToCalculateClassName(this.this$0, it.getParent());
            }
            {
                this.receiver$0 = object;
                this.this$0 = kotlinPositionManager;
                super(0);
            }
        });
        $receiver$iv2 = element2;
        if ($receiver$iv2 instanceof KtClassOrObject) {
            return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.getClassNameForClass((KtClassOrObject)element2, typeMapper));
        }
        if ($receiver$iv2 instanceof KtFunction) {
            KtElement ktElement2 = element2;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)ApplicationUtilsKt.runReadAction((Function0)new Function0<ValueParameterDescriptor>((Object)$receiver$iv, typeMapper){
                final /* synthetic */ Object receiver$0;
                final /* synthetic */ JetTypeMapper $typeMapper$inlined;

                public final ValueParameterDescriptor invoke() {
                    KtFunction it = (KtFunction)this.receiver$0;
                    return InlineUtil.getInlineArgumentDescriptor(it, this.$typeMapper$inlined.getBindingContext());
                }
                {
                    this.receiver$0 = object;
                    this.$typeMapper$inlined = jetTypeMapper;
                    super(0);
                }
            });
            if (valueParameterDescriptor != null) {
                List<String> classNamesForParent = this.classNamesForPosition((PsiElement)parent2, withInlines);
                if (!valueParameterDescriptor.isCrossinline()) return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(classNamesForParent);
                Collection collection = classNamesForParent;
                KtFunction ktFunction = (KtFunction)element2;
                BindingContext bindingContext2 = typeMapper.getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"typeMapper.bindingContext");
                return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(CollectionsKt.plus((Collection)collection, (Iterable)this.findCrossInlineArguments(ktFunction, valueParameterDescriptor, bindingContext2)));
            }
        }
        KtElement ktElement3 = element2;
        Collection collection = crossInlineParameterUsages = (Collection)ApplicationUtilsKt.runReadAction((Function0)new Function0<Collection<? extends ValueParameterDescriptor>>((Object)ktElement3, this, typeMapper){
            final /* synthetic */ Object receiver$0;
            final /* synthetic */ KotlinPositionManager this$0;
            final /* synthetic */ JetTypeMapper $typeMapper$inlined;

            public final Collection<? extends ValueParameterDescriptor> invoke() {
                KtElement it = (KtElement)this.receiver$0;
                BindingContext bindingContext2 = this.$typeMapper$inlined.getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"typeMapper.bindingContext");
                return KotlinPositionManager.access$containsCrossInlineParameterUsages(this.this$0, it, bindingContext2);
            }
            {
                this.receiver$0 = object;
                this.this$0 = kotlinPositionManager;
                this.$typeMapper$inlined = jetTypeMapper;
                super(0);
            }
        });
        if (!collection.isEmpty()) {
            BindingContext bindingContext3 = typeMapper.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext3, (String)"typeMapper.bindingContext");
            return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(CollectionsKt.toList((Iterable)this.classNamesForCrossInlineParameters(crossInlineParameterUsages, bindingContext3)));
        }
        if (element2 instanceof KtFunctionLiteral) {
            Type type2 = CodegenBinding.asmTypeForAnonymousClass(typeMapper.getBindingContext(), element2);
            return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(type2.getInternalName());
        }
        if (element2 instanceof KtAnonymousInitializer) {
            if (!(parent2 instanceof KtObjectDeclaration) || !((KtObjectDeclaration)parent2).isCompanion()) return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.classNamesForPosition((PsiElement)parent2, withInlines));
            return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.classNamesForPosition(((KtObjectDeclaration)parent2).getParent(), withInlines));
        }
        if (element2 instanceof KtPropertyAccessor) {
            KtElement ktElement4 = element2;
            if (!((Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>((Object)ktElement4){
                final /* synthetic */ Object receiver$0;

                public final Boolean invoke() {
                    KtPropertyAccessor it = (KtPropertyAccessor)this.receiver$0;
                    return it.getProperty().isTopLevel();
                }
                {
                    this.receiver$0 = object;
                    super(0);
                }
            })).booleanValue() || !isInLibrary) {
                KtElement $i$f$readAction = element2;
                KtClassOrObject ktClassOrObject = (KtClassOrObject)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtClassOrObject>((Object)$receiver$iv){
                    final /* synthetic */ Object receiver$0;

                    public final KtClassOrObject invoke() {
                        KtPropertyAccessor it = (KtPropertyAccessor)this.receiver$0;
                        return (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)it, KtClassOrObject.class);
                    }
                    {
                        this.receiver$0 = object;
                        super(0);
                    }
                });
                if (ktClassOrObject == null) return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.getClassNameForFile(file));
                return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.getClassNameForClass(ktClassOrObject, typeMapper));
            }
        }
        if (element2 instanceof KtProperty) {
            KtElement ktElement5 = element2;
            if (!((Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>((Object)ktElement5){
                final /* synthetic */ Object receiver$0;

                public final Boolean invoke() {
                    KtProperty it = (KtProperty)this.receiver$0;
                    return it.isTopLevel();
                }
                {
                    this.receiver$0 = object;
                    super(0);
                }
            })).booleanValue() || !isInLibrary) {
                DeclarationDescriptor declarationDescriptor = typeMapper.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element2);
                if (declarationDescriptor instanceof PropertyDescriptor) return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.getJvmInternalNameForPropertyOwner(typeMapper, (PropertyDescriptor)declarationDescriptor));
                return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.classNamesForPosition((PsiElement)parent2, withInlines));
            }
        }
        if (!(element2 instanceof KtNamedFunction)) return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.getClassNameForFile(file));
        if (parent2 instanceof KtClassOrObject) {
            string2 = this.getClassNameForClass((KtClassOrObject)parent2, typeMapper);
        } else if (parent2 != null) {
            Type asmType = CodegenBinding.asmTypeForAnonymousClass(typeMapper.getBindingContext(), element2);
            string2 = asmType.getInternalName();
        } else {
            string2 = string = this.getClassNameForFile(file);
        }
        if (!withInlines) {
            return new KotlinDebuggerCaches.ComputedClassNames.NonCachedClassNames(string);
        }
        KtNamedFunction ktNamedFunction = (KtNamedFunction)element2;
        BindingContext bindingContext4 = typeMapper.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext4, (String)"typeMapper.bindingContext");
        List<String> inlinedCalls = this.findInlinedCalls(ktNamedFunction, bindingContext4);
        if (string != null) return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)string), (Iterable)inlinedCalls));
        return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(inlinedCalls);
    }

    private final String getClassNameForClass(KtClassOrObject klass, JetTypeMapper typeMapper) {
        KtClassOrObject $receiver$iv = klass;
        return (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>((Object)$receiver$iv, this, typeMapper){
            final /* synthetic */ Object receiver$0;
            final /* synthetic */ KotlinPositionManager this$0;
            final /* synthetic */ JetTypeMapper $typeMapper$inlined;

            public final String invoke() {
                KtClassOrObject it = (KtClassOrObject)this.receiver$0;
                return KotlinPositionManager.access$getJvmInternalNameForImpl(this.this$0, this.$typeMapper$inlined, it);
            }
            {
                this.receiver$0 = object;
                this.this$0 = kotlinPositionManager;
                this.$typeMapper$inlined = jetTypeMapper;
                super(0);
            }
        });
    }

    private final String getClassNameForFile(KtFile file) {
        KtFile $receiver$iv = file;
        return (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>((Object)$receiver$iv){
            final /* synthetic */ Object receiver$0;

            public final String invoke() {
                KtFile it = (KtFile)this.receiver$0;
                return FileClasses.getFileClassInternalName(NoResolveFileClassesProvider.INSTANCE, it);
            }
            {
                this.receiver$0 = object;
                super(0);
            }
        });
    }

    private final KtElement getElementToCalculateClassName(PsiElement notPositionedElement) {
        PsiElement psiElement = notPositionedElement;
        Class<Object> clazz = psiElement != null ? psiElement.getClass() : null;
        if (clazz == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
        }
        if (ArraysKt.contains((Object[])this.TYPES_TO_CALCULATE_CLASSNAME, clazz)) {
            PsiElement psiElement2 = notPositionedElement;
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            }
            return (KtElement)psiElement2;
        }
        KotlinPositionManager $receiver$iv = this;
        return (KtElement)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtElement>((Object)$receiver$iv, this, notPositionedElement){
            final /* synthetic */ Object receiver$0;
            final /* synthetic */ KotlinPositionManager this$0;
            final /* synthetic */ PsiElement $notPositionedElement$inlined;

            public final KtElement invoke() {
                KotlinPositionManager it = (KotlinPositionManager)((Object)this.receiver$0);
                Class[] classArray = KotlinPositionManager.access$getTYPES_TO_CALCULATE_CLASSNAME$p(this.this$0);
                return (KtElement)PsiTreeUtil.getParentOfType((PsiElement)this.$notPositionedElement$inlined, (Class[])Arrays.copyOf(classArray, classArray.length));
            }
            {
                this.receiver$0 = object;
                this.this$0 = kotlinPositionManager;
                this.$notPositionedElement$inlined = psiElement;
                super(0);
            }
        });
    }

    @NotNull
    public final String getJvmInternalNameForPropertyOwner(@NotNull JetTypeMapper typeMapper, @NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)typeMapper, (String)"typeMapper");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        PropertyDescriptor $receiver$iv = descriptor2;
        String string = (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>((Object)$receiver$iv, typeMapper){
            final /* synthetic */ Object receiver$0;
            final /* synthetic */ JetTypeMapper $typeMapper$inlined;

            public final String invoke() {
                DeclarationDescriptor declarationDescriptor;
                PropertyDescriptor it = (PropertyDescriptor)this.receiver$0;
                if (JvmAbi.isPropertyWithBackingFieldInOuterClass(it)) {
                    DeclarationDescriptor declarationDescriptor2 = it.getContainingDeclaration();
                    declarationDescriptor = declarationDescriptor2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"it.containingDeclaration");
                } else {
                    declarationDescriptor = it;
                }
                String string = this.$typeMapper$inlined.mapOwner(declarationDescriptor).getInternalName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"typeMapper.mapOwner(\n   \u2026           ).internalName");
                return string;
            }
            {
                this.receiver$0 = object;
                this.$typeMapper$inlined = jetTypeMapper;
                super(0);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptor.readAction {\n\u2026 ).internalName\n        }");
        return string;
    }

    private final String getJvmInternalNameForImpl(JetTypeMapper typeMapper, KtClassOrObject ktClass) {
        ClassDescriptor classDescriptor = (ClassDescriptor)typeMapper.getBindingContext().get(BindingContext.CLASS, ktClass);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (ktClass instanceof KtClass && ((KtClass)ktClass).isInterface()) {
            return typeMapper.mapDefaultImpls(classDescriptor2).getInternalName();
        }
        return typeMapper.mapClass(classDescriptor2).getInternalName();
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findInlinedCalls(KtNamedFunction function2, BindingContext context) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        void isSuccess;
        void $receiver$iv2;
        if (!InlineUtil.isInline(context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function2))) {
            return CollectionsKt.emptyList();
        }
        HashSet searchResult = SetsKt.hashSetOf((Object[])new KtElement[0]);
        KtNamedFunction ktNamedFunction = function2;
        String functionName = (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>((Object)$receiver$iv2){
            final /* synthetic */ Object receiver$0;

            public final String invoke() {
                KtNamedFunction it = (KtNamedFunction)this.receiver$0;
                return it.getName();
            }
            {
                this.receiver$0 = object;
                super(0);
            }
        });
        Runnable task2 = new Runnable(this, function2, searchResult){
            final /* synthetic */ KotlinPositionManager this$0;
            final /* synthetic */ KtNamedFunction $function;
            final /* synthetic */ HashSet $searchResult;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                Iterable $receiver$iv = (Iterable)ReferencesSearch.search((PsiElement)this.$function, (SearchScope)((SearchScope)KotlinPositionManager.access$getMyDebugProcess$p(this.this$0).getSearchScope()));
                for (T element$iv : $receiver$iv) {
                    KtElement usage;
                    KtElement ktElement;
                    void $receiver$iv2;
                    PsiReference it;
                    PsiReference psiReference = it = (PsiReference)element$iv;
                    if (((Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>((Object)$receiver$iv2){
                        final /* synthetic */ Object receiver$0;

                        public final Boolean invoke() {
                            PsiReference it = (PsiReference)this.receiver$0;
                            return UtilsKt.isImportUsage(it);
                        }
                        {
                            this.receiver$0 = object;
                            super(0);
                        }
                    })).booleanValue()) continue;
                    PsiElement psiElement = it.getElement();
                    if (!(psiElement instanceof KtElement)) {
                        psiElement = null;
                    }
                    if ((KtElement)psiElement != null) {
                        void $receiver$iv3;
                        KtElement it2 = (KtElement)$receiver$iv3;
                        ktElement = KotlinPositionManager.access$getElementToCalculateClassName(this.this$0, (PsiElement)it2);
                    } else {
                        ktElement = usage = null;
                    }
                    if (usage == null) continue;
                    this.$searchResult.add(usage);
                }
            }
            {
                this.this$0 = kotlinPositionManager;
                this.$function = ktNamedFunction;
                this.$searchResult = hashSet;
            }
        };
        Ref.BooleanRef $i$f$readAction = new Ref.BooleanRef();
        $i$f$readAction.element = true;
        ApplicationManager.getApplication().invokeAndWait(new Runnable(this, (Ref.BooleanRef)isSuccess, task2, functionName){
            final /* synthetic */ KotlinPositionManager this$0;
            final /* synthetic */ Ref.BooleanRef $isSuccess;
            final /* synthetic */ Runnable $task;
            final /* synthetic */ String $functionName;

            public final void run() {
                this.$isSuccess.element = ProgressManager.getInstance().runProcessWithProgressSynchronously(this.$task, "Compute class names for function " + this.$functionName, true, KotlinPositionManager.access$getMyDebugProcess$p(this.this$0).getProject());
            }
            {
                this.this$0 = kotlinPositionManager;
                this.$isSuccess = booleanRef;
                this.$task = runnable;
                this.$functionName = string;
            }
        }, ModalityState.NON_MODAL);
        if (!isSuccess.element) {
            XDebugSessionImpl.NOTIFICATION_GROUP.createNotification("Debugger can skip some executions of " + functionName + " method, because the computation of class names was interrupted", MessageType.WARNING).notify(this.myDebugProcess.getProject());
        }
        Iterable iterable = searchResult;
        void var8_8 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtElement it = (KtElement)element$iv$iv;
            Iterable list$iv$iv = this.classNamesForPosition((PsiElement)it, true);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Set<String> findCrossInlineArguments(KtFunction argument2, ValueParameterDescriptor parameterDescriptor, BindingContext context) {
        return (Set)ApplicationUtilsKt.runReadAction((Function0)new Function0<Set<? extends String>>(this, parameterDescriptor, argument2, context){
            final /* synthetic */ KotlinPositionManager this$0;
            final /* synthetic */ ValueParameterDescriptor $parameterDescriptor;
            final /* synthetic */ KtFunction $argument;
            final /* synthetic */ BindingContext $context;

            @NotNull
            public final Set<String> invoke() {
                String functionName;
                KtParameter source;
                KtCallableDeclaration ktCallableDeclaration;
                PsiElement psiElement = KotlinSourceElementKt.getPsi(this.$parameterDescriptor.getSource());
                if (!(psiElement instanceof KtParameter)) {
                    psiElement = null;
                }
                String string = (ktCallableDeclaration = (source = (KtParameter)psiElement)) != null && (ktCallableDeclaration = ((KtParameter)ktCallableDeclaration).getOwnerFunction()) != null ? ktCallableDeclaration.getName() : (functionName = null);
                if (functionName != null) {
                    return SetsKt.setOf((Object)KotlinPositionManager.access$getCrossInlineArgumentClassName(this.this$0, this.$argument, functionName, this.$context));
                }
                return SetsKt.emptySet();
            }
            {
                this.this$0 = kotlinPositionManager;
                this.$parameterDescriptor = valueParameterDescriptor;
                this.$argument = ktFunction;
                this.$context = bindingContext2;
                super(0);
            }
        });
    }

    private final String getCrossInlineArgumentClassName(KtFunction argument2, String inlineFunctionName, BindingContext context) {
        String anonymousClassNameForArgument = CodegenBinding.asmTypeForAnonymousClass(context, argument2).getInternalName();
        String newName2 = this.substringIndex(anonymousClassNameForArgument) + "$inlined" + "$" + inlineFunctionName;
        return newName2 + "$" + "*";
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<ValueParameterDescriptor> containsCrossInlineParameterUsages(KtElement $receiver, BindingContext context) {
        void $receiver$iv$iv$iv;
        Collection destination$iv$iv;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Object v0;
        Object element$iv2;
        block7: {
            void $receiver$iv2;
            containsCrossInlineParameterUsages.1 hasParameterCall$ = containsCrossInlineParameterUsages.1.INSTANCE;
            Sequence<PsiElement> sequence2 = PsiUtilsKt.getParents((PsiElement)$receiver);
            for (Object element$iv2 : $receiver$iv2) {
                if (!(element$iv2 instanceof KtNamedFunction)) continue;
                v0 = element$iv2;
                break block7;
            }
            v0 = null;
        }
        KtNamedFunction ktNamedFunction = v0;
        if (ktNamedFunction == null) {
            return SetsKt.emptySet();
        }
        KtNamedFunction inlineFunction = ktNamedFunction;
        SimpleFunctionDescriptor inlineFunctionDescriptor = (SimpleFunctionDescriptor)context.get(BindingContext.FUNCTION, inlineFunction);
        if (inlineFunctionDescriptor == null || !InlineUtil.isInline(inlineFunctionDescriptor)) {
            return SetsKt.emptySet();
        }
        Iterable iterable = inlineFunctionDescriptor.getValueParameters();
        element$iv2 = $receiver$iv;
        Collection $i$f$firstIsInstanceOrNull = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            if (!it.isCrossinline()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterable iterable2 = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            Boolean bl;
            KtParameter psiParameter;
            Object element$iv$iv = element$iv$iv$iv;
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            PsiElement psiElement = KotlinSourceElementKt.getPsi(it.getSource());
            if (!(psiElement instanceof KtParameter)) {
                psiElement = null;
            }
            if (((psiParameter = (KtParameter)psiElement) != null && containsCrossInlineParameterUsages.1.INSTANCE.invoke($receiver, psiParameter) ? it : (ValueParameterDescriptor)null) != null) {
                void $receiver$iv$iv$iv2;
                ValueParameterDescriptor valueParameterDescriptor;
                valueParameterDescriptor = valueParameterDescriptor;
                void it$iv$iv = $receiver$iv$iv$iv2;
                bl = destination$iv$iv.add(it$iv$iv);
                continue;
            }
            bl = null;
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> classNamesForCrossInlineParameters(Collection<? extends ValueParameterDescriptor> usedParameters, BindingContext context) {
        void $receiver$iv;
        ValueParameterDescriptor parameter = (ValueParameterDescriptor)CollectionsKt.first((Iterable)usedParameters);
        HashSet result2 = SetsKt.hashSetOf((Object[])new String[0]);
        PsiElement psiElement = KotlinSourceElementKt.getPsi(parameter.getContainingDeclaration().getSource());
        if (!(psiElement instanceof KtNamedFunction)) {
            psiElement = null;
        }
        KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement;
        if (ktNamedFunction == null) {
            return SetsKt.emptySet();
        }
        KtNamedFunction inlineFunction = ktNamedFunction;
        Iterable iterable = (Iterable)ReferencesSearch.search((PsiElement)inlineFunction, (SearchScope)((SearchScope)this.myDebugProcess.getSearchScope()));
        for (Object element$iv : $receiver$iv) {
            PsiReference it = (PsiReference)element$iv;
            ApplicationUtilsKt.runReadAction((Function0)new Function0<Unit>(it, this, context, parameter, result2, inlineFunction){
                final /* synthetic */ PsiReference $it;
                final /* synthetic */ KotlinPositionManager this$0;
                final /* synthetic */ BindingContext $context$inlined;
                final /* synthetic */ ValueParameterDescriptor $parameter$inlined;
                final /* synthetic */ HashSet $result$inlined;
                final /* synthetic */ KtNamedFunction $inlineFunction$inlined;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final void invoke() {
                    Object v7;
                    Object object;
                    block3: {
                        void $receiver$iv;
                        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                        if (UtilsKt.isImportUsage(this.$it)) return;
                        PsiElement psiElement = this.$it.getElement();
                        if (!(psiElement instanceof KtExpression)) {
                            psiElement = null;
                        }
                        KtExpression ktExpression = (KtExpression)psiElement;
                        if (ktExpression == null) return;
                        KtExpression $receiver$iv2 = ktExpression;
                        KtExpression it = $receiver$iv2;
                        KtExpression ktExpression2 = KtPsiUtil.getParentCallIfPresent(it);
                        KtExpression call = ktExpression2;
                        if (call == null) return;
                        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2 = CallUtilKt.getResolvedCall(call, this.$context$inlined);
                        object = resolvedCall3;
                        if (resolvedCall3 == null) return;
                        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = object.getValueArguments();
                        object = map2;
                        if (map2 == null) return;
                        Set<Map.Entry<K, V>> set = object.entrySet();
                        object = set;
                        if (set == null) return;
                        Iterable $i$a$1 = (Iterable)object;
                        for (T element$iv : $receiver$iv) {
                            Map.Entry it2 = (Map.Entry)element$iv;
                            if (!Intrinsics.areEqual((Object)((ValueParameterDescriptor)it2.getKey()).getOriginal(), (Object)this.$parameter$inlined)) continue;
                            v7 = element$iv;
                            break block3;
                        }
                        v7 = null;
                    }
                    Map.Entry entry = v7;
                    object = entry;
                    if (entry == null) return;
                    ResolvedValueArgument resolvedValueArgument = (ResolvedValueArgument)object.getValue();
                    ResolvedValueArgument argument2 = resolvedValueArgument;
                    if (argument2 == null) return;
                    ValueArgument valueArgument = (ValueArgument)CollectionsKt.first(argument2.getArguments());
                    Intrinsics.checkExpressionValueIsNotNull((Object)valueArgument, (String)"argument.arguments.first()");
                    KtExpression argumentExpression = KotlinPositionManager.access$getArgumentExpression(this.this$0, valueArgument);
                    if (!(argumentExpression instanceof KtFunction)) return;
                    KtFunction ktFunction = (KtFunction)argumentExpression;
                    String string = this.$inlineFunction$inlined.getName();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"inlineFunction.name!!");
                    this.$result$inlined.add(KotlinPositionManager.access$getCrossInlineArgumentClassName(this.this$0, ktFunction, string, this.$context$inlined));
                }
                {
                    this.$it = psiReference;
                    this.this$0 = kotlinPositionManager;
                    this.$context$inlined = bindingContext2;
                    this.$parameter$inlined = valueParameterDescriptor;
                    this.$result$inlined = hashSet;
                    this.$inlineFunction$inlined = ktNamedFunction;
                    super(0);
                }
            });
        }
        return result2;
    }

    private final KtExpression getArgumentExpression(ValueArgument it) {
        KtExpressionImpl ktExpressionImpl;
        KtExpression ktExpression = it.getArgumentExpression();
        if (!(ktExpression instanceof KtLambdaExpression)) {
            ktExpression = null;
        }
        return (ktExpressionImpl = (KtLambdaExpression)ktExpression) != null && (ktExpressionImpl = ktExpressionImpl.getFunctionLiteral()) != null ? (KtExpression)ktExpressionImpl : it.getArgumentExpression();
    }

    /*
     * WARNING - void declaration
     */
    private final String substringIndex(String $receiver) {
        boolean bl;
        block3: {
            if (StringsKt.lastIndexOf$default((CharSequence)$receiver, (String)"$", (int)0, (boolean)false, (int)6, null) < 0) {
                return $receiver;
            }
            String suffix = StringsKt.substringAfterLast$default((String)$receiver, (String)"$", null, (int)2, null);
            CharSequence $receiver$iv = suffix;
            CharIterator charIterator = StringsKt.iterator((CharSequence)$receiver$iv);
            while (charIterator.hasNext()) {
                void $receiver$iv2;
                char element$iv;
                char it;
                char c = it = (element$iv = charIterator.nextChar());
                if (Character.isDigit((char)$receiver$iv2)) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        if (bl) {
            return StringsKt.substringBeforeLast$default((String)$receiver, (String)"$", null, (int)2, null) + "$";
        }
        return $receiver;
    }

    private final boolean containsKotlinStrata(ReferenceType $receiver) {
        return $receiver.availableStrata().contains("Kotlin");
    }

    /*
     * WARNING - void declaration
     */
    public KotlinPositionManager(@NotNull DebugProcess myDebugProcess) {
        void elements$iv;
        Intrinsics.checkParameterIsNotNull((Object)myDebugProcess, (String)"myDebugProcess");
        this.myDebugProcess = myDebugProcess;
        Class[] classArray = new Class[]{KtClass.class, KtObjectDeclaration.class, KtEnumEntry.class, KtFunctionLiteral.class, KtNamedFunction.class, KtPropertyAccessor.class, KtProperty.class, KtClassInitializer.class};
        KotlinPositionManager kotlinPositionManager = this;
        Object[] objectArray = (Object[])elements$iv;
        kotlinPositionManager.TYPES_TO_CALCULATE_CLASSNAME = (Class[])objectArray;
    }

    @NotNull
    public static final /* synthetic */ KotlinDebuggerCaches.ComputedClassNames access$getInternalClassNameForElement(KotlinPositionManager $this, @NotNull KtElement element2, @NotNull JetTypeMapper typeMapper, @NotNull KtFile file, boolean isInLibrary, boolean withInlines) {
        return $this.getInternalClassNameForElement(element2, typeMapper, file, isInLibrary, withInlines);
    }

    @Nullable
    public static final /* synthetic */ KtElement access$getElementToCalculateClassName(KotlinPositionManager $this, @Nullable PsiElement notPositionedElement) {
        return $this.getElementToCalculateClassName(notPositionedElement);
    }

    @NotNull
    public static final /* synthetic */ Collection access$containsCrossInlineParameterUsages(KotlinPositionManager $this, KtElement $receiver, @NotNull BindingContext context) {
        return $this.containsCrossInlineParameterUsages($receiver, context);
    }

    @Nullable
    public static final /* synthetic */ String access$getJvmInternalNameForImpl(KotlinPositionManager $this, @NotNull JetTypeMapper typeMapper, @NotNull KtClassOrObject ktClass) {
        return $this.getJvmInternalNameForImpl(typeMapper, ktClass);
    }

    @NotNull
    public static final /* synthetic */ Class[] access$getTYPES_TO_CALCULATE_CLASSNAME$p(KotlinPositionManager $this) {
        return $this.TYPES_TO_CALCULATE_CLASSNAME;
    }

    @NotNull
    public static final /* synthetic */ DebugProcess access$getMyDebugProcess$p(KotlinPositionManager $this) {
        return $this.myDebugProcess;
    }

    @NotNull
    public static final /* synthetic */ String access$getCrossInlineArgumentClassName(KotlinPositionManager $this, @NotNull KtFunction argument2, @NotNull String inlineFunctionName, @NotNull BindingContext context) {
        return $this.getCrossInlineArgumentClassName(argument2, inlineFunctionName, context);
    }

    @Nullable
    public static final /* synthetic */ KtExpression access$getArgumentExpression(KotlinPositionManager $this, @NotNull ValueArgument it) {
        return $this.getArgumentExpression(it);
    }
}

