/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2jsrun;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public final class K2JSConfigurationSettings {
    @NotNull
    private String pageToOpenFilePath;
    @NotNull
    private String generatedFilePath;
    private boolean shouldOpenInBrowserAfterTranslation;
    @NotNull
    private BrowserFamily browserFamily;

    public K2JSConfigurationSettings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/k2jsrun/K2JSConfigurationSettings", "<init>"));
        }
        this.pageToOpenFilePath = "";
        this.shouldOpenInBrowserAfterTranslation = false;
        this.browserFamily = ((WebBrowser)WebBrowserManager.getInstance().getActiveBrowsers().get(0)).getFamily();
        String basePath = project.getBasePath();
        this.generatedFilePath = basePath != null ? basePath : "";
    }

    public K2JSConfigurationSettings() {
        this.pageToOpenFilePath = "";
        this.shouldOpenInBrowserAfterTranslation = false;
        this.browserFamily = ((WebBrowser)WebBrowserManager.getInstance().getActiveBrowsers().get(0)).getFamily();
        this.generatedFilePath = "";
    }

    @NotNull
    public BrowserFamily getBrowserFamily() {
        BrowserFamily browserFamily = this.browserFamily;
        if (browserFamily == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/k2jsrun/K2JSConfigurationSettings", "getBrowserFamily"));
        }
        return browserFamily;
    }

    public void setBrowserFamily(@NotNull BrowserFamily browserFamily) {
        if (browserFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserFamily", "org/jetbrains/kotlin/idea/k2jsrun/K2JSConfigurationSettings", "setBrowserFamily"));
        }
        this.browserFamily = browserFamily;
    }

    @NotNull
    public String getPageToOpenFilePath() {
        String string = this.pageToOpenFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/k2jsrun/K2JSConfigurationSettings", "getPageToOpenFilePath"));
        }
        return string;
    }

    public void setPageToOpenFilePath(@NotNull String pageToOpenFilePath) {
        if (pageToOpenFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pageToOpenFilePath", "org/jetbrains/kotlin/idea/k2jsrun/K2JSConfigurationSettings", "setPageToOpenFilePath"));
        }
        this.pageToOpenFilePath = pageToOpenFilePath;
    }

    @NotNull
    public String getGeneratedFilePath() {
        String string = this.generatedFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/k2jsrun/K2JSConfigurationSettings", "getGeneratedFilePath"));
        }
        return string;
    }

    public void setGeneratedFilePath(@NotNull String generatedFilePath) {
        if (generatedFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generatedFilePath", "org/jetbrains/kotlin/idea/k2jsrun/K2JSConfigurationSettings", "setGeneratedFilePath"));
        }
        this.generatedFilePath = generatedFilePath;
    }

    public boolean isShouldOpenInBrowserAfterTranslation() {
        return this.shouldOpenInBrowserAfterTranslation;
    }

    public void setShouldOpenInBrowserAfterTranslation(boolean shouldOpenInBrowserAfterTranslation) {
        this.shouldOpenInBrowserAfterTranslation = shouldOpenInBrowserAfterTranslation;
    }
}

