/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.stubindex.PackageIndexUtil;
import org.jetbrains.kotlin.idea.stubindex.resolve.StubBasedPackageMemberDeclarationProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.AbstractDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.CombinedPackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.PsiBasedClassMemberDeclarationProvider;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u000fH\u0002J\u0006\u0010\u0015\u001a\u00020\u000fJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/stubindex/resolve/PluginDeclarationProviderFactory;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractDeclarationProviderFactory;", "project", "Lcom/intellij/openapi/project/Project;", "indexedFilesScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "nonIndexedFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;Lorg/jetbrains/kotlin/storage/StorageManager;Ljava/util/Collection;)V", "fileBasedDeclarationProviderFactory", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory;", "onCreationDebugInfo", "", "createPackageMemberDeclarationProvider", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;", "name", "Lorg/jetbrains/kotlin/name/FqName;", "debugInfo", "debugToString", "diagnoseMissingPackageFragment", "", "file", "getClassMemberDeclarationProvider", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/ClassMemberDeclarationProvider;", "classLikeInfo", "Lorg/jetbrains/kotlin/resolve/lazy/data/KtClassLikeInfo;", "getStubBasedPackageMemberDeclarationProvider", "idea-analysis"})
public final class PluginDeclarationProviderFactory
extends AbstractDeclarationProviderFactory {
    private final FileBasedDeclarationProviderFactory fileBasedDeclarationProviderFactory;
    private final String onCreationDebugInfo;
    private final Project project;
    private final GlobalSearchScope indexedFilesScope;
    private final StorageManager storageManager;
    private final Collection<KtFile> nonIndexedFiles;

    @Override
    @NotNull
    public ClassMemberDeclarationProvider getClassMemberDeclarationProvider(@NotNull KtClassLikeInfo classLikeInfo) {
        Intrinsics.checkParameterIsNotNull((Object)classLikeInfo, (String)"classLikeInfo");
        return new PsiBasedClassMemberDeclarationProvider(this.storageManager, classLikeInfo);
    }

    @Override
    @Nullable
    protected PackageMemberDeclarationProvider createPackageMemberDeclarationProvider(@NotNull FqName name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        PackageMemberDeclarationProvider fileBasedProvider = this.fileBasedDeclarationProviderFactory.getPackageMemberDeclarationProvider(name2);
        PackageMemberDeclarationProvider stubBasedProvider = this.getStubBasedPackageMemberDeclarationProvider(name2);
        return fileBasedProvider == null && stubBasedProvider == null ? (PackageMemberDeclarationProvider)null : (fileBasedProvider == null ? stubBasedProvider : (stubBasedProvider == null ? fileBasedProvider : (PackageMemberDeclarationProvider)new CombinedPackageMemberDeclarationProvider(CollectionsKt.listOf((Object[])new PackageMemberDeclarationProvider[]{stubBasedProvider, fileBasedProvider}))));
    }

    private final PackageMemberDeclarationProvider getStubBasedPackageMemberDeclarationProvider(FqName name2) {
        if (!PackageIndexUtil.packageExists(name2, this.indexedFilesScope, this.project)) {
            return null;
        }
        return new StubBasedPackageMemberDeclarationProvider(name2, this.project, this.indexedFilesScope);
    }

    @Override
    public void diagnoseMissingPackageFragment(@NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        FqName packageFqName = file.getPackageFqName();
        StringBuilder stringBuilder = new StringBuilder().append("Cannot find package fragment for file " + file.getName() + " with package " + packageFqName + ", ").append("vFile " + file.getVirtualFile() + ", nonIndexed " + this.nonIndexedFiles.contains(file) + " ");
        StringBuilder stringBuilder2 = new StringBuilder().append("packageExists=");
        FqName fqName2 = packageFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
        throw (Throwable)new IllegalStateException(stringBuilder.append(stringBuilder2.append(PackageIndexUtil.packageExists(fqName2, this.indexedFilesScope, this.project)).toString()).toString());
    }

    @NotNull
    public final String debugToString() {
        return "PluginDeclarationProviderFactory" + "\n" + "On failure:" + "\n" + this.debugInfo() + "On creation:" + "\n" + this.onCreationDebugInfo;
    }

    /*
     * WARNING - void declaration
     */
    private final String debugInfo() {
        void var1_1;
        if (this.nonIndexedFiles.isEmpty()) {
            return "-no synthetic files-\n";
        }
        StringBuilder $receiver$iv$iv = new StringBuilder();
        StringBuilder $receiver = $receiver$iv$iv;
        Iterable $receiver$iv = this.nonIndexedFiles;
        for (Object element$iv : $receiver$iv) {
            KtFile it = (KtFile)element$iv;
            $receiver.append(it.getName());
            $receiver.append(" isPhysical=" + it.isPhysical());
            $receiver.append(" modStamp=" + it.getModificationStamp());
            StringsKt.appendln((StringBuilder)$receiver);
        }
        String string = ((StringBuilder)var1_1).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public PluginDeclarationProviderFactory(@NotNull Project project, @NotNull GlobalSearchScope indexedFilesScope, @NotNull StorageManager storageManager, @NotNull Collection<? extends KtFile> nonIndexedFiles) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)indexedFilesScope, (String)"indexedFilesScope");
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        Intrinsics.checkParameterIsNotNull(nonIndexedFiles, (String)"nonIndexedFiles");
        super(storageManager);
        this.project = project;
        this.indexedFilesScope = indexedFilesScope;
        this.storageManager = storageManager;
        this.nonIndexedFiles = nonIndexedFiles;
        this.fileBasedDeclarationProviderFactory = new FileBasedDeclarationProviderFactory(this.storageManager, this.nonIndexedFiles);
        this.onCreationDebugInfo = this.debugInfo();
    }
}

