/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.ChainedMemberScope;
import org.jetbrains.kotlin.resolve.scopes.FilteringScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassifierQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassQualifier;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassifierQualifier;", "referenceExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classValueReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;)V", "getClassValueReceiver", "()Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "getClassifier", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "getScope", "()Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "getNestedClassesAndPackageMembersScope", "toString", "", "kotlin-compiler"})
public final class ClassQualifier
extends ClassifierQualifier {
    @NotNull
    private final ClassDescriptor classifier;
    @Nullable
    private final ReceiverValue classValueReceiver;

    @Override
    @NotNull
    public MemberScope getScope() {
        FilteringScope filteringScope;
        if (!(this.getClassifier() instanceof ClassDescriptor)) {
            return MemberScope.Empty.INSTANCE;
        }
        ArrayList<MemberScope> scopes = new ArrayList<MemberScope>(3);
        Object object = DescriptorUtilsKt.getClassValueType(this.getClassifier());
        if (object != null && (object = object.getMemberScope()) != null) {
            MemberScope it;
            Object $receiver$iv = object;
            MemberScope memberScope2 = it = (MemberScope)$receiver$iv;
            Intrinsics.checkExpressionValueIsNotNull(memberScope2, "it");
            filteringScope = new FilteringScope(memberScope2, scope.classObjectTypeScope.1.1.INSTANCE);
        } else {
            filteringScope = null;
        }
        FilteringScope classObjectTypeScope2 = filteringScope;
        CollectionsKt.addIfNotNull((Collection)scopes, classObjectTypeScope2);
        scopes.add(this.getClassifier().getStaticScope());
        if (Intrinsics.areEqual((Object)this.getClassifier().getKind(), (Object)ClassKind.ENUM_ENTRY) ^ true) {
            scopes.add(this.getClassifier().getUnsubstitutedInnerClassesScope());
        }
        return new ChainedMemberScope("Member scope for " + this.getName() + " as class or object", (List<? extends MemberScope>)scopes);
    }

    @Override
    @NotNull
    public MemberScope getNestedClassesAndPackageMembersScope() {
        if (!(this.getClassifier() instanceof ClassDescriptor)) {
            return MemberScope.Empty.INSTANCE;
        }
        ArrayList<MemberScope> scopes = new ArrayList<MemberScope>(2);
        scopes.add(this.getClassifier().getStaticScope());
        if (Intrinsics.areEqual((Object)this.getClassifier().getKind(), (Object)ClassKind.ENUM_ENTRY) ^ true) {
            scopes.add(ScopeUtils.getStaticNestedClassesScope(this.getClassifier()));
        }
        return new ChainedMemberScope("Static scope for " + this.getName() + " as class or object", (List<? extends MemberScope>)scopes);
    }

    @NotNull
    public String toString() {
        return "Class{" + this.getClassifier() + "}";
    }

    @Override
    @NotNull
    public ClassDescriptor getClassifier() {
        return this.classifier;
    }

    @Nullable
    public final ReceiverValue getClassValueReceiver() {
        return this.classValueReceiver;
    }

    public ClassQualifier(@NotNull KtSimpleNameExpression referenceExpression, @NotNull ClassDescriptor classifier2, @Nullable ReceiverValue classValueReceiver) {
        Intrinsics.checkParameterIsNotNull(referenceExpression, "referenceExpression");
        Intrinsics.checkParameterIsNotNull(classifier2, "classifier");
        super(referenceExpression);
        this.classifier = classifier2;
        this.classValueReceiver = classValueReceiver;
    }
}

