/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.PackagePartSource;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class JvmPackagePartSource
implements PackagePartSource {
    @NotNull
    private final JvmClassName className;

    @NotNull
    public final Name getSimpleName() {
        Name name = Name.identifier(StringsKt.substringAfterLast$default(this.className.getInternalName(), '/', null, 2, null));
        Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(classNam\u2026.substringAfterLast('/'))");
        return name;
    }

    @NotNull
    public final ClassId getClassId() {
        return new ClassId(this.className.getPackageFqName(), this.getSimpleName());
    }

    @NotNull
    public final JvmClassName getClassName() {
        return this.className;
    }

    public JvmPackagePartSource(@NotNull JvmClassName className) {
        Intrinsics.checkParameterIsNotNull(className, "className");
        this.className = className;
    }

    public JvmPackagePartSource(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        JvmClassName jvmClassName = JvmClassName.byClassId(classId);
        Intrinsics.checkExpressionValueIsNotNull(jvmClassName, "JvmClassName.byClassId(classId)");
        this(jvmClassName);
    }
}

