/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler;

import com.intellij.openapi.compiler.CompilerMessageCategory;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilationException
extends Exception {
    private final Collection<Message> myMessages;

    public CompilationException(String message) {
        this(message, Collections.emptyList());
    }

    public CompilationException(String message, Collection<Message> messages) {
        super(message);
        this.myMessages = messages;
    }

    @NotNull
    public Collection<Message> getMessages() {
        Collection<Message> collection = this.myMessages;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/compiler/CompilationException", "getMessages"));
        }
        return collection;
    }

    public static class Message {
        @NotNull
        private final CompilerMessageCategory myCategory;
        @NotNull
        private final String myMessage;
        @Nullable
        private final String myUrl;
        private final int myLine;
        private final int myColumn;

        public Message(CompilerMessageCategory category, String message) {
            this(category, message, null, -1, -1);
        }

        public Message(@NotNull CompilerMessageCategory category, @NotNull String message, @Nullable String url, int line, int column) {
            if (category == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/openapi/compiler/CompilationException$Message", "<init>"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/compiler/CompilationException$Message", "<init>"));
            }
            this.myCategory = category;
            this.myMessage = message;
            this.myUrl = url;
            this.myLine = line;
            this.myColumn = column;
        }

        @NotNull
        public CompilerMessageCategory getCategory() {
            CompilerMessageCategory compilerMessageCategory = this.myCategory;
            if (compilerMessageCategory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/compiler/CompilationException$Message", "getCategory"));
            }
            return compilerMessageCategory;
        }

        @NotNull
        public String getText() {
            String string = this.myMessage;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/compiler/CompilationException$Message", "getText"));
            }
            return string;
        }

        @Nullable
        public String getUrl() {
            return this.myUrl;
        }

        public int getLine() {
            return this.myLine;
        }

        public int getColumn() {
            return this.myColumn;
        }
    }
}

