/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.AdbWrapper;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.BrokenPackage;
import com.android.sdklib.internal.repository.packages.FullRevisionPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDesc;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

@Deprecated
public class PlatformToolPackage
extends FullRevisionPackage {
    public static final String INSTALL_ID = "platform-tools";
    public static final String INSTALL_ID_PREVIEW = "platform-tools-preview";
    private final IPkgDesc mPkgDesc = this.setDescriptions(PkgDesc.Builder.newPlatformTool(this.getRevision())).create();

    public PlatformToolPackage(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
    }

    public static Package create(SdkSource source, Properties props, int revision, String license, String description, String descUrl, String archiveOsPath) {
        PlatformToolPackage ptp = new PlatformToolPackage(source, props, revision, license, description, descUrl, archiveOsPath);
        File platformToolsFolder = new File(archiveOsPath);
        String error = null;
        if (!platformToolsFolder.isDirectory()) {
            error = "platform-tools folder is missing";
        } else {
            File[] files = platformToolsFolder.listFiles();
            if (files == null || files.length == 0) {
                error = "platform-tools folder is empty";
            } else {
                HashSet<String> names = new HashSet<String>();
                for (File file : files) {
                    names.add(file.getName());
                }
                String[] expected = new String[]{SdkConstants.FN_ADB};
                if (ptp.getRevision().getMajor() < 17) {
                    expected = new String[]{SdkConstants.FN_ADB, SdkConstants.FN_AAPT, SdkConstants.FN_AIDL, SdkConstants.FN_DX};
                }
                for (String name : expected) {
                    if (names.contains(name)) continue;
                    error = error == null ? "platform-tools folder is missing " : error + ", ";
                    error = error + name;
                }
            }
        }
        if (error != null) {
            String shortDesc = ptp.getShortDescription() + " [*]";
            String longDesc = String.format("Broken Platform-Tools Package: %1$s\n[*] Package cannot be used due to error: %2$s", description, error);
            BrokenPackage ba = new BrokenPackage(props, shortDesc, longDesc, 0, 0, archiveOsPath, PkgDesc.Builder.newPlatformTool(ptp.getRevision()).setDescriptionShort(shortDesc).create());
            return ba;
        }
        return ptp;
    }

    protected PlatformToolPackage(SdkSource source, Properties props, int revision, String license, String description, String descUrl, String archiveOsPath) {
        super(source, props, revision, license, description, descUrl, archiveOsPath);
    }

    @Override
    @NonNull
    public IPkgDesc getPkgDesc() {
        return this.mPkgDesc;
    }

    @Override
    public String installId() {
        if (this.getRevision().isPreview()) {
            return INSTALL_ID_PREVIEW;
        }
        return INSTALL_ID;
    }

    @Override
    public String getListDescription() {
        String ld = this.getListDisplay();
        if (!ld.isEmpty()) {
            return String.format("%1$s%2$s", ld, this.isObsolete() ? " (Obsolete)" : "");
        }
        return String.format("Android SDK Platform-tools%1$s", this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getShortDescription() {
        String ld = this.getListDisplay();
        if (!ld.isEmpty()) {
            return String.format("%1$s, revision %2$s%3$s", ld, this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return String.format("Android SDK Platform-tools, revision %1$s%2$s", this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getLongDescription() {
        String s = this.getDescription();
        if (s == null || s.length() == 0) {
            s = this.getShortDescription();
        }
        if (s.indexOf("revision") == -1) {
            s = s + String.format("\nRevision %1$s%2$s", this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return s;
    }

    @Override
    public File getInstallFolder(String osSdkRoot, SdkManager sdkManager) {
        return new File(osSdkRoot, INSTALL_ID);
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        return this.sameItemAs(pkg, FullRevision.PreviewComparison.COMPARE_TYPE);
    }

    @Override
    public boolean sameItemAs(Package pkg, FullRevision.PreviewComparison comparePreview) {
        if (pkg instanceof PlatformToolPackage) {
            switch (comparePreview) {
                case IGNORE: {
                    return true;
                }
                case COMPARE_NUMBER: 
                case COMPARE_TYPE: {
                    return pkg.getRevision().isPreview() == this.getRevision().isPreview();
                }
            }
        }
        return false;
    }

    @Override
    public boolean preInstallHook(Archive archive, ITaskMonitor monitor, String osSdkRoot, File installFolder) {
        AdbWrapper aw = new AdbWrapper(osSdkRoot, monitor);
        aw.stopAdb();
        return super.preInstallHook(archive, monitor, osSdkRoot, installFolder);
    }
}

