/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AddLibraryToDependenciesFix
extends OrderEntryFix {
    private final Library myLibrary;
    private final Module myCurrentModule;
    private final PsiReference myReference;
    private final String myQualifiedClassName;

    public AddLibraryToDependenciesFix(@NotNull Module currentModule, @NotNull Library library, @NotNull PsiReference reference, @Nullable String qualifiedClassName) {
        if (currentModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModule", "com/intellij/codeInsight/daemon/impl/quickfix/AddLibraryToDependenciesFix", "<init>"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/codeInsight/daemon/impl/quickfix/AddLibraryToDependenciesFix", "<init>"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInsight/daemon/impl/quickfix/AddLibraryToDependenciesFix", "<init>"));
        }
        this.myLibrary = library;
        this.myCurrentModule = currentModule;
        this.myReference = reference;
        this.myQualifiedClassName = qualifiedClassName;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("orderEntry.fix.add.library.to.classpath", LibraryUtil.getPresentableName((Library)this.myLibrary));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddLibraryToDependenciesFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("orderEntry.fix.family.add.library.to.classpath", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddLibraryToDependenciesFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddLibraryToDependenciesFix", "isAvailable"));
        }
        return !project.isDisposed() && !this.myCurrentModule.isDisposed() && !((LibraryEx)this.myLibrary).isDisposed();
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddLibraryToDependenciesFix", "invoke"));
        }
        DependencyScope scope = AddLibraryToDependenciesFix.suggestScopeByLocation(this.myCurrentModule, this.myReference.getElement());
        JavaProjectModelModificationService.getInstance(project).addDependency(this.myCurrentModule, this.myLibrary, scope);
        if (editor != null) {
            AddLibraryToDependenciesFix.importClass(this.myCurrentModule, editor, this.myReference, this.myQualifiedClassName);
        }
    }
}

