/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.ide.DataManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LossyEncodingInspection
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.LossyEncodingInspection");
    private static final LocalQuickFix CHANGE_ENCODING_FIX = new ChangeEncodingFix();
    private static final LocalQuickFix RELOAD_ENCODING_FIX = new ReloadInAnotherEncodingFix();

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.internationalization.issues", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LossyEncodingInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"lossy.encoding", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LossyEncodingInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("LossyEncoding" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LossyEncodingInspection", "getShortName"));
        }
        return "LossyEncoding";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/LossyEncodingInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/LossyEncodingInspection", "checkFile"));
        }
        if (InjectedLanguageManager.getInstance((Project)file2.getProject()).isInjectedFragment(file2)) {
            return null;
        }
        if (!file2.isPhysical()) {
            return null;
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        if (viewProvider.getBaseLanguage() != file2.getLanguage()) {
            return null;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (!virtualFile.isInLocalFileSystem()) {
            return null;
        }
        CharSequence text = viewProvider.getContents();
        Charset charset = LoadTextUtil.extractCharsetFromFileContent(file2.getProject(), virtualFile, text);
        if (charset instanceof Native2AsciiCharset) {
            return null;
        }
        SmartList descriptors = new SmartList();
        boolean ok = LossyEncodingInspection.checkFileLoadedInWrongEncoding(file2, manager, isOnTheFly, virtualFile, charset, (List<ProblemDescriptor>)descriptors);
        if (ok) {
            LossyEncodingInspection.checkIfCharactersWillBeLostAfterSave(file2, manager, isOnTheFly, text, charset, (List<ProblemDescriptor>)descriptors);
        }
        return descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }

    private static boolean checkFileLoadedInWrongEncoding(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull VirtualFile virtualFile, @NotNull Charset charset, @NotNull List<ProblemDescriptor> descriptors) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/LossyEncodingInspection", "checkFileLoadedInWrongEncoding"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/LossyEncodingInspection", "checkFileLoadedInWrongEncoding"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/codeInspection/LossyEncodingInspection", "checkFileLoadedInWrongEncoding"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/codeInspection/LossyEncodingInspection", "checkFileLoadedInWrongEncoding"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/LossyEncodingInspection", "checkFileLoadedInWrongEncoding"));
        }
        if (FileDocumentManager.getInstance().isFileModified(virtualFile) || EncodingUtil.checkCanReload((VirtualFile)virtualFile).second != null) {
            return true;
        }
        if (!LossyEncodingInspection.isGoodCharset(virtualFile, charset)) {
            descriptors.add(manager.createProblemDescriptor((PsiElement)file2, "File was loaded in the wrong encoding: '" + charset + "'", RELOAD_ENCODING_FIX, ProblemHighlightType.GENERIC_ERROR, isOnTheFly));
            return false;
        }
        return true;
    }

    private static boolean isGoodCharset(@NotNull VirtualFile virtualFile, @NotNull Charset charset) {
        boolean equals;
        byte[] bytesToSave;
        byte[] loadedBytes;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/codeInspection/LossyEncodingInspection", "isGoodCharset"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/codeInspection/LossyEncodingInspection", "isGoodCharset"));
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(virtualFile);
        if (document == null) {
            return true;
        }
        try {
            loadedBytes = virtualFile.contentsToByteArray();
            bytesToSave = new String(loadedBytes, charset).getBytes(charset);
        }
        catch (Exception e) {
            return true;
        }
        byte[] bom = virtualFile.getBOM();
        if (bom != null && !ArrayUtil.startsWith((byte[])bytesToSave, (byte[])bom)) {
            bytesToSave = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytesToSave);
        }
        if (!(equals = Arrays.equals(bytesToSave, loadedBytes)) && LOG.isDebugEnabled()) {
            try {
                FileUtil.writeToFile((File)new File("C:\\temp\\bytesToSave"), (byte[])bytesToSave);
                FileUtil.writeToFile((File)new File("C:\\temp\\loadedBytes"), (byte[])loadedBytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return equals;
    }

    private static void checkIfCharactersWillBeLostAfterSave(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull CharSequence text, @NotNull Charset charset, @NotNull List<ProblemDescriptor> descriptors) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/LossyEncodingInspection", "checkIfCharactersWillBeLostAfterSave"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/LossyEncodingInspection", "checkIfCharactersWillBeLostAfterSave"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInspection/LossyEncodingInspection", "checkIfCharactersWillBeLostAfterSave"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/codeInspection/LossyEncodingInspection", "checkIfCharactersWillBeLostAfterSave"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/LossyEncodingInspection", "checkIfCharactersWillBeLostAfterSave"));
        }
        int errorCount = 0;
        int start = -1;
        for (int i = 0; i <= text.length(); ++i) {
            char c;
            char c2 = c = i == text.length() ? (char)'\u0000' : text.charAt(i);
            if (i == text.length() || LossyEncodingInspection.isRepresentable(c, charset)) {
                if (start == -1) continue;
                TextRange range = new TextRange(start, i);
                String message = InspectionsBundle.message((String)"unsupported.character.for.the.charset", (Object[])new Object[]{charset});
                ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)file2, range, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[]{CHANGE_ENCODING_FIX});
                descriptors.add(descriptor);
                start = -1;
                if (errorCount++ <= 200) continue;
                break;
            }
            if (start != -1) continue;
            start = i;
        }
    }

    private static boolean isRepresentable(char c, @NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/codeInspection/LossyEncodingInspection", "isRepresentable"));
        }
        String str = Character.toString(c);
        ByteBuffer out = charset.encode(str);
        CharBuffer buffer = charset.decode(out);
        return str.equals(buffer.toString());
    }

    private static class ChangeEncodingFix
    implements LocalQuickFix {
        private ChangeEncodingFix() {
        }

        @NotNull
        public String getName() {
            if ("Change file encoding" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LossyEncodingInspection$ChangeEncodingFix", "getName"));
            }
            return "Change file encoding";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LossyEncodingInspection$ChangeEncodingFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Editor editor;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/LossyEncodingInspection$ChangeEncodingFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/LossyEncodingInspection$ChangeEncodingFix", "applyFix"));
            }
            PsiFile psiFile = descriptor.getPsiElement().getContainingFile();
            VirtualFile virtualFile = psiFile.getVirtualFile();
            DataContext dataContext = ChangeEncodingFix.createDataContext(editor, (editor = PsiUtilBase.findEditor((PsiElement)psiFile)) == null ? null : editor.getComponent(), virtualFile, project);
            ListPopup popup = new ChangeFileEncodingAction().createPopup(dataContext);
            if (popup != null) {
                popup.showInBestPositionFor(dataContext);
            }
        }

        @NotNull
        public static DataContext createDataContext(Editor editor, Component component, VirtualFile selectedFile, Project project) {
            DataContext parent = DataManager.getInstance().getDataContext(component);
            DataContext context = SimpleDataContext.getSimpleContext(PlatformDataKeys.CONTEXT_COMPONENT.getName(), editor == null ? null : editor.getComponent(), parent);
            DataContext projectContext = SimpleDataContext.getSimpleContext(CommonDataKeys.PROJECT.getName(), project, context);
            DataContext dataContext = SimpleDataContext.getSimpleContext(CommonDataKeys.VIRTUAL_FILE.getName(), selectedFile, projectContext);
            if (dataContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LossyEncodingInspection$ChangeEncodingFix", "createDataContext"));
            }
            return dataContext;
        }
    }

    private static class ReloadInAnotherEncodingFix
    extends ChangeEncodingFix {
        private ReloadInAnotherEncodingFix() {
        }

        @Override
        @NotNull
        public String getName() {
            if ("Reload in another encoding" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LossyEncodingInspection$ReloadInAnotherEncodingFix", "getName"));
            }
            return "Reload in another encoding";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/LossyEncodingInspection$ReloadInAnotherEncodingFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/LossyEncodingInspection$ReloadInAnotherEncodingFix", "applyFix"));
            }
            if (FileDocumentManager.getInstance().isFileModified(descriptor.getPsiElement().getContainingFile().getVirtualFile())) {
                return;
            }
            super.applyFix(project, descriptor);
        }
    }
}

