/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.find.impl.FindDialog;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.TitledSeparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileFilterPanel {
    private JCheckBox myUseFileMask;
    private JComboBox myFileMask;
    private JPanel myPanel;

    FileFilterPanel() {
        this.$$$setupUI$$$();
    }

    void init() {
        FindDialog.initFileFilter(this.myFileMask, this.myUseFileMask);
    }

    @Nullable
    SearchScope getSearchScope() {
        if (!this.myUseFileMask.isSelected()) {
            return null;
        }
        String text = (String)this.myFileMask.getSelectedItem();
        if (text == null) {
            return null;
        }
        final Pattern pattern = FindInProjectUtil.createFileMaskRegExp(text);
        return new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/actions/FileFilterPanel$1", "contains"));
                }
                return pattern == null || pattern.matcher(file2.getName()).matches();
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/codeInspection/actions/FileFilterPanel$1", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/codeInspection/actions/FileFilterPanel$1", "compare"));
                }
                return 0;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/codeInspection/actions/FileFilterPanel$1", "isSearchInModuleContent"));
                }
                return true;
            }

            public boolean isSearchInLibraries() {
                return true;
            }
        };
    }

    JPanel getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myUseFileMask = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/FindBundle").getString("find.filter.file.mask.checkbox"));
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myFileMask = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 7, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(ResourceBundle.getBundle("messages/FindBundle").getString("find.filter.file.name.group"));
        jPanel.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

