/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.DefaultProjectStoreImpl;
import com.intellij.configurationStore.ProjectStoreImplKt;
import com.intellij.configurationStore.StateLoadPolicy;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0006\u0010\u001d\u001a\u00020\u000fJ\u0006\u0010\u001e\u001a\u00020\u001bJ\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020 J \u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020 H\u0004R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006*"}, d2={"Lcom/intellij/configurationStore/ProjectStoreBase;", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "project", "Lcom/intellij/openapi/project/impl/ProjectImpl;", "(Lcom/intellij/openapi/project/impl/ProjectImpl;)V", "loadPolicy", "Lcom/intellij/configurationStore/StateLoadPolicy;", "getLoadPolicy", "()Lcom/intellij/configurationStore/StateLoadPolicy;", "setLoadPolicy", "(Lcom/intellij/configurationStore/StateLoadPolicy;)V", "getProject", "()Lcom/intellij/openapi/project/impl/ProjectImpl;", "scheme", "Lcom/intellij/openapi/components/StorageScheme;", "getScheme", "()Lcom/intellij/openapi/components/StorageScheme;", "setScheme", "(Lcom/intellij/openapi/components/StorageScheme;)V", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManagerImpl;", "clearStorages", "", "getProjectBasePath", "", "getProjectFilePath", "getStorageScheme", "getWorkspaceFilePath", "isOptimiseTestLoadSpeed", "", "loadProjectFromTemplate", "defaultProject", "Lcom/intellij/openapi/project/Project;", "setOptimiseTestLoadSpeed", "value", "setPath", "filePath", "refreshVfs", "useOldWorkspaceContentIfExists", "configuration-store-impl"})
public abstract class ProjectStoreBase
extends ComponentStoreImpl
implements IProjectStore {
    @NotNull
    private StorageScheme scheme;
    @NotNull
    private StateLoadPolicy loadPolicy;
    @NotNull
    private final ProjectImpl project;

    @NotNull
    public final StorageScheme getScheme() {
        return this.scheme;
    }

    public final void setScheme(@NotNull StorageScheme storageScheme) {
        Intrinsics.checkParameterIsNotNull((Object)storageScheme, (String)"<set-?>");
        this.scheme = storageScheme;
    }

    @Override
    @NotNull
    public final StateLoadPolicy getLoadPolicy() {
        return this.loadPolicy;
    }

    public final void setLoadPolicy(@NotNull StateLoadPolicy stateLoadPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)stateLoadPolicy), (String)"<set-?>");
        this.loadPolicy = stateLoadPolicy;
    }

    @Override
    public final boolean isOptimiseTestLoadSpeed() {
        return Intrinsics.areEqual((Object)((Object)this.loadPolicy), (Object)((Object)StateLoadPolicy.LOAD)) ^ true;
    }

    @Override
    @NotNull
    public final StorageScheme getStorageScheme() {
        return this.scheme;
    }

    @Override
    @NotNull
    public abstract StateStorageManagerImpl getStorageManager();

    @Override
    public final void setOptimiseTestLoadSpeed(boolean value) {
        this.loadPolicy = value ? StateLoadPolicy.NOT_LOAD : StateLoadPolicy.LOAD;
    }

    @Override
    @NotNull
    public String getProjectFilePath() {
        return this.getStorageManager().expandMacro("$PROJECT_FILE$");
    }

    @Override
    @NotNull
    public final String getWorkspaceFilePath() {
        return this.getStorageManager().expandMacro("$WORKSPACE_FILE$");
    }

    @Override
    public final void clearStorages() {
        this.getStorageManager().clearStorages();
    }

    @Override
    public final void loadProjectFromTemplate(@NotNull Project defaultProject) {
        Intrinsics.checkParameterIsNotNull((Object)defaultProject, (String)"defaultProject");
        defaultProject.save();
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)defaultProject);
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.DefaultProjectStoreImpl");
        }
        Element element = ((DefaultProjectStoreImpl)iComponentStore).getStateCopy();
        if (element != null) {
            StateStorage stateStorage = StateStorageManagerImpl.getOrCreateStorage$default(this.getStorageManager(), "$PROJECT_FILE$", null, null, null, 14, null);
            if (stateStorage == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.XmlElementStorage");
            }
            ((XmlElementStorage)stateStorage).setDefaultState(element);
        }
    }

    @Override
    @NotNull
    public final String getProjectBasePath() {
        String string;
        String path = PathUtilRt.getParentPath((String)this.getProjectFilePath());
        if (Intrinsics.areEqual((Object)this.scheme, (Object)StorageScheme.DEFAULT)) {
            String string2 = path;
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        } else {
            String string3 = PathUtilRt.getParentPath((String)path);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"PathUtilRt.getParentPath(path)");
        }
        return string;
    }

    protected final void setPath(@NotNull String filePath, boolean refreshVfs, boolean useOldWorkspaceContentIfExists) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        StateStorageManagerImpl storageManager2 = this.getStorageManager();
        LocalFileSystem fs = LocalFileSystem.getInstance();
        if (FileUtilRt.extensionEquals((String)filePath, (String)"ipr")) {
            this.scheme = StorageScheme.DEFAULT;
            storageManager2.addMacro("$PROJECT_FILE$", filePath);
            String workspacePath = ProjectStoreImplKt.access$composeWsPath(filePath);
            storageManager2.addMacro("$WORKSPACE_FILE$", workspacePath);
            if (refreshVfs) {
                ActionsKt.invokeAndWaitIfNeed((Function0<Unit>)((Function0)new Function0<Unit>(fs, filePath, workspacePath){
                    final /* synthetic */ LocalFileSystem $fs;
                    final /* synthetic */ String $filePath;
                    final /* synthetic */ String $workspacePath;

                    public final void invoke() {
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{this.$fs.refreshAndFindFileByPath(this.$filePath), this.$fs.refreshAndFindFileByPath(this.$workspacePath)});
                    }
                    {
                        this.$fs = localFileSystem;
                        this.$filePath = string;
                        this.$workspacePath = string2;
                        super(0);
                    }
                }));
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.setOptimiseTestLoadSpeed(!new File(filePath).exists());
            }
        } else {
            File workspace;
            String string;
            this.scheme = StorageScheme.DIRECTORY_BASED;
            File file2 = new File(filePath);
            boolean isDir = !useOldWorkspaceContentIfExists || file2.isDirectory();
            StringBuilder stringBuilder = new StringBuilder();
            if (isDir) {
                string = filePath;
            } else {
                String string2 = PathUtilRt.getParentPath((String)filePath);
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PathUtilRt.getParentPath(filePath)");
            }
            String configDir = stringBuilder.append(string).append("/").append(".idea").toString();
            storageManager2.addMacro("$PROJECT_CONFIG_DIR$", configDir);
            storageManager2.addMacro("$PROJECT_FILE$", configDir + "/misc.xml");
            storageManager2.addMacro("$WORKSPACE_FILE$", configDir + "/workspace.xml");
            if (!isDir && !(workspace = new File(this.getWorkspaceFilePath())).exists()) {
                ProjectStoreImplKt.access$useOldWorkspaceContent(filePath, workspace);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.setOptimiseTestLoadSpeed(!file2.exists());
            }
            if (refreshVfs) {
                ActionsKt.invokeAndWaitIfNeed((Function0<Unit>)((Function0)new Function0<Unit>(fs, configDir){
                    final /* synthetic */ LocalFileSystem $fs;
                    final /* synthetic */ String $configDir;

                    public final void invoke() {
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{this.$fs.refreshAndFindFileByPath(this.$configDir)});
                    }
                    {
                        this.$fs = localFileSystem;
                        this.$configDir = string;
                        super(0);
                    }
                }));
            }
        }
    }

    @Override
    @NotNull
    protected final ProjectImpl getProject() {
        return this.project;
    }

    public ProjectStoreBase(@NotNull ProjectImpl project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.scheme = StorageScheme.DEFAULT;
        this.loadPolicy = StateLoadPolicy.LOAD;
    }
}

