/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;

public class ArgumentValueDescriptorImpl
extends ValueDescriptorImpl {
    private final DecompiledLocalVariable myVariable;

    public ArgumentValueDescriptorImpl(Project project, DecompiledLocalVariable variable, Value value) {
        super(project, value);
        this.myVariable = variable;
        this.setLvalue(true);
    }

    @Override
    public boolean canSetValue() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return this.getValue() instanceof PrimitiveValue;
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        return this.getValue();
    }

    public DecompiledLocalVariable getVariable() {
        return this.myVariable;
    }

    @Override
    public String getName() {
        return this.myVariable.getDisplayName();
    }

    public boolean isParameter() {
        return this.myVariable.isParam();
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        try {
            return elementFactory.createExpressionFromText(this.getName(), PositionUtil.getContextElement((StackFrameContext)context));
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.local.variable.name", (Object[])new Object[]{this.getName()}), (Throwable)e);
        }
    }
}

