/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JBProtocolCommand {
    public static final ExtensionPointName<JBProtocolCommand> EP_NAME = new ExtensionPointName("com.intellij.jbProtocolCommand");

    @NotNull
    public abstract String getCommandName();

    public abstract void perform(String var1, Map<String, String> var2);

    @Nullable
    public static JBProtocolCommand findCommand(@Nullable String commandName) {
        if (commandName != null) {
            for (JBProtocolCommand command : (JBProtocolCommand[])EP_NAME.getExtensions()) {
                if (!command.getCommandName().equals(commandName)) continue;
                return command;
            }
        }
        return null;
    }

    public static void handleCurrentCommand() {
        JBProtocolCommand command = JBProtocolCommand.findCommand(JetBrainsProtocolHandler.getCommand());
        if (command != null) {
            try {
                command.perform(JetBrainsProtocolHandler.getMainParameter(), JetBrainsProtocolHandler.getParameters());
            }
            finally {
                JetBrainsProtocolHandler.clear();
            }
        }
    }
}

