/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.MergeRequest;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.external.ContentExternalizer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;

class ExternalToolContentExternalizer
implements ContentExternalizer {
    private final DiffRequest myRequest;
    private final int myIndex;
    @NonNls
    public static final String STD_PREFIX = "IJDiff";

    public ExternalToolContentExternalizer(DiffRequest request, int index) {
        this.myRequest = request;
        this.myIndex = index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getContentFile() throws IOException {
        File tempFile2;
        String extension = this.chooseExtension();
        String name = this.chooseName();
        if (name.length() <= 3) {
            name = "___" + name;
        }
        try {
            tempFile2 = FileUtil.createTempFile((String)name, (String)extension);
        }
        catch (IOException e) {
            tempFile2 = FileUtil.createTempFile((String)STD_PREFIX, (String)extension);
        }
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(tempFile2);
            DiffContent content = this.getContent();
            stream.write(this.myRequest instanceof MergeRequest ? content.getDocument().getText().getBytes() : content.getBytes());
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return tempFile2;
    }

    private String chooseName() {
        String title = this.myRequest.getContentTitles()[this.myIndex];
        char[] chars = title.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            if (Character.isLetterOrDigit(aChar)) continue;
            chars[i] = 95;
        }
        return new String(chars);
    }

    private String chooseExtension() {
        String extension;
        DiffContent content = this.getContent();
        VirtualFile contentFile = content.getFile();
        if (contentFile != null) {
            extension = "." + contentFile.getExtension();
        } else {
            FileType contentType = content.getContentType();
            if (contentType == null) {
                contentType = DiffUtil.chooseContentTypes(this.myRequest.getContents())[this.myIndex];
            }
            extension = contentType != null ? "." + contentType.getDefaultExtension() : null;
        }
        return extension;
    }

    private DiffContent getContent() {
        return this.myRequest.getContents()[this.myIndex];
    }
}

