/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.formove;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsFileListenerContextHelper;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.SortByVcsRoots;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.FilePathByPathComparator;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TriggerAdditionOrDeletion {
    private final Collection<FilePath> myExisting;
    private final Collection<FilePath> myDeleted;
    private final Set<FilePath> myAffected;
    private final Project myProject;
    private final boolean mySilentAddDelete;
    private ProjectLevelVcsManager myVcsManager;
    private AbstractVcsHelper myVcsHelper;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.patch.formove.TriggerAdditionOrDeletion");
    private final VcsFileListenerContextHelper myVcsFileListenerContextHelper;
    private MultiMap<VcsRoot, FilePath> myPreparedAddition;
    private MultiMap<VcsRoot, FilePath> myPreparedDeletion;

    public TriggerAdditionOrDeletion(Project project, boolean silentAddDelete) {
        this.myProject = project;
        this.mySilentAddDelete = Registry.is((String)"vcs.add.remove.silent");
        this.myExisting = new HashSet<FilePath>();
        this.myDeleted = new HashSet<FilePath>();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myVcsHelper = AbstractVcsHelper.getInstance((Project)this.myProject);
        this.myAffected = new HashSet<FilePath>();
        this.myVcsFileListenerContextHelper = VcsFileListenerContextHelper.getInstance((Project)this.myProject);
    }

    public void addExisting(Collection<FilePath> files) {
        this.myExisting.addAll(files);
        this.logFiles("FOR ADD", files);
    }

    public void addDeleted(Collection<FilePath> files) {
        this.myDeleted.addAll(files);
        this.logFiles("FOR DELETION", files);
    }

    private void logFiles(String name, Collection<FilePath> files) {
    }

    public void prepare() {
        if (this.myExisting.isEmpty() && this.myDeleted.isEmpty()) {
            return;
        }
        SortByVcsRoots sortByVcsRoots = new SortByVcsRoots(this.myProject, (Convertor)new Convertor.IntoSelf());
        if (!this.myExisting.isEmpty()) {
            this.processAddition((SortByVcsRoots<FilePath>)sortByVcsRoots);
        }
        if (!this.myDeleted.isEmpty()) {
            this.processDeletion((SortByVcsRoots<FilePath>)sortByVcsRoots);
        }
    }

    public void processIt() {
        Collection filePaths;
        CheckinEnvironment localChangesProvider;
        VcsRoot vcsRoot;
        if (this.myPreparedDeletion != null) {
            for (Map.Entry entry : this.myPreparedDeletion.entrySet()) {
                vcsRoot = (VcsRoot)entry.getKey();
                localChangesProvider = vcsRoot.getVcs().getCheckinEnvironment();
                if (localChangesProvider == null) continue;
                filePaths = (Collection)entry.getValue();
                if (vcsRoot.getVcs().fileListenerIsSynchronous()) {
                    this.myAffected.addAll(filePaths);
                    continue;
                }
                this.askUserIfNeededDeletion(vcsRoot.getVcs(), (List)filePaths);
                this.myAffected.addAll(filePaths);
                localChangesProvider.scheduleMissingFileForDeletion((List)filePaths);
            }
        }
        if (this.myPreparedAddition != null) {
            for (Map.Entry entry : this.myPreparedAddition.entrySet()) {
                vcsRoot = (VcsRoot)entry.getKey();
                localChangesProvider = vcsRoot.getVcs().getCheckinEnvironment();
                if (localChangesProvider == null) continue;
                filePaths = (Collection)entry.getValue();
                if (vcsRoot.getVcs().fileListenerIsSynchronous()) {
                    this.myAffected.addAll(filePaths);
                    continue;
                }
                this.askUserIfNeededAddition(vcsRoot.getVcs(), (List)filePaths);
                this.myAffected.addAll(filePaths);
                localChangesProvider.scheduleUnversionedFilesForAddition(ObjectsConvertor.fp2vf(filePaths));
            }
        }
    }

    public Set<FilePath> getAffected() {
        return this.myAffected;
    }

    private void processDeletion(SortByVcsRoots<FilePath> sortByVcsRoots) {
        MultiMap map = sortByVcsRoots.sort(this.myDeleted);
        this.myPreparedDeletion = new MultiMap();
        for (VcsRoot vcsRoot : map.keySet()) {
            CheckinEnvironment localChangesProvider;
            if (vcsRoot == null || vcsRoot.getVcs() == null || (localChangesProvider = vcsRoot.getVcs().getCheckinEnvironment()) == null) continue;
            boolean takeDirs = vcsRoot.getVcs().areDirectoriesVersionedItems();
            Collection files = map.get((Object)vcsRoot);
            LinkedList<FilePath> toBeDeleted = new LinkedList<FilePath>();
            for (FilePath file2 : files) {
                FilePath parent = file2.getParentPath();
                if (!takeDirs && file2.isDirectory() || parent == null || !parent.getIOFile().exists()) continue;
                toBeDeleted.add(file2);
            }
            if (toBeDeleted.isEmpty()) {
                return;
            }
            if (!vcsRoot.getVcs().fileListenerIsSynchronous()) {
                for (FilePath filePath : toBeDeleted) {
                    this.myVcsFileListenerContextHelper.ignoreDeleted(filePath);
                }
            }
            this.myPreparedDeletion.put((Object)vcsRoot, toBeDeleted);
        }
    }

    private void processAddition(SortByVcsRoots<FilePath> sortByVcsRoots) {
        MultiMap map = sortByVcsRoots.sort(this.myExisting);
        this.myPreparedAddition = new MultiMap();
        for (VcsRoot vcsRoot : map.keySet()) {
            List<Object> toBeAdded;
            CheckinEnvironment localChangesProvider;
            if (vcsRoot == null || vcsRoot.getVcs() == null || (localChangesProvider = vcsRoot.getVcs().getCheckinEnvironment()) == null) continue;
            boolean takeDirs = vcsRoot.getVcs().areDirectoriesVersionedItems();
            Collection files = map.get((Object)vcsRoot);
            if (takeDirs) {
                RecursiveCheckAdder adder = new RecursiveCheckAdder(vcsRoot.getPath());
                for (FilePath file2 : files) {
                    adder.process(file2);
                }
                toBeAdded = adder.getToBeAdded();
            } else {
                toBeAdded = new LinkedList();
                for (FilePath filePath : files) {
                    if (filePath.isDirectory()) continue;
                    toBeAdded.add(filePath);
                }
            }
            if (toBeAdded.isEmpty()) {
                return;
            }
            Collections.sort(toBeAdded, FilePathByPathComparator.getInstance());
            if (!vcsRoot.getVcs().fileListenerIsSynchronous()) {
                for (FilePath filePath : toBeAdded) {
                    this.myVcsFileListenerContextHelper.ignoreAdded(filePath.getVirtualFile());
                }
            }
            this.myPreparedAddition.put((Object)vcsRoot, toBeAdded);
        }
    }

    private void askUserIfNeededAddition(AbstractVcs vcs, List<FilePath> toBeAdded) {
        if (this.mySilentAddDelete) {
            return;
        }
        VcsShowConfirmationOption confirmationOption = this.myVcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, vcs);
        if (VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY.equals((Object)confirmationOption.getValue())) {
            toBeAdded.clear();
        } else if (VcsShowConfirmationOption.Value.SHOW_CONFIRMATION.equals((Object)confirmationOption.getValue())) {
            Collection files = this.myVcsHelper.selectFilePathsToProcess(toBeAdded, "Select files to add to " + vcs.getDisplayName(), null, "Schedule for addition", "Do you want to schedule the following file for addition to " + vcs.getDisplayName() + "\n{0}", confirmationOption);
            if (files == null) {
                toBeAdded.clear();
            } else {
                toBeAdded.retainAll(files);
            }
        }
    }

    private void askUserIfNeededDeletion(AbstractVcs vcs, List<FilePath> toBeDeleted) {
        if (this.mySilentAddDelete) {
            return;
        }
        VcsShowConfirmationOption confirmationOption = this.myVcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, vcs);
        if (VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY.equals((Object)confirmationOption.getValue())) {
            toBeDeleted.clear();
        } else if (VcsShowConfirmationOption.Value.SHOW_CONFIRMATION.equals((Object)confirmationOption.getValue())) {
            Collection files = this.myVcsHelper.selectFilePathsToProcess(toBeDeleted, "Select files to remove from " + vcs.getDisplayName(), null, "Schedule for deletion", "Do you want to schedule the following file for deletion from " + vcs.getDisplayName() + "\n{0}", confirmationOption);
            if (files == null) {
                toBeDeleted.clear();
            } else {
                toBeDeleted.retainAll(files);
            }
        }
    }

    private class RecursiveCheckAdder {
        private final Set<FilePath> myToBeAdded;
        private ChangeListManager myChangeListManager;
        private final VirtualFile myRoot;

        private RecursiveCheckAdder(VirtualFile root) {
            this.myRoot = root;
            this.myToBeAdded = new HashSet<FilePath>();
            this.myChangeListManager = ChangeListManager.getInstance((Project)TriggerAdditionOrDeletion.this.myProject);
        }

        public void process(FilePath path) {
            for (FilePath current = path; current != null; current = current.getParentPath()) {
                VirtualFile vf = current.getVirtualFile();
                if (vf == null) {
                    vf = LocalFileSystem.getInstance().refreshAndFindFileByPath(current.getPath());
                }
                if (vf == null) {
                    return;
                }
                if (!VfsUtil.isAncestor((VirtualFile)this.myRoot, (VirtualFile)vf, (boolean)true)) {
                    return;
                }
                this.myToBeAdded.add(current);
            }
        }

        public List<FilePath> getToBeAdded() {
            return new ArrayList<FilePath>(this.myToBeAdded);
        }
    }
}

