/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude.ui;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.file.exclude.EnforcedPlainTextFileTypeFactory;
import com.intellij.openapi.file.exclude.EnforcedPlainTextFileTypeManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import javax.swing.Icon;

public class MarkAsPlainTextAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        VirtualFile[] selectedFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (selectedFiles == null || selectedFiles.length == 0) {
            return;
        }
        EnforcedPlainTextFileTypeManager typeManager = EnforcedPlainTextFileTypeManager.getInstance();
        assert (typeManager != null);
        ArrayList<VirtualFile> filesToMark = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : selectedFiles) {
            if (file2 == null || file2.isDirectory() || !EnforcedPlainTextFileTypeManager.isApplicableFor(file2) || typeManager.isMarkedAsPlainText(file2)) continue;
            filesToMark.add(file2);
        }
        if (project != null) {
            typeManager.markAsPlainText(project, filesToMark.toArray(new VirtualFile[filesToMark.size()]));
        }
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        VirtualFile[] selectedFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        Presentation presentation = e.getPresentation();
        EnforcedPlainTextFileTypeManager typeManager = EnforcedPlainTextFileTypeManager.getInstance();
        presentation.setVisible(false);
        if (typeManager == null || selectedFiles == null || selectedFiles.length == 0) {
            return;
        }
        for (VirtualFile file2 : selectedFiles) {
            if (EnforcedPlainTextFileTypeManager.isApplicableFor(file2) && !typeManager.isMarkedAsPlainText(file2)) continue;
            return;
        }
        presentation.setVisible(true);
        presentation.setIcon((Icon)EnforcedPlainTextFileTypeFactory.ENFORCED_PLAIN_TEXT_ICON);
    }
}

