/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerMachineCommandException
extends RuntimeException {
    public DockerMachineCommandException(int exitCode, @Nullable String stderr) {
        super(DockerMachineCommandException.buildErrorMessage(exitCode, stderr));
    }

    public DockerMachineCommandException(String message) {
        super(message);
    }

    @NotNull
    private static String buildErrorMessage(int exitCode, String stderr) {
        StringBuilder sb = new StringBuilder().append("Docker Machine exited with error code ").append(exitCode);
        if (StringUtil.isNotEmpty((String)stderr)) {
            sb.append(": ").append(stderr);
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/DockerMachineCommandException", "buildErrorMessage"));
        }
        return string;
    }
}

