/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.UtilKt;
import com.intellij.util.PathUtil;
import com.intellij.util.text.StringTokenizer;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class VfsTestUtil {
    public static final Key<String> TEST_DATA_FILE_PATH = Key.create((String)"TEST_DATA_FILE_PATH");

    private VfsTestUtil() {
    }

    public static VirtualFile createFile(VirtualFile root, String relativePath) {
        return VfsTestUtil.createFile(root, relativePath, "");
    }

    public static VirtualFile createFile(VirtualFile root, String relativePath, String text) {
        return VfsTestUtil.createFileOrDir(root, relativePath, text, false);
    }

    public static VirtualFile createDir(VirtualFile root, String relativePath) {
        return VfsTestUtil.createFileOrDir(root, relativePath, "", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VirtualFile createFileOrDir(VirtualFile root, String relativePath, String text, boolean dir) {
        VirtualFile virtualFile;
        AccessToken token = WriteAction.start();
        try {
            VirtualFile file2;
            VirtualFile parent = root;
            Assert.assertNotNull((Object)parent);
            StringTokenizer parents = new StringTokenizer(PathUtil.getParentPath((String)relativePath), "/");
            while (parents.hasMoreTokens()) {
                String name = parents.nextToken();
                VirtualFile child = parent.findChild(name);
                if (child == null || !child.isValid()) {
                    child = parent.createChildDirectory(VfsTestUtil.class, name);
                }
                parent = child;
            }
            parent.getChildren();
            if (dir) {
                file2 = parent.createChildDirectory(VfsTestUtil.class, PathUtil.getFileName((String)relativePath));
            } else {
                file2 = parent.findFileByRelativePath(relativePath);
                if (file2 == null) {
                    file2 = parent.createChildData(VfsTestUtil.class, PathUtil.getFileName((String)relativePath));
                }
                VfsUtil.saveText((VirtualFile)file2, (String)text);
            }
            virtualFile = file2;
        }
        catch (Throwable throwable) {
            try {
                token.finish();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        token.finish();
        return virtualFile;
    }

    public static void deleteFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/VfsTestUtil", "deleteFile"));
        }
        UtilKt.deleteFile(file2);
    }

    public static void clearContent(VirtualFile file2) {
        Assert.assertNotNull((Object)file2);
        try {
            VfsUtil.saveText((VirtualFile)file2, (String)"");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void overwriteTestData(String filePath, String actual) {
        try {
            FileUtil.writeToFile((File)new File(filePath), (String)actual);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

