/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tokenindex;

import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.tokenindex.Token;
import com.intellij.tokenindex.Tokenizer;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class RecursiveTokenizingVisitor
extends PsiRecursiveElementWalkingVisitor {
    private final int myBaseOffset;
    private final List<Token> myTokens;
    private final Set<String> myLanguages = new HashSet();
    private final Set<Language> myAcceptableLanguages;
    private Language myLastLanguage;
    private StructuralSearchProfile myLastProfile;

    public RecursiveTokenizingVisitor(List<Token> tokens, Set<Language> acceptableLanguages, int baseOffset) {
        super(true);
        this.myTokens = tokens;
        this.myAcceptableLanguages = acceptableLanguages;
        this.myBaseOffset = baseOffset;
    }

    public RecursiveTokenizingVisitor(List<Token> tokens, Set<Language> acceptableLanguages) {
        this(tokens, acceptableLanguages, 0);
    }

    public RecursiveTokenizingVisitor() {
        this(new ArrayList<Token>(), null);
    }

    public List<Token> getTokens() {
        return this.myTokens;
    }

    public void addToken(Token token) {
        this.myTokens.add(token);
    }

    public Set<String> getLanguages() {
        return this.myLanguages;
    }

    public void visitElement(PsiElement element) {
        Tokenizer tokenizer;
        Language language = element.getLanguage();
        if (language != this.myLastLanguage) {
            this.myLastLanguage = language;
            this.myLastProfile = StructuralSearchUtil.getProfileByPsiElement(element);
        }
        if (this.myLastProfile != null) {
            language = this.myLastProfile.getLanguage(element);
        }
        if ((this.myAcceptableLanguages == null || this.myAcceptableLanguages.contains(language)) && (tokenizer = StructuralSearchUtil.getTokenizerForLanguage(language)) != null) {
            this.myLanguages.add(language.getID());
            if (!tokenizer.visit(element, this)) {
                return;
            }
        }
        super.visitElement(element);
    }

    protected void elementFinished(PsiElement element) {
        Tokenizer tokenizer = StructuralSearchUtil.getTokenizerForLanguage(element.getLanguage());
        if (tokenizer != null) {
            tokenizer.elementFinished(element, this);
        }
    }

    public int getBaseOffset() {
        return this.myBaseOffset;
    }
}

