/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.indexing.ChangeTrackingValueContainer;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.ValueContainerImpl;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

class ValueContainerMap<Key, Value>
extends PersistentHashMap<Key, ValueContainer<Value>> {
    @NotNull
    private final DataExternalizer<Value> myValueExternalizer;
    private final boolean myKeyIsUniqueForIndexedFile;

    ValueContainerMap(@NotNull File file2, @NotNull KeyDescriptor<Key> keyKeyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, boolean keyIsUniqueForIndexedFile) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/ValueContainerMap", "<init>"));
        }
        if (keyKeyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyKeyDescriptor", "com/intellij/util/indexing/ValueContainerMap", "<init>"));
        }
        if (valueExternalizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueExternalizer", "com/intellij/util/indexing/ValueContainerMap", "<init>"));
        }
        super(file2, keyKeyDescriptor, new ValueContainerExternalizer(valueExternalizer));
        this.myValueExternalizer = valueExternalizer;
        this.myKeyIsUniqueForIndexedFile = keyIsUniqueForIndexedFile;
    }

    @NotNull
    Object getDataAccessLock() {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        if (persistentEnumeratorBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ValueContainerMap", "getDataAccessLock"));
        }
        return persistentEnumeratorBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(Key key, ValueContainer<Value> container) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            ChangeTrackingValueContainer valueContainer = (ChangeTrackingValueContainer)container;
            if (!valueContainer.needsCompacting() && !this.myKeyIsUniqueForIndexedFile) {
                final BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
                DataOutputStream _out = new DataOutputStream((OutputStream)bytes);
                valueContainer.saveTo((DataOutput)_out, this.myValueExternalizer);
                this.appendData(key, new PersistentHashMap.ValueDataAppender(){

                    public void append(@NotNull DataOutput out) throws IOException {
                        if (out == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/indexing/ValueContainerMap$1", "append"));
                        }
                        out.write(bytes.getInternalBuffer(), 0, bytes.size());
                    }
                });
            } else {
                super.doPut(key, (Object)valueContainer);
            }
        }
    }

    private static final class ValueContainerExternalizer<T>
    implements DataExternalizer<ValueContainer<T>> {
        @NotNull
        private final DataExternalizer<T> myValueExternalizer;

        private ValueContainerExternalizer(@NotNull DataExternalizer<T> valueExternalizer) {
            if (valueExternalizer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueExternalizer", "com/intellij/util/indexing/ValueContainerMap$ValueContainerExternalizer", "<init>"));
            }
            this.myValueExternalizer = valueExternalizer;
        }

        public void save(@NotNull DataOutput out, @NotNull ValueContainer<T> container) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/indexing/ValueContainerMap$ValueContainerExternalizer", "save"));
            }
            if (container == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/util/indexing/ValueContainerMap$ValueContainerExternalizer", "save"));
            }
            container.saveTo(out, this.myValueExternalizer);
        }

        @NotNull
        public ValueContainerImpl<T> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/util/indexing/ValueContainerMap$ValueContainerExternalizer", "read"));
            }
            ValueContainerImpl<T> valueContainer = new ValueContainerImpl<T>();
            valueContainer.readFrom((DataInputStream)in, this.myValueExternalizer);
            ValueContainerImpl<T> valueContainerImpl = valueContainer;
            if (valueContainerImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/ValueContainerMap$ValueContainerExternalizer", "read"));
            }
            return valueContainerImpl;
        }
    }
}

