/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.Url;
import com.intellij.util.containers.ObjectIntHashMap;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileUrlMapper {
    public static final ExtensionPointName<FileUrlMapper> EP_NAME = ExtensionPointName.create((String)"com.jetbrains.fileUrlMapper");

    @NotNull
    public List<Url> getUrls(@NotNull VirtualFile file2, @NotNull Project project, @Nullable String currentAuthority) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/FileUrlMapper", "getUrls"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/FileUrlMapper", "getUrls"));
        }
        List<Url> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/FileUrlMapper", "getUrls"));
        }
        return list;
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull Url url, @NotNull Project project, @Nullable Url requestor) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/javascript/debugger/FileUrlMapper", "getNavigatable"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/FileUrlMapper", "getNavigatable"));
        }
        VirtualFile file2 = this.getFile(url, project, requestor);
        return file2 == null ? null : new OpenFileDescriptor(project, file2);
    }

    @Nullable
    public abstract VirtualFile getFile(@NotNull Url var1, @NotNull Project var2, @Nullable Url var3);

    @Nullable
    public SourceResolver createSourceResolver(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/FileUrlMapper", "createSourceResolver"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/FileUrlMapper", "createSourceResolver"));
        }
        return null;
    }

    @Nullable
    public FileType getFileType(@NotNull Url url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/javascript/debugger/FileUrlMapper", "getFileType"));
        }
        return null;
    }

    public static abstract class SourceResolver {
        public abstract int resolve(@NotNull ObjectIntHashMap<Url> var1, @NotNull Project var2);
    }
}

