/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnit3StyleTestMethodInJUnit4ClassInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("junit3.style.test.method.in.junit4.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/JUnit3StyleTestMethodInJUnit4ClassInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("junit3.style.test.method.in.junit4.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/JUnit3StyleTestMethodInJUnit4ClassInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new DelegatingFix(new AnnotateMethodFix("org.junit.Test", new String[0]){

            @Override
            public int shouldAnnotateBaseMethod(PsiMethod method, PsiMethod superMethod, Project project) {
                return 1;
            }
        });
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new JUnit3StyleTestMethodInJUnit4ClassInspectionVisitor();
    }

    public static boolean containsJUnit4Annotation(PsiElement element) {
        JUnit4AnnotationVisitor visitor = new JUnit4AnnotationVisitor();
        element.accept((PsiElementVisitor)visitor);
        return visitor.isJUnit4AnnotationFound();
    }

    private static class JUnit4AnnotationVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myJUnit4AnnotationFound = false;

        private JUnit4AnnotationVisitor() {
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null || !qualifiedName.startsWith("org.junit.")) {
                return;
            }
            this.myJUnit4AnnotationFound = true;
        }

        public boolean isJUnit4AnnotationFound() {
            return this.myJUnit4AnnotationFound;
        }
    }

    private static class JUnit3StyleTestMethodInJUnit4ClassInspectionVisitor
    extends BaseInspectionVisitor {
        private JUnit3StyleTestMethodInJUnit4ClassInspectionVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            String name = method.getName();
            if (!name.startsWith("test")) {
                return;
            }
            if (!TestUtils.isRunnable(method)) {
                return;
            }
            if (TestUtils.isJUnit4TestMethod(method)) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (TestUtils.isJUnitTestClass(containingClass)) {
                return;
            }
            if (!JUnit3StyleTestMethodInJUnit4ClassInspection.containsJUnit4Annotation((PsiElement)containingClass)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

