/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.forloop;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReverseForLoopDirectionPredicate
implements PsiElementPredicate {
    ReverseForLoopDirectionPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken keyword = (PsiJavaToken)element;
        IElementType tokenType = keyword.getTokenType();
        if (!JavaTokenType.FOR_KEYWORD.equals(tokenType)) {
            return false;
        }
        PsiElement parent = keyword.getParent();
        if (!(parent instanceof PsiForStatement)) {
            return false;
        }
        PsiForStatement forStatement = (PsiForStatement)parent;
        PsiStatement initialization = forStatement.getInitialization();
        if (!(initialization instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)initialization;
        PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
        if (declaredElements.length != 1) {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiLocalVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)declaredElement;
        PsiType type = variable.getType();
        if (!PsiType.INT.equals((Object)type) && !PsiType.LONG.equals((Object)type)) {
            return false;
        }
        PsiExpression condition = forStatement.getCondition();
        if (!ReverseForLoopDirectionPredicate.isVariableCompared(variable, condition)) {
            return false;
        }
        PsiStatement update = forStatement.getUpdate();
        return ReverseForLoopDirectionPredicate.isVariableIncrementOrDecremented(variable, update);
    }

    public static boolean isVariableCompared(@NotNull PsiVariable variable, @Nullable PsiExpression expression) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ipp/forloop/ReverseForLoopDirectionPredicate", "isVariableCompared"));
        }
        if (!(expression instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (!ComparisonUtils.isComparisonOperation(tokenType)) {
            return false;
        }
        PsiExpression lhs = binaryExpression.getLOperand();
        PsiExpression rhs = binaryExpression.getROperand();
        if (rhs == null) {
            return false;
        }
        if (VariableAccessUtils.evaluatesToVariable(lhs, variable)) {
            return true;
        }
        return VariableAccessUtils.evaluatesToVariable(rhs, variable);
    }

    public static boolean isVariableIncrementOrDecremented(@NotNull PsiVariable variable, @Nullable PsiStatement statement) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ipp/forloop/ReverseForLoopDirectionPredicate", "isVariableIncrementOrDecremented"));
        }
        if (!(statement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
        PsiExpression expression = expressionStatement.getExpression();
        if ((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return false;
            }
            PsiExpression operand = prefixExpression.getOperand();
            return VariableAccessUtils.evaluatesToVariable(operand, variable);
        }
        if (expression instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)expression;
            IElementType tokenType = postfixExpression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return false;
            }
            PsiExpression operand = postfixExpression.getOperand();
            return VariableAccessUtils.evaluatesToVariable(operand, variable);
        }
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!VariableAccessUtils.evaluatesToVariable(lhs = ParenthesesUtils.stripParentheses(lhs), variable)) {
                return false;
            }
            PsiExpression rhs = assignmentExpression.getRExpression();
            rhs = ParenthesesUtils.stripParentheses(rhs);
            if (tokenType == JavaTokenType.EQ) {
                if (!(rhs instanceof PsiBinaryExpression)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)rhs;
                IElementType token = binaryExpression.getOperationTokenType();
                if (!token.equals(JavaTokenType.PLUS) && !token.equals(JavaTokenType.MINUS)) {
                    return false;
                }
                PsiExpression lOperand = binaryExpression.getLOperand();
                lOperand = ParenthesesUtils.stripParentheses(lOperand);
                PsiExpression rOperand = binaryExpression.getROperand();
                if (VariableAccessUtils.evaluatesToVariable(rOperand = ParenthesesUtils.stripParentheses(rOperand), variable)) {
                    return true;
                }
                if (VariableAccessUtils.evaluatesToVariable(lOperand, variable)) {
                    return true;
                }
            } else if (tokenType == JavaTokenType.PLUSEQ || tokenType == JavaTokenType.MINUSEQ) {
                return true;
            }
        }
        return false;
    }
}

