/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0005H\u0002\u001a(\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"checkAccess", "", "channel", "Lio/netty/channel/Channel;", "file", "Ljava/io/File;", "request", "Lio/netty/handler/codec/http/HttpRequest;", "root", "hasAccess", "result", "sendIoFile", "", "built-in-server"})
public final class StaticFileHandlerKt {
    private static final void sendIoFile(Channel channel, File file2, File root, HttpRequest request) {
        if (file2.isDirectory()) {
            Responses.sendStatus(HttpResponseStatus.FORBIDDEN, channel, request);
        } else if (StaticFileHandlerKt.checkAccess(channel, file2, request, root)) {
            FileResponses.sendFile(request, channel, file2);
        }
    }

    public static final boolean checkAccess(@NotNull Channel channel, @NotNull File file2, @NotNull HttpRequest request, @NotNull File root) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        File parent = file2;
        do {
            if (!StaticFileHandlerKt.hasAccess(parent)) {
                Responses.sendStatus(HttpResponseStatus.FORBIDDEN, channel, request);
                return false;
            }
            if (parent.getParentFile() != null) continue;
            break;
        } while (Intrinsics.areEqual((Object)parent, (Object)root) ^ true);
        return true;
    }

    private static final boolean hasAccess(File result2) {
        return result2.canRead() && !result2.isHidden() && !StringsKt.startsWith$default((String)result2.getName(), (String)".ht", (boolean)false, (int)2, null);
    }

    public static final /* synthetic */ void access$sendIoFile(@NotNull Channel channel, @NotNull File file2, @NotNull File root, @NotNull HttpRequest request) {
        StaticFileHandlerKt.sendIoFile(channel, file2, root, request);
    }
}

