/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorContext {
    @NotNull
    private Configuration myConfiguration;
    @NotNull
    private Module myCurrentThemeModule;
    private final List<ChangeListener> myChangeListeners;
    private final List<ConfigurationListener> myConfigurationListeners;

    public ThemeEditorContext(@NotNull Configuration configuration, @NotNull Module currentThemeModule) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ThemeEditorContext", "<init>"));
        }
        if (currentThemeModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentThemeModule", "com/android/tools/idea/editors/theme/ThemeEditorContext", "<init>"));
        }
        this.myChangeListeners = new ArrayList<ChangeListener>();
        this.myConfigurationListeners = new ArrayList<ConfigurationListener>();
        this.myConfiguration = configuration;
        this.myCurrentThemeModule = currentThemeModule;
    }

    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorContext", "getConfiguration"));
        }
        return configuration;
    }

    @NotNull
    public Module getCurrentThemeModule() {
        Module module = this.myCurrentThemeModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorContext", "getCurrentThemeModule"));
        }
        return module;
    }

    public void setCurrentThemeModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/ThemeEditorContext", "setCurrentThemeModule"));
        }
        this.myCurrentThemeModule = module;
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        VirtualFile projectFile = module.getProject().getProjectFile();
        assert (projectFile != null);
        Configuration configuration = facet.getConfigurationManager().getConfiguration(projectFile);
        this.setConfiguration(configuration);
    }

    @Nullable
    public ResourceResolver getResourceResolver() {
        return this.myConfiguration.getResourceResolver();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myCurrentThemeModule.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorContext", "getProject"));
        }
        return project;
    }

    public void addConfigurationListener(@NotNull ConfigurationListener configurationListener) {
        if (configurationListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationListener", "com/android/tools/idea/editors/theme/ThemeEditorContext", "addConfigurationListener"));
        }
        this.myConfigurationListeners.add(configurationListener);
        this.myConfiguration.addListener(configurationListener);
    }

    public void setConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ThemeEditorContext", "setConfiguration"));
        }
        for (ConfigurationListener listener : this.myConfigurationListeners) {
            this.myConfiguration.removeListener(listener);
        }
        this.myConfiguration = configuration;
        for (ConfigurationListener listener : this.myConfigurationListeners) {
            this.myConfiguration.addListener(listener);
        }
        this.fireNewConfiguration();
    }

    public void addChangeListener(ChangeListener listener) {
        this.myChangeListeners.add(listener);
    }

    private void fireNewConfiguration() {
        for (ChangeListener listener : this.myChangeListeners) {
            listener.onNewConfiguration(this);
        }
    }

    public void dispose() {
        for (ConfigurationListener listener : this.myConfigurationListeners) {
            this.myConfiguration.removeListener(listener);
        }
        this.myConfigurationListeners.clear();
    }

    public static interface ChangeListener {
        public void onNewConfiguration(ThemeEditorContext var1);
    }
}

