/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.griffon;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TIntArrayList;
import icons.JetgroovyIcons;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.griffon.GriffonCreateProjectDialog;
import org.jetbrains.plugins.groovy.griffon.GriffonLibraryPresentationProvider;
import org.jetbrains.plugins.groovy.griffon.GriffonRunConfigurationType;
import org.jetbrains.plugins.groovy.griffon.GriffonSourceInspector;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureUtil;
import org.jetbrains.plugins.groovy.mvc.MvcPathMacros;
import org.jetbrains.plugins.groovy.mvc.MvcProjectStructure;

public class GriffonFramework
extends MvcFramework {
    @NonNls
    private static final String GRIFFON_COMMON_PLUGINS = "-griffonPlugins";
    private static final String GLOBAL_PLUGINS_MODULE_NAME = "GriffonGlobalPlugins";
    public static final String GRIFFON_USER_LIBRARY = "Griffon:lib";
    private static final Pattern PLUGIN_NAME_JSON_PATTERN = Pattern.compile("\"name\"\\s*:\\s*\"([^\"]+)\"");
    private static final Pattern PLUGIN_VERSION_JSON_PATTERN = Pattern.compile("\"version\"\\s*:\\s*\"([^\"]+)\"");

    private GriffonFramework() {
    }

    @Override
    public boolean hasSupport(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/griffon/GriffonFramework", "hasSupport"));
        }
        return this.findAppRoot(module) != null && !this.isAuxModule(module) && this.getSdkRoot(module) != null;
    }

    @Override
    @NotNull
    public String getApplicationDirectoryName() {
        if ("griffon-app" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/griffon/GriffonFramework", "getApplicationDirectoryName"));
        }
        return "griffon-app";
    }

    @Override
    public boolean isToReformatOnCreation(VirtualFile file) {
        return file.getFileType() == GroovyFileType.GROOVY_FILE_TYPE;
    }

    @Override
    public void upgradeFramework(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/griffon/GriffonFramework", "upgradeFramework"));
        }
    }

    @Override
    @Nullable
    protected GeneralCommandLine getCreationCommandLine(Module module) {
        GriffonCreateProjectDialog dialog = new GriffonCreateProjectDialog(module);
        if (!dialog.showAndGet()) {
            return null;
        }
        return this.createCommandAndShowErrors(module, true, dialog.getCommand());
    }

    @Override
    public boolean updatesWholeProject() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateProjectStructure(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/griffon/GriffonFramework", "updateProjectStructure"));
        }
        if (!MvcModuleStructureUtil.isEnabledStructureUpdate()) {
            return;
        }
        VirtualFile root = this.findAppRoot(module);
        if (root == null) {
            return;
        }
        AccessToken token = WriteAction.start();
        try {
            MvcModuleStructureUtil.updateModuleStructure(module, this.createProjectStructure(module, false), root);
            if (this.hasSupport(module)) {
                MvcModuleStructureUtil.updateAuxiliaryPluginsModuleRoots(module, this);
                MvcModuleStructureUtil.updateGlobalPluginModule(module.getProject(), this);
            }
        }
        finally {
            token.finish();
        }
        Project project = module.getProject();
        ChangeListManager.getInstance((Project)project).addFilesToIgnore(new IgnoredFileBean[]{IgnoredBeanFactory.ignoreUnderDirectory((String)GriffonFramework.getUserHomeGriffon(), (Project)project)});
    }

    @Override
    public void ensureRunConfigurationExists(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/griffon/GriffonFramework", "ensureRunConfigurationExists"));
        }
        VirtualFile root = this.findAppRoot(module);
        if (root != null) {
            GriffonFramework.ensureRunConfigurationExists(module, GriffonRunConfigurationType.getInstance(), "Griffon:" + root.getName());
        }
    }

    @Override
    public String getInstalledPluginNameByPath(Project project, @NotNull VirtualFile pluginPath) {
        if (pluginPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginPath", "org/jetbrains/plugins/groovy/griffon/GriffonFramework", "getInstalledPluginNameByPath"));
        }
        String nameFromPluginXml = super.getInstalledPluginNameByPath(project, pluginPath);
        if (nameFromPluginXml != null) {
            return nameFromPluginXml;
        }
        VirtualFile pluginJson = pluginPath.findChild("plugin.json");
        if (pluginJson != null) {
            String pluginAndVersion = pluginPath.getName();
            TIntArrayList separatorIndexes = new TIntArrayList();
            int start = -1;
            while ((start = pluginAndVersion.indexOf(45, start + 1)) != -1) {
                separatorIndexes.add(start);
            }
            if (separatorIndexes.size() == 1) {
                return pluginAndVersion.substring(0, separatorIndexes.get(0));
            }
            if (!separatorIndexes.isEmpty()) {
                String json;
                try {
                    json = VfsUtil.loadText((VirtualFile)pluginJson);
                }
                catch (IOException e) {
                    return null;
                }
                for (int i = 0; i < separatorIndexes.size(); ++i) {
                    int idx = separatorIndexes.get(i);
                    String name = pluginAndVersion.substring(0, idx);
                    String version = pluginAndVersion.substring(idx + 1);
                    if (!GriffonFramework.hasValue(PLUGIN_NAME_JSON_PATTERN, json, name) || !GriffonFramework.hasValue(PLUGIN_VERSION_JSON_PATTERN, json, version)) continue;
                    return name;
                }
            }
        }
        return null;
    }

    private static boolean hasValue(Pattern pattern, String text, String value) {
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            if (!matcher.group(1).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isCoreJar(@NotNull VirtualFile localFile) {
        if (localFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFile", "org/jetbrains/plugins/groovy/griffon/GriffonFramework", "isCoreJar"));
        }
        return GriffonLibraryPresentationProvider.isGriffonCoreJar(localFile);
    }

    @Override
    public VirtualFile getSdkRoot(@Nullable Module module) {
        VirtualFile[] classRoots;
        if (module == null) {
            return null;
        }
        for (VirtualFile file : classRoots = ModuleRootManager.getInstance((Module)module).orderEntries().librariesOnly().getClassesRoots()) {
            VirtualFile parent;
            if (!GriffonLibraryPresentationProvider.isGriffonCoreJar(file)) continue;
            VirtualFile localFile = JarFileSystem.getInstance().getVirtualFileForJar(file);
            if (localFile != null && (parent = localFile.getParent()) != null) {
                return parent.getParent();
            }
            return null;
        }
        return null;
    }

    @Override
    public String getUserLibraryName() {
        return GRIFFON_USER_LIBRARY;
    }

    @Override
    public JavaParameters createJavaParameters(@NotNull Module module, boolean forCreation, boolean forTests, boolean classpathFromDependencies, @NotNull MvcCommand command) throws ExecutionException {
        String path;
        VirtualFile rootFile;
        VirtualFile dist;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/griffon/GriffonFramework", "createJavaParameters"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/groovy/griffon/GriffonFramework", "createJavaParameters"));
        }
        JavaParameters params = new JavaParameters();
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        params.setJdk(sdk);
        VirtualFile sdkRoot = this.getSdkRoot(module);
        if (sdkRoot == null) {
            return params;
        }
        params.addEnv(this.getSdkHomePropertyName(), FileUtil.toSystemDependentName((String)sdkRoot.getPath()));
        VirtualFile lib = sdkRoot.findChild("lib");
        if (lib != null) {
            for (VirtualFile child : lib.getChildren()) {
                String name = child.getName();
                if (!name.startsWith("groovy-all-") || !name.endsWith(".jar")) continue;
                params.getClassPath().add(child);
            }
        }
        if ((dist = sdkRoot.findChild("dist")) != null) {
            for (VirtualFile child : dist.getChildren()) {
                String name = child.getName();
                if (!name.endsWith(".jar") || !name.startsWith("griffon-cli-") && !name.startsWith("griffon-rt-") && !name.startsWith("griffon-resources-")) continue;
                params.getClassPath().add(child);
            }
        }
        params.setMainClass("org.codehaus.griffon.cli.support.GriffonStarter");
        if (forCreation) {
            VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (roots.length != 1) {
                throw new ExecutionException("Failed to initialize griffon module: module " + module.getName() + " contains more than one root");
            }
            command.getArgs().add(0, roots[0].getName());
            rootFile = roots[0].getParent();
        } else {
            rootFile = this.findAppRoot(module);
            if (rootFile == null) {
                throw new ExecutionException("Failed to run griffon command: module " + module.getName() + " is not a Griffon module");
            }
        }
        String workDir = VfsUtilCore.virtualToIoFile((VirtualFile)rootFile).getAbsolutePath();
        params.getVMParametersList().addParametersString(command.getVmOptions());
        if (!params.getVMParametersList().getParametersString().contains("-Xmx")) {
            params.getVMParametersList().add("-Xmx256M");
        }
        String griffonHomePath = FileUtil.toSystemDependentName((String)sdkRoot.getPath());
        params.getVMParametersList().add("-Dgriffon.home=" + griffonHomePath);
        params.getVMParametersList().add("-Dbase.dir=" + workDir);
        assert (sdk != null);
        params.getVMParametersList().add("-Dtools.jar=" + ((JavaSdkType)sdk.getSdkType()).getToolsPath(sdk));
        String confpath = griffonHomePath + "/conf/groovy-starter.conf";
        params.getVMParametersList().add("-Dgroovy.starter.conf=" + confpath);
        params.getVMParametersList().add("-Dgroovy.sanitized.stacktraces=\"groovy., org.codehaus.groovy., java., javax., sun., gjdk.groovy., gant., org.codehaus.gant.\"");
        params.getProgramParametersList().add("--main");
        params.getProgramParametersList().add("org.codehaus.griffon.cli.GriffonScriptRunner");
        params.getProgramParametersList().add("--conf");
        params.getProgramParametersList().add(confpath);
        if (!forCreation && classpathFromDependencies && StringUtil.isNotEmpty((String)(path = this.getApplicationClassPath(module).getPathsString()))) {
            params.getProgramParametersList().add("--classpath");
            params.getProgramParametersList().add(path);
        }
        params.setWorkingDirectory(workDir);
        ParametersList paramList = new ParametersList();
        command.addToParametersList(paramList);
        params.getProgramParametersList().add(paramList.getParametersString());
        params.setDefaultCharset(module.getProject());
        return params;
    }

    @Override
    @NotNull
    public String getFrameworkName() {
        if ("Griffon" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/griffon/GriffonFramework", "getFrameworkName"));
        }
        return "Griffon";
    }

    @Override
    public Icon getIcon() {
        return JetgroovyIcons.Griffon.Griffon;
    }

    @Override
    public Icon getToolWindowIcon() {
        return JetgroovyIcons.Griffon.GriffonToolWindow;
    }

    @Override
    public String getSdkHomePropertyName() {
        return "GRIFFON_HOME";
    }

    @Override
    protected String getCommonPluginSuffix() {
        return GRIFFON_COMMON_PLUGINS;
    }

    @Override
    public String getGlobalPluginsModuleName() {
        return GLOBAL_PLUGINS_MODULE_NAME;
    }

    @Override
    @Nullable
    public File getDefaultSdkWorkDir(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/griffon/GriffonFramework", "getDefaultSdkWorkDir"));
        }
        String version = GriffonLibraryPresentationProvider.getGriffonVersion(module);
        if (version == null) {
            return null;
        }
        return new File(GriffonFramework.getUserHomeGriffon(), version);
    }

    @Override
    public boolean isSDKLibrary(Library library) {
        return GriffonLibraryPresentationProvider.isGriffonSdk(library.getFiles(OrderRootType.CLASSES));
    }

    @Override
    public MvcProjectStructure createProjectStructure(@NotNull Module module, boolean auxModule) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/griffon/GriffonFramework", "createProjectStructure"));
        }
        return new GriffonProjectStructure(module, auxModule);
    }

    @Override
    public LibraryKind getLibraryKind() {
        return GriffonLibraryPresentationProvider.GRIFFON_KIND;
    }

    @Override
    public String getSomeFrameworkClass() {
        return "griffon.core.GriffonApplication";
    }

    public static String getUserHomeGriffon() {
        return MvcPathMacros.getSdkWorkDirParent("griffon");
    }

    public static GriffonFramework getInstance() {
        return (GriffonFramework)EP_NAME.findExtension(GriffonFramework.class);
    }

    public VirtualFile getApplicationPropertiesFile(Module module) {
        VirtualFile appRoot = this.findAppRoot(module);
        return appRoot != null ? appRoot.findChild("application.properties") : null;
    }

    @Override
    public String getApplicationName(Module module) {
        PsiFile file;
        VirtualFile appProperties = this.getApplicationPropertiesFile(module);
        if (appProperties != null && (file = PsiManager.getInstance((Project)module.getProject()).findFile(appProperties)) instanceof PropertiesFile) {
            IProperty property = ((PropertiesFile)file).findPropertyByKey("application.name");
            return property != null ? property.getValue() : super.getApplicationName(module);
        }
        return super.getApplicationName(module);
    }

    private static class GriffonProjectStructure
    extends MvcProjectStructure {
        public static final String[] TEST_DIRS = new String[]{"unit", "integration", "shared"};
        public static final String[] SRC_DIR_SUBFOLDER = new String[]{"main", "cli"};
        public static final String[] GRIFFON_APP_SOURCE_ROOTS = new String[]{"models", "views", "controllers", "services", "conf", "lifecycle"};

        public GriffonProjectStructure(Module module, boolean auxModule) {
            super(module, auxModule, GriffonFramework.getUserHomeGriffon(), GriffonFramework.getInstance().getSdkWorkDir(module));
        }

        @Override
        @NotNull
        public String getUserLibraryName() {
            if (GriffonFramework.GRIFFON_USER_LIBRARY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/griffon/GriffonFramework$GriffonProjectStructure", "getUserLibraryName"));
            }
            return GriffonFramework.GRIFFON_USER_LIBRARY;
        }

        /*
         * Could not resolve type clashes
         */
        @Override
        public MultiMap<JpsModuleSourceRootType<?>, String> getSourceFolders() {
            MultiMap res = new MultiMap();
            for (VirtualFile root : ModuleRootManager.getInstance((Module)this.myModule).getContentRoots()) {
                VirtualFile griffonApp;
                VirtualFile srcDir = root.findChild("src");
                if (srcDir != null) {
                    for (String child : SRC_DIR_SUBFOLDER) {
                        if (srcDir.findChild(child) == null) continue;
                        res.putValue((Object)JavaSourceRootType.SOURCE, (Object)("src/" + child));
                    }
                }
                if ((griffonApp = root.findChild("griffon-app")) != null) {
                    for (String child : GRIFFON_APP_SOURCE_ROOTS) {
                        if (griffonApp.findChild(child) == null) continue;
                        res.putValue((Object)JavaSourceRootType.SOURCE, (Object)("griffon-app/" + child));
                    }
                    for (String child : root.getChildren()) {
                        if (!child.getNameWithoutExtension().endsWith("GriffonAddon")) continue;
                        res.putValue((Object)JavaSourceRootType.SOURCE, (Object)"");
                        break;
                    }
                }
                List<GriffonSourceInspector.GriffonSource> sources = GriffonSourceInspector.processModuleMetadata(this.myModule);
                for (GriffonSourceInspector.GriffonSource source : sources) {
                    res.putValue((Object)JavaSourceRootType.SOURCE, (Object)source.getPath());
                }
                VirtualFile testDir = root.findChild("test");
                if (testDir == null) continue;
                for (String child : TEST_DIRS) {
                    if (testDir.findChild(child) == null) continue;
                    res.putValue((Object)JavaSourceRootType.TEST_SOURCE, (Object)("test/" + child));
                }
            }
            return res;
        }

        @Override
        public String[] getInvalidSourceFolders() {
            return new String[]{"src"};
        }

        @Override
        public String[] getExcludedFolders() {
            return new String[]{"target/classes", "target/test-classes"};
        }
    }
}

