/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.idea.BasicIdeaProject;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectImportAction
implements BuildAction<AllModels>,
Serializable {
    private final Set<Class> myExtraProjectModelClasses = new HashSet<Class>();
    private final boolean myIsPreviewMode;

    public ProjectImportAction(boolean isPreviewMode) {
        this.myIsPreviewMode = isPreviewMode;
    }

    public void addExtraProjectModelClasses(@NotNull Set<Class> projectModelClasses) {
        if (projectModelClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectModelClasses", "org/jetbrains/plugins/gradle/model/ProjectImportAction", "addExtraProjectModelClasses"));
        }
        this.myExtraProjectModelClasses.addAll(projectModelClasses);
    }

    @Nullable
    public AllModels execute(BuildController controller) {
        IdeaProject ideaProject;
        IdeaProject ideaProject2 = ideaProject = this.myIsPreviewMode ? (IdeaProject)controller.getModel(BasicIdeaProject.class) : (IdeaProject)controller.getModel(IdeaProject.class);
        if (ideaProject == null || ideaProject.getModules().isEmpty()) {
            return null;
        }
        AllModels allModels = new AllModels(ideaProject);
        this.addExtraProject(controller, allModels, null);
        for (IdeaModule module : ideaProject.getModules()) {
            this.addExtraProject(controller, allModels, module);
        }
        return allModels;
    }

    private void addExtraProject(@NotNull BuildController controller, @NotNull AllModels allModels, @Nullable IdeaModule model) {
        if (controller == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controller", "org/jetbrains/plugins/gradle/model/ProjectImportAction", "addExtraProject"));
        }
        if (allModels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allModels", "org/jetbrains/plugins/gradle/model/ProjectImportAction", "addExtraProject"));
        }
        for (Class aClass : this.myExtraProjectModelClasses) {
            try {
                Object extraProject = controller.findModel((Model)model, aClass);
                if (extraProject == null) continue;
                allModels.addExtraProject(extraProject, aClass, model);
            }
            catch (Exception e) {
                if (this.myIsPreviewMode) continue;
                throw new ExternalSystemException((Throwable)e);
            }
        }
    }

    public static class AllModels
    implements Serializable {
        @NotNull
        private final Map<String, Object> projectsByPath;
        @NotNull
        private final IdeaProject myIdeaProject;
        @Nullable
        private BuildEnvironment myBuildEnvironment;

        public AllModels(@NotNull IdeaProject project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels", "<init>"));
            }
            this.projectsByPath = new HashMap<String, Object>();
            this.myIdeaProject = project;
        }

        @NotNull
        public IdeaProject getIdeaProject() {
            IdeaProject ideaProject = this.myIdeaProject;
            if (ideaProject == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels", "getIdeaProject"));
            }
            return ideaProject;
        }

        @Nullable
        public BuildEnvironment getBuildEnvironment() {
            return this.myBuildEnvironment;
        }

        public void setBuildEnvironment(@Nullable BuildEnvironment buildEnvironment) {
            this.myBuildEnvironment = buildEnvironment;
        }

        @Nullable
        public <T> T getExtraProject(Class<T> modelClazz) {
            return this.getExtraProject(null, modelClazz);
        }

        @Nullable
        public <T> T getExtraProject(@Nullable IdeaModule module, Class<T> modelClazz) {
            Object extraProject = this.projectsByPath.get(this.extractMapKey(modelClazz, module));
            if (modelClazz.isInstance(extraProject)) {
                return (T)extraProject;
            }
            return null;
        }

        @NotNull
        public Collection<String> findModulesWithModel(@NotNull Class modelClazz) {
            if (modelClazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelClazz", "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels", "findModulesWithModel"));
            }
            ArrayList<String> modules = new ArrayList<String>();
            for (Map.Entry<String, Object> set : this.projectsByPath.entrySet()) {
                if (!modelClazz.isInstance(set.getValue())) continue;
                modules.add(AllModels.extractModulePath(modelClazz, set.getKey()));
            }
            ArrayList<String> arrayList = modules;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels", "findModulesWithModel"));
            }
            return arrayList;
        }

        public void addExtraProject(@NotNull Object project, @NotNull Class modelClazz) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels", "addExtraProject"));
            }
            if (modelClazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelClazz", "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels", "addExtraProject"));
            }
            this.projectsByPath.put(this.extractMapKey(modelClazz, null), project);
        }

        public void addExtraProject(@NotNull Object project, @NotNull Class modelClazz, @Nullable IdeaModule module) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels", "addExtraProject"));
            }
            if (modelClazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelClazz", "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels", "addExtraProject"));
            }
            this.projectsByPath.put(this.extractMapKey(modelClazz, module), project);
        }

        @NotNull
        private String extractMapKey(Class modelClazz, @Nullable IdeaModule module) {
            String string = modelClazz.getName() + '@' + (module != null ? module.getGradleProject().getPath() : "root" + this.myIdeaProject.getName().hashCode());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels", "extractMapKey"));
            }
            return string;
        }

        @NotNull
        private static String extractModulePath(Class modelClazz, String key) {
            String string = key.replaceFirst(modelClazz.getName() + '@', "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels", "extractModulePath"));
            }
            return string;
        }

        public String toString() {
            return "AllModels{projectsByPath=" + this.projectsByPath + ", myIdeaProject=" + this.myIdeaProject + '}';
        }
    }
}

