/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.testDiscovery;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit.testDiscovery.JUnitTestDiscoveryConfigurationType;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testDiscovery.TestDiscoveryConfiguration;
import com.intellij.execution.testDiscovery.TestDiscoverySearchHelper;
import com.intellij.execution.testframework.SearchForTestsTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.FunctionUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitTestDiscoveryConfiguration
extends TestDiscoveryConfiguration {
    public JUnitTestDiscoveryConfiguration(String name, Project project, ConfigurationFactory factory) {
        super(name, new JavaRunConfigurationModule(project, false), factory, (JavaTestConfigurationBase)new JUnitConfiguration("", project, JUnitConfigurationType.getInstance().getConfigurationFactories()[0]));
    }

    protected ModuleBasedConfiguration createInstance() {
        JUnitTestDiscoveryConfigurationType configurationType = (JUnitTestDiscoveryConfigurationType)ConfigurationTypeUtil.findConfigurationType(JUnitTestDiscoveryConfigurationType.class);
        ConfigurationFactory[] factories = configurationType.getConfigurationFactories();
        return new JUnitTestDiscoveryConfiguration(this.getName(), this.getProject(), factories[0]);
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/junit/testDiscovery/JUnitTestDiscoveryConfiguration", "getState"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/junit/testDiscovery/JUnitTestDiscoveryConfiguration", "getState"));
        }
        return new JUnitTestDiscoveryRunnableState(environment);
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        return null;
    }

    @NotNull
    public String getFrameworkPrefix() {
        if ("j" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/testDiscovery/JUnitTestDiscoveryConfiguration", "getFrameworkPrefix"));
        }
        return "j";
    }

    private class JUnitTestDiscoveryRunnableState
    extends TestObject {
        public JUnitTestDiscoveryRunnableState(ExecutionEnvironment environment) {
            super((JUnitConfiguration)JUnitTestDiscoveryConfiguration.this.myDelegate, environment);
        }

        public SearchForTestsTask createSearchingForTestsTask() {
            return new SearchForTestsTask(JUnitTestDiscoveryConfiguration.this.getProject(), this.myServerSocket){

                protected void search() throws ExecutionException {
                    Set patterns = TestDiscoverySearchHelper.search((Project)this.getProject(), (Pair)JUnitTestDiscoveryConfiguration.this.getPosition(), (String)JUnitTestDiscoveryConfiguration.this.getChangeList(), (String)JUnitTestDiscoveryConfiguration.this.getFrameworkPrefix());
                    JUnitTestDiscoveryRunnableState.this.addClassesListToJavaParameters(patterns, FunctionUtil.id(), "", false, JUnitTestDiscoveryRunnableState.this.getJavaParameters());
                }

                protected void onFound() {
                }
            };
        }

        @Override
        protected JavaParameters createJavaParameters() throws ExecutionException {
            JavaParameters javaParameters = super.createJavaParameters();
            this.createTempFiles(javaParameters);
            this.createServerSocket(javaParameters);
            return javaParameters;
        }

        @Override
        public String suggestActionName() {
            return "";
        }

        @Override
        public RefactoringElementListener getListener(PsiElement element, JUnitConfiguration configuration) {
            return null;
        }

        @Override
        public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiClass testClass, PsiMethod testMethod, PsiPackage testPackage, PsiDirectory testDir) {
            return false;
        }
    }
}

