/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MacOtherAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.DialogEarthquakeShaker;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.DialogWrapperPeerFactory;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.UIBundle;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.AwtVisitor;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.ui.DialogWrapper");
    public static final int OK_EXIT_CODE = 0;
    public static final int CANCEL_EXIT_CODE = 1;
    public static final int CLOSE_EXIT_CODE = 1;
    public static final int NEXT_USER_EXIT_CODE = 2;
    @NonNls
    public static final String DEFAULT_ACTION = "DefaultAction";
    @NonNls
    public static final String FOCUSED_ACTION = "FocusedAction";
    @NonNls
    private static final String NO_AUTORESIZE = "NoAutoResizeAndFit";
    private static final KeyStroke SHOW_OPTION_KEYSTROKE = KeyStroke.getKeyStroke(10, 9);
    @NotNull
    private final DialogWrapperPeer myPeer;
    private int myExitCode;
    public static final Border ourDefaultBorder = new EmptyBorder(UIUtil.PANEL_REGULAR_INSETS);
    private float myHorizontalStretch;
    private float myVerticalStretch;
    private int myButtonAlignment;
    private boolean myCrossClosesWindow;
    private Insets myButtonMargins;
    protected Action myOKAction;
    protected Action myCancelAction;
    protected Action myHelpAction;
    private JButton[] myButtons;
    private boolean myClosed;
    protected boolean myPerformAction;
    private Action myYesAction;
    private Action myNoAction;
    protected JCheckBox myCheckBoxDoNotShowDialog;
    @Nullable
    private DoNotAskOption myDoNotAsk;
    protected JComponent myPreferredFocusedComponent;
    private Computable<Point> myInitialLocationCallback;
    protected final Disposable myDisposable;
    private final List<JBOptionButton> myOptionsButtons;
    private int myCurrentOptionsButtonIndex;
    private boolean myResizeInProgress;
    private ComponentAdapter myResizeListener;
    private ErrorText myErrorText;
    private final Alarm myErrorTextAlarm;
    private final Alarm myValidationAlarm;
    private int myValidationDelay;
    private boolean myDisposed;
    private boolean myValidationStarted;
    private final ErrorPainter myErrorPainter;
    private JComponent myErrorPane;
    private boolean myErrorPainterInstalled;
    private Dimension myActualSize;
    private String myLastErrorText;

    @NotNull
    protected String getDoNotShowMessage() {
        String string = CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "getDoNotShowMessage"));
        }
        return string;
    }

    public void setDoNotAskOption(@Nullable DoNotAskOption doNotAsk) {
        this.myDoNotAsk = doNotAsk;
    }

    protected DialogWrapper(@Nullable Project project, boolean canBeParent) {
        this(project, canBeParent, IdeModalityType.IDE);
    }

    protected DialogWrapper(@Nullable Project project, boolean canBeParent, @NotNull IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModalityType", "com/intellij/openapi/ui/DialogWrapper", "<init>"));
        }
        this.myExitCode = 1;
        this.myHorizontalStretch = 1.0f;
        this.myVerticalStretch = 1.0f;
        this.myButtonAlignment = 4;
        this.myCrossClosesWindow = true;
        this.myButtonMargins = JBUI.insets((int)2, (int)16);
        this.myClosed = false;
        this.myPerformAction = false;
        this.myYesAction = null;
        this.myNoAction = null;
        this.myDisposable = new Disposable(){

            public String toString() {
                return DialogWrapper.this.toString();
            }

            public void dispose() {
                DialogWrapper.this.dispose();
            }
        };
        this.myOptionsButtons = new ArrayList<JBOptionButton>();
        this.myCurrentOptionsButtonIndex = -1;
        this.myResizeInProgress = false;
        this.myErrorTextAlarm = new Alarm();
        this.myValidationAlarm = new Alarm(this.getValidationThreadToUse(), this.myDisposable);
        this.myValidationDelay = 300;
        this.myDisposed = false;
        this.myValidationStarted = false;
        this.myErrorPainter = new ErrorPainter();
        this.myErrorPainterInstalled = false;
        this.myActualSize = null;
        this.myLastErrorText = null;
        this.myPeer = this.createPeer(project, canBeParent, ideModalityType);
        Window window = this.myPeer.getWindow();
        if (window != null) {
            this.myResizeListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (!DialogWrapper.this.myResizeInProgress) {
                        DialogWrapper.this.myActualSize = DialogWrapper.this.myPeer.getSize();
                        if (DialogWrapper.this.myErrorText != null && DialogWrapper.this.myErrorText.isVisible()) {
                            ((DialogWrapper)DialogWrapper.this).myActualSize.height -= DialogWrapper.this.myErrorText.myLabel.getHeight();
                        }
                    }
                }
            };
            window.addComponentListener(this.myResizeListener);
        }
        this.createDefaultActions();
    }

    protected DialogWrapper(@Nullable Project project) {
        this(project, true);
    }

    protected DialogWrapper(boolean canBeParent) {
        this((Project)null, canBeParent);
    }

    @Deprecated
    protected DialogWrapper(boolean canBeParent, boolean applicationModalIfPossible) {
        this(null, canBeParent, applicationModalIfPossible);
    }

    protected DialogWrapper(Project project, boolean canBeParent, boolean applicationModalIfPossible) {
        this.myExitCode = 1;
        this.myHorizontalStretch = 1.0f;
        this.myVerticalStretch = 1.0f;
        this.myButtonAlignment = 4;
        this.myCrossClosesWindow = true;
        this.myButtonMargins = JBUI.insets((int)2, (int)16);
        this.myClosed = false;
        this.myPerformAction = false;
        this.myYesAction = null;
        this.myNoAction = null;
        this.myDisposable = new /* invalid duplicate definition of identical inner class */;
        this.myOptionsButtons = new ArrayList<JBOptionButton>();
        this.myCurrentOptionsButtonIndex = -1;
        this.myResizeInProgress = false;
        this.myErrorTextAlarm = new Alarm();
        this.myValidationAlarm = new Alarm(this.getValidationThreadToUse(), this.myDisposable);
        this.myValidationDelay = 300;
        this.myDisposed = false;
        this.myValidationStarted = false;
        this.myErrorPainter = new ErrorPainter();
        this.myErrorPainterInstalled = false;
        this.myActualSize = null;
        this.myLastErrorText = null;
        DialogWrapper.ensureEventDispatchThread();
        this.myPeer = ApplicationManager.getApplication() != null ? this.createPeer(project != null ? WindowManager.getInstance().suggestParentWindow(project) : WindowManager.getInstance().findVisibleFrame(), canBeParent, applicationModalIfPossible) : this.createPeer(null, canBeParent, applicationModalIfPossible);
        this.createDefaultActions();
    }

    protected DialogWrapper(@NotNull Component parent, boolean canBeParent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/DialogWrapper", "<init>"));
        }
        this.myExitCode = 1;
        this.myHorizontalStretch = 1.0f;
        this.myVerticalStretch = 1.0f;
        this.myButtonAlignment = 4;
        this.myCrossClosesWindow = true;
        this.myButtonMargins = JBUI.insets((int)2, (int)16);
        this.myClosed = false;
        this.myPerformAction = false;
        this.myYesAction = null;
        this.myNoAction = null;
        this.myDisposable = new /* invalid duplicate definition of identical inner class */;
        this.myOptionsButtons = new ArrayList<JBOptionButton>();
        this.myCurrentOptionsButtonIndex = -1;
        this.myResizeInProgress = false;
        this.myErrorTextAlarm = new Alarm();
        this.myValidationAlarm = new Alarm(this.getValidationThreadToUse(), this.myDisposable);
        this.myValidationDelay = 300;
        this.myDisposed = false;
        this.myValidationStarted = false;
        this.myErrorPainter = new ErrorPainter();
        this.myErrorPainterInstalled = false;
        this.myActualSize = null;
        this.myLastErrorText = null;
        DialogWrapper.ensureEventDispatchThread();
        this.myPeer = this.createPeer(parent, canBeParent);
        this.createDefaultActions();
    }

    @NotNull
    protected Alarm.ThreadToUse getValidationThreadToUse() {
        Alarm.ThreadToUse threadToUse = Alarm.ThreadToUse.SWING_THREAD;
        if (threadToUse == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "getValidationThreadToUse"));
        }
        return threadToUse;
    }

    protected boolean postponeValidation() {
        return true;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return null;
    }

    public void setValidationDelay(int delay) {
        this.myValidationDelay = delay;
    }

    private void reportProblem(final @NotNull ValidationInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/ui/DialogWrapper", "reportProblem"));
        }
        this.installErrorPainter();
        this.myErrorPainter.setValidationInfo(info);
        if (!this.myErrorText.isTextSet(info.message)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (DialogWrapper.this.myDisposed) {
                        return;
                    }
                    DialogWrapper.this.setErrorText(info.message);
                    DialogWrapper.this.myPeer.getRootPane().getGlassPane().repaint();
                    DialogWrapper.this.getOKAction().setEnabled(false);
                }
            });
        }
    }

    private void installErrorPainter() {
        if (this.myErrorPainterInstalled) {
            return;
        }
        this.myErrorPainterInstalled = true;
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                IdeGlassPaneUtil.installPainter(DialogWrapper.this.myErrorPane, DialogWrapper.this.myErrorPainter, DialogWrapper.this.myDisposable);
            }
        });
    }

    private void clearProblems() {
        this.myErrorPainter.setValidationInfo(null);
        if (!this.myErrorText.isTextSet(null)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (DialogWrapper.this.myDisposed) {
                        return;
                    }
                    DialogWrapper.this.setErrorText(null);
                    DialogWrapper.this.myPeer.getRootPane().getGlassPane().repaint();
                    DialogWrapper.this.getOKAction().setEnabled(true);
                }
            });
        }
    }

    protected void createDefaultActions() {
        this.myOKAction = new OkAction();
        this.myCancelAction = new CancelAction();
        this.myHelpAction = new HelpAction();
    }

    public void setUndecorated(boolean undecorated) {
        this.myPeer.setUndecorated(undecorated);
    }

    public final void addMouseListener(@NotNull MouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/ui/DialogWrapper", "addMouseListener"));
        }
        this.myPeer.addMouseListener(listener);
    }

    public final void addMouseListener(@NotNull MouseMotionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/ui/DialogWrapper", "addMouseListener"));
        }
        this.myPeer.addMouseListener(listener);
    }

    public final void addKeyListener(@NotNull KeyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/ui/DialogWrapper", "addKeyListener"));
        }
        this.myPeer.addKeyListener(listener);
    }

    public final void close(int exitCode, boolean isOk) {
        DialogWrapper.ensureEventDispatchThread();
        if (this.myClosed) {
            return;
        }
        this.myClosed = true;
        this.myExitCode = exitCode;
        Window window = this.getWindow();
        if (window != null && this.myResizeListener != null) {
            window.removeComponentListener(this.myResizeListener);
            this.myResizeListener = null;
        }
        if (isOk) {
            this.processDoNotAskOnOk(exitCode);
        } else {
            this.processDoNotAskOnCancel();
        }
        Disposer.dispose((Disposable)this.myDisposable);
    }

    public final void close(int exitCode) {
        this.close(exitCode, exitCode != 1);
    }

    @Nullable
    protected Border createContentPaneBorder() {
        if (this.getStyle() == DialogStyle.COMPACT) {
            return JBUI.Borders.empty();
        }
        return ourDefaultBorder;
    }

    @Nullable
    protected JComponent createSouthPanel() {
        Insets insets;
        Object[] actions = this.filter(this.createActions());
        Object[] leftSideActions = this.createLeftSideActions();
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        boolean hasHelpToMoveToLeftSide = false;
        if (UIUtil.isUnderAquaBasedLookAndFeel() && Arrays.asList(actions).contains(this.getHelpAction())) {
            hasHelpToMoveToLeftSide = true;
            actions = (Action[])ArrayUtil.remove((Object[])actions, (Object)this.getHelpAction());
        } else if (Registry.is((String)"ide.remove.help.button.from.dialogs")) {
            actions = (Action[])ArrayUtil.remove((Object[])actions, (Object)this.getHelpAction());
        }
        if (SystemInfo.isMac) {
            for (Object action : actions) {
                if (!(action instanceof MacOtherAction)) continue;
                leftSideActions = (Action[])ArrayUtil.append((Object[])leftSideActions, (Object)action);
                actions = (Action[])ArrayUtil.remove((Object[])actions, (Object)action);
                break;
            }
        } else if (UIUtil.isUnderGTKLookAndFeel() && Arrays.asList(actions).contains(this.getHelpAction())) {
            leftSideActions = (Action[])ArrayUtil.append((Object[])leftSideActions, (Object)this.getHelpAction());
            actions = (Action[])ArrayUtil.remove((Object[])actions, (Object)this.getHelpAction());
        }
        JPanel panel = new JPanel(new BorderLayout());
        JPanel lrButtonsPanel = new JPanel(new GridBagLayout());
        Insets insets2 = SystemInfo.isMacOSLeopard ? (UIUtil.isUnderIntelliJLaF() ? JBUI.insets((int)0, (int)8) : JBUI.emptyInsets()) : (insets = new Insets(8, 0, 0, 0));
        if (actions.length > 0 || leftSideActions.length > 0) {
            JPanel buttonsPanel;
            int gridX = 0;
            if (leftSideActions.length > 0) {
                buttonsPanel = this.createButtons((Action[])leftSideActions, buttons);
                if (actions.length > 0) {
                    buttonsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
                }
                lrButtonsPanel.add((Component)buttonsPanel, new GridBagConstraints(gridX++, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
            }
            lrButtonsPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(gridX++, 0, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
            if (actions.length > 0) {
                if (SystemInfo.isMac) {
                    int cancelNdx;
                    int okNdx = ArrayUtil.indexOf((Object[])actions, (Object)this.getOKAction());
                    if (okNdx >= 0 && okNdx != actions.length - 1) {
                        actions = (Action[])ArrayUtil.append((Object[])ArrayUtil.remove((Object[])actions, (Object)this.getOKAction()), (Object)this.getOKAction());
                    }
                    if ((cancelNdx = ArrayUtil.indexOf((Object[])actions, (Object)this.getCancelAction())) > 0) {
                        actions = (Action[])ArrayUtil.mergeArrays((Object[])new Action[]{this.getCancelAction()}, (Object[])ArrayUtil.remove((Object[])actions, (Object)this.getCancelAction()));
                    }
                }
                buttonsPanel = this.createButtons((Action[])actions, buttons);
                lrButtonsPanel.add((Component)buttonsPanel, new GridBagConstraints(gridX++, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
            }
            if (0 == this.myButtonAlignment) {
                lrButtonsPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(gridX, 0, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
            }
            this.myButtons = buttons.toArray(new JButton[buttons.size()]);
        }
        if (hasHelpToMoveToLeftSide) {
            JButton helpButton = new JButton(this.getHelpAction());
            helpButton.putClientProperty("JButton.buttonType", "help");
            helpButton.setText("");
            helpButton.setMargin(insets);
            helpButton.setToolTipText(ActionsBundle.actionDescription("HelpTopics"));
            panel.add((Component)helpButton, "West");
        }
        panel.add((Component)lrButtonsPanel, "Center");
        DoNotAskOption askOption = this.myDoNotAsk;
        if (askOption != null) {
            this.myCheckBoxDoNotShowDialog = new JCheckBox(askOption.getDoNotShowMessage());
            JPanel southPanel = panel;
            if (!askOption.canBeHidden()) {
                return southPanel;
            }
            JPanel withCB = DialogWrapper.addDoNotShowCheckBox(southPanel, this.myCheckBoxDoNotShowDialog);
            this.myCheckBoxDoNotShowDialog.setSelected(!askOption.isToBeShown());
            DialogUtil.registerMnemonic(this.myCheckBoxDoNotShowDialog, '&');
            panel = withCB;
        }
        if (this.getStyle() == DialogStyle.COMPACT) {
            CustomLineBorder line = new CustomLineBorder(OnePixelDivider.BACKGROUND, 1, 0, 0, 0);
            panel.setBorder(new CompoundBorder((Border)line, (Border)JBUI.Borders.empty((int)8, (int)12)));
        } else {
            panel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        }
        return panel;
    }

    @NotNull
    protected DialogStyle getStyle() {
        DialogStyle dialogStyle = DialogStyle.NO_STYLE;
        if (dialogStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "getStyle"));
        }
        return dialogStyle;
    }

    @NotNull
    private Action[] filter(@NotNull Action[] actions) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/openapi/ui/DialogWrapper", "filter"));
        }
        ArrayList<Action> answer = new ArrayList<Action>();
        for (Action action : actions) {
            if (action == null || !ApplicationInfo.contextHelpAvailable() && action == this.getHelpAction()) continue;
            answer.add(action);
        }
        Action[] actionArray = answer.toArray(new Action[answer.size()]);
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "filter"));
        }
        return actionArray;
    }

    protected boolean toBeShown() {
        return !this.myCheckBoxDoNotShowDialog.isSelected();
    }

    public boolean isTypeAheadEnabled() {
        return false;
    }

    @NotNull
    public static JPanel addDoNotShowCheckBox(@NotNull JComponent southPanel, @NotNull JCheckBox checkBox) {
        if (southPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "southPanel", "com/intellij/openapi/ui/DialogWrapper", "addDoNotShowCheckBox"));
        }
        if (checkBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkBox", "com/intellij/openapi/ui/DialogWrapper", "addDoNotShowCheckBox"));
        }
        JPanel panel = new JPanel(new BorderLayout());
        JPanel wrapper = new JPanel(new GridBagLayout());
        wrapper.add(checkBox);
        panel.add((Component)wrapper, "West");
        panel.add((Component)southPanel, "East");
        checkBox.setBorder((Border)JBUI.Borders.emptyRight((int)20));
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "addDoNotShowCheckBox"));
        }
        return jPanel;
    }

    private boolean hasFocusedAction(@NotNull Action[] actions) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/openapi/ui/DialogWrapper", "hasFocusedAction"));
        }
        for (Action action : actions) {
            if (action.getValue(FOCUSED_ACTION) == null || !((Boolean)action.getValue(FOCUSED_ACTION)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private JPanel createButtons(@NotNull Action[] actions, @NotNull List<JButton> buttons) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/openapi/ui/DialogWrapper", "createButtons"));
        }
        if (buttons == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buttons", "com/intellij/openapi/ui/DialogWrapper", "createButtons"));
        }
        if (!UISettings.getShadowInstance().ALLOW_MERGE_BUTTONS) {
            ArrayList<Action> actionList = new ArrayList<Action>();
            for (Action action : actions) {
                actionList.add(action);
                if (!(action instanceof OptionAction)) continue;
                Action[] options = ((OptionAction)action).getOptions();
                actionList.addAll(Arrays.asList(options));
            }
            if (actionList.size() != actions.length) {
                actions = actionList.toArray(actionList.toArray(new Action[actionList.size()]));
            }
        }
        JPanel buttonsPanel = new JPanel(new GridLayout(1, actions.length, SystemInfo.isMacOSLeopard ? (UIUtil.isUnderIntelliJLaF() ? 8 : 0) : 5, 0));
        for (Action action : actions) {
            JButton button = this.createJButtonForAction(action);
            Object value = action.getValue("MnemonicKey");
            if (value instanceof Integer) {
                int mnemonic = (Integer)value;
                Object name = action.getValue("Name");
                if (mnemonic == 89 && "Yes".equals(name)) {
                    this.myYesAction = action;
                } else if (mnemonic == 78 && "No".equals(name)) {
                    this.myNoAction = action;
                }
                button.setMnemonic(mnemonic);
            }
            if (action.getValue(FOCUSED_ACTION) != null) {
                this.myPreferredFocusedComponent = button;
            }
            buttons.add(button);
            buttonsPanel.add(button);
        }
        JPanel jPanel = buttonsPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "createButtons"));
        }
        return jPanel;
    }

    protected JButton createJButtonForAction(Action action) {
        JButton button;
        if (action instanceof OptionAction && UISettings.getShadowInstance().ALLOW_MERGE_BUTTONS) {
            Action[] options = ((OptionAction)action).getOptions();
            button = new JBOptionButton(action, options);
            JBOptionButton eachOptionsButton = (JBOptionButton)button;
            eachOptionsButton.setOkToProcessDefaultMnemonics(false);
            eachOptionsButton.setOptionTooltipText("Press " + KeymapUtil.getKeystrokeText(SHOW_OPTION_KEYSTROKE) + " to expand or use a mnemonic of a contained action");
            this.myOptionsButtons.add(eachOptionsButton);
            Set<JBOptionButton.OptionInfo> infos = eachOptionsButton.getOptionInfos();
            for (final JBOptionButton.OptionInfo eachInfo : infos) {
                if (eachInfo.getMnemonic() < 0) continue;
                char mnemonic = (char)eachInfo.getMnemonic();
                JRootPane rootPane = this.getPeer().getRootPane();
                if (rootPane == null) continue;
                new AnAction(){

                    @Override
                    public void actionPerformed(AnActionEvent e) {
                        JBOptionButton buttonToActivate = eachInfo.getButton();
                        buttonToActivate.showPopup(eachInfo.getAction(), true);
                    }
                }.registerCustomShortcutSet(MnemonicHelper.createShortcut(mnemonic), rootPane, this.myDisposable);
            }
        } else {
            button = new JButton(action);
        }
        String text = button.getText();
        if (SystemInfo.isMac) {
            button.putClientProperty("JButton.buttonType", "text");
        }
        if (text != null) {
            int mnemonic = 0;
            StringBuilder plainText = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                int ch = text.charAt(i);
                if (ch == 95 || ch == 38) {
                    if (++i >= text.length()) break;
                    ch = text.charAt(i);
                    if (ch != 95 && ch != 38) {
                        int vk = ch;
                        if (vk >= 97 && vk <= 122) {
                            vk -= 32;
                        }
                        mnemonic = vk;
                    }
                }
                plainText.append((char)ch);
            }
            button.setText(plainText.toString());
            Object name = action.getValue("Name");
            if (mnemonic == 89 && "Yes".equals(name)) {
                this.myYesAction = action;
            } else if (mnemonic == 78 && "No".equals(name)) {
                this.myNoAction = action;
            }
            button.setMnemonic(mnemonic);
        }
        this.setMargin(button);
        if (action.getValue(DEFAULT_ACTION) != null && !this.myPeer.isHeadless()) {
            this.getRootPane().setDefaultButton(button);
        }
        return button;
    }

    private void setMargin(@NotNull JButton button) {
        if (button == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/openapi/ui/DialogWrapper", "setMargin"));
        }
        if (!SystemInfo.isMac) {
            if (this.myButtonMargins == null) {
                return;
            }
            button.setMargin(this.myButtonMargins);
        }
    }

    @NotNull
    protected DialogWrapperPeer createPeer(@NotNull Component parent, boolean canBeParent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/DialogWrapper", "createPeer"));
        }
        DialogWrapperPeer dialogWrapperPeer = DialogWrapperPeerFactory.getInstance().createPeer(this, parent, canBeParent);
        if (dialogWrapperPeer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "createPeer"));
        }
        return dialogWrapperPeer;
    }

    @Deprecated
    @NotNull
    protected DialogWrapperPeer createPeer(boolean canBeParent, boolean applicationModalIfPossible) {
        DialogWrapperPeer dialogWrapperPeer = this.createPeer(null, canBeParent, applicationModalIfPossible);
        if (dialogWrapperPeer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "createPeer"));
        }
        return dialogWrapperPeer;
    }

    @NotNull
    protected DialogWrapperPeer createPeer(Window owner, boolean canBeParent, IdeModalityType ideModalityType) {
        DialogWrapperPeer dialogWrapperPeer = DialogWrapperPeerFactory.getInstance().createPeer(this, owner, canBeParent, ideModalityType);
        if (dialogWrapperPeer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "createPeer"));
        }
        return dialogWrapperPeer;
    }

    @Deprecated
    @NotNull
    protected DialogWrapperPeer createPeer(Window owner, boolean canBeParent, boolean applicationModalIfPossible) {
        DialogWrapperPeer dialogWrapperPeer = DialogWrapperPeerFactory.getInstance().createPeer(this, owner, canBeParent, applicationModalIfPossible ? IdeModalityType.IDE : IdeModalityType.PROJECT);
        if (dialogWrapperPeer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "createPeer"));
        }
        return dialogWrapperPeer;
    }

    @NotNull
    protected DialogWrapperPeer createPeer(@Nullable Project project, boolean canBeParent, @NotNull IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModalityType", "com/intellij/openapi/ui/DialogWrapper", "createPeer"));
        }
        DialogWrapperPeer dialogWrapperPeer = DialogWrapperPeerFactory.getInstance().createPeer(this, project, canBeParent, ideModalityType);
        if (dialogWrapperPeer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "createPeer"));
        }
        return dialogWrapperPeer;
    }

    @NotNull
    protected DialogWrapperPeer createPeer(@Nullable Project project, boolean canBeParent) {
        DialogWrapperPeer dialogWrapperPeer = DialogWrapperPeerFactory.getInstance().createPeer(this, project, canBeParent);
        if (dialogWrapperPeer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "createPeer"));
        }
        return dialogWrapperPeer;
    }

    @Nullable
    protected JComponent createTitlePane() {
        return null;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        return null;
    }

    @Nullable
    protected abstract JComponent createCenterPanel();

    public void toFront() {
        this.myPeer.toFront();
    }

    public void toBack() {
        this.myPeer.toBack();
    }

    protected boolean setAutoAdjustable(boolean autoAdjustable) {
        JRootPane rootPane = this.getRootPane();
        if (rootPane == null) {
            return false;
        }
        rootPane.putClientProperty(NO_AUTORESIZE, autoAdjustable ? null : Boolean.TRUE);
        return true;
    }

    public boolean isAutoAdjustable() {
        JRootPane rootPane = this.getRootPane();
        return rootPane == null || rootPane.getClientProperty(NO_AUTORESIZE) == null;
    }

    protected void dispose() {
        JRootPane rootPane;
        DialogWrapper.ensureEventDispatchThread();
        this.myErrorTextAlarm.cancelAllRequests();
        this.myValidationAlarm.cancelAllRequests();
        this.myDisposed = true;
        if (this.myButtons != null) {
            for (JButton button : this.myButtons) {
                button.setAction(null);
            }
        }
        if ((rootPane = this.getRootPane()) != null) {
            DialogWrapper.unregisterKeyboardActions(rootPane);
            if (this.myActualSize != null && this.isAutoAdjustable()) {
                this.setSize(this.myActualSize.width, this.myActualSize.height);
            }
            this.myPeer.dispose();
        }
    }

    public static void unregisterKeyboardActions(JRootPane rootPane) {
        new AwtVisitor(rootPane){

            public boolean visit(Component component) {
                if (component instanceof JComponent) {
                    KeyStroke[] strokes;
                    JComponent eachComp = (JComponent)component;
                    ActionMap actionMap = eachComp.getActionMap();
                    for (KeyStroke eachStroke : strokes = eachComp.getRegisteredKeyStrokes()) {
                        boolean remove = true;
                        if (actionMap != null) {
                            for (int i : new int[]{0, 1, 2}) {
                                Action action;
                                InputMap inputMap = eachComp.getInputMap(i);
                                Object key = inputMap.get(eachStroke);
                                if (key == null || !((action = actionMap.get(key)) instanceof UIResource)) continue;
                                remove = false;
                            }
                        }
                        if (!remove) continue;
                        eachComp.unregisterKeyboardAction(eachStroke);
                    }
                }
                return false;
            }
        };
    }

    public void doCancelAction() {
        this.processDoNotAskOnCancel();
        if (this.getCancelAction().isEnabled()) {
            this.close(1);
        }
    }

    private void processDoNotAskOnCancel() {
        if (this.myDoNotAsk != null && this.myDoNotAsk.shouldSaveOptionsOnCancel() && this.myDoNotAsk.canBeHidden()) {
            this.myDoNotAsk.setToBeShown(this.toBeShown(), 1);
        }
    }

    public void doCancelAction(AWTEvent source) {
        this.doCancelAction();
    }

    public void clickDefaultButton() {
        JButton button = this.getRootPane().getDefaultButton();
        if (button != null) {
            button.doClick();
        }
    }

    protected void doOKAction() {
        this.processDoNotAskOnOk(0);
        if (this.getOKAction().isEnabled()) {
            this.close(0);
        }
    }

    protected void processDoNotAskOnOk(int exitCode) {
        if (this.myDoNotAsk != null && this.myDoNotAsk.canBeHidden()) {
            this.myDoNotAsk.setToBeShown(this.toBeShown(), exitCode);
        }
    }

    public boolean shouldCloseOnCross() {
        return this.myCrossClosesWindow;
    }

    @NotNull
    protected Action[] createActions() {
        if (this.getHelpId() == null) {
            if (SystemInfo.isMac) {
                Action[] actionArray = new Action[]{this.getCancelAction(), this.getOKAction()};
                if (actionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "createActions"));
                }
                return actionArray;
            }
            Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "createActions"));
            }
            return actionArray;
        }
        if (SystemInfo.isMac) {
            Action[] actionArray = new Action[]{this.getHelpAction(), this.getCancelAction(), this.getOKAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "createActions"));
        }
        return actionArray;
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        Action[] actionArray = new Action[]{};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "createLeftSideActions"));
        }
        return actionArray;
    }

    @NotNull
    protected Action getOKAction() {
        Action action = this.myOKAction;
        if (action == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "getOKAction"));
        }
        return action;
    }

    @NotNull
    protected Action getCancelAction() {
        Action action = this.myCancelAction;
        if (action == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "getCancelAction"));
        }
        return action;
    }

    @NotNull
    protected Action getHelpAction() {
        Action action = this.myHelpAction;
        if (action == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "getHelpAction"));
        }
        return action;
    }

    protected boolean isProgressDialog() {
        return false;
    }

    public final boolean isModalProgress() {
        return this.isProgressDialog();
    }

    public Container getContentPane() {
        return this.myPeer.getContentPane();
    }

    public void validate() {
        this.myPeer.validate();
    }

    public void repaint() {
        this.myPeer.repaint();
    }

    @Nullable
    @NonNls
    protected String getDimensionServiceKey() {
        return null;
    }

    @Nullable
    public final String getDimensionKey() {
        return this.getDimensionServiceKey();
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return SystemInfo.isMac ? this.myPreferredFocusedComponent : null;
    }

    public final float getHorizontalStretch() {
        return this.myHorizontalStretch;
    }

    public final float getVerticalStretch() {
        return this.myVerticalStretch;
    }

    protected final void setHorizontalStretch(float hStretch) {
        this.myHorizontalStretch = hStretch;
    }

    protected final void setVerticalStretch(float vStretch) {
        this.myVerticalStretch = vStretch;
    }

    public Window getOwner() {
        return this.myPeer.getOwner();
    }

    public Window getWindow() {
        return this.myPeer.getWindow();
    }

    public JComponent getContentPanel() {
        return (JComponent)this.myPeer.getContentPane();
    }

    public JRootPane getRootPane() {
        return this.myPeer.getRootPane();
    }

    public Dimension getSize() {
        return this.myPeer.getSize();
    }

    public String getTitle() {
        return this.myPeer.getTitle();
    }

    protected void init() {
        JComponent c;
        DialogWrapper.ensureEventDispatchThread();
        this.myErrorText = new ErrorText();
        this.myErrorText.setVisible(false);
        final ComponentAdapter resizeListener = new ComponentAdapter(){
            private int myHeight;

            @Override
            public void componentResized(ComponentEvent event) {
                int height;
                int n = height = !DialogWrapper.this.myErrorText.isVisible() ? 0 : event.getComponent().getHeight();
                if (height != this.myHeight) {
                    this.myHeight = height;
                    DialogWrapper.this.myResizeInProgress = true;
                    DialogWrapper.this.myErrorText.setMinimumSize(new Dimension(0, height));
                    JRootPane root = DialogWrapper.this.myPeer.getRootPane();
                    if (root != null) {
                        root.validate();
                    }
                    if (DialogWrapper.this.myActualSize != null) {
                        DialogWrapper.this.myPeer.setSize(((DialogWrapper)DialogWrapper.this).myActualSize.width, ((DialogWrapper)DialogWrapper.this).myActualSize.height + height);
                    }
                    DialogWrapper.this.myErrorText.revalidate();
                    DialogWrapper.this.myResizeInProgress = false;
                }
            }
        };
        this.myErrorText.myLabel.addComponentListener(resizeListener);
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                DialogWrapper.this.myErrorText.myLabel.removeComponentListener(resizeListener);
            }
        });
        JPanel root = new JPanel(this.createRootLayout());
        this.myPeer.setContentPane(root);
        CustomShortcutSet sc = new CustomShortcutSet(SHOW_OPTION_KEYSTROKE);
        AnAction toggleShowOptions = new AnAction(){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/ui/DialogWrapper$10", "actionPerformed"));
                }
                DialogWrapper.this.expandNextOptionButton();
            }
        };
        toggleShowOptions.registerCustomShortcutSet(sc, root, this.myDisposable);
        JComponent titlePane = this.createTitlePane();
        if (titlePane != null) {
            JPanel northSection = new JPanel(new BorderLayout());
            root.add((Component)northSection, "North");
            northSection.add((Component)titlePane, "Center");
        }
        JPanel centerSection = new JPanel(new BorderLayout());
        root.add((Component)centerSection, "Center");
        root.setBorder(this.createContentPaneBorder());
        JComponent n = this.createNorthPanel();
        if (n != null) {
            centerSection.add((Component)n, "North");
        }
        if ((c = this.createCenterPanel()) != null) {
            centerSection.add((Component)c, "Center");
            this.myErrorPane = c;
        }
        if (this.myErrorPane == null) {
            this.myErrorPane = root;
        }
        JPanel southSection = new JPanel(new BorderLayout());
        root.add((Component)southSection, "South");
        southSection.add((Component)this.myErrorText, "Center");
        JComponent south = this.createSouthPanel();
        if (south != null) {
            southSection.add((Component)south, "South");
        }
        MnemonicHelper.init(root);
        if (!this.postponeValidation()) {
            this.startTrackingValidation();
        }
        if (SystemInfo.isWindows) {
            DialogWrapper.installEnterHook(root, this.myDisposable);
        }
        this.myErrorTextAlarm.setActivationComponent(root);
    }

    @NotNull
    LayoutManager createRootLayout() {
        BorderLayout borderLayout = new BorderLayout();
        if (borderLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "createRootLayout"));
        }
        return borderLayout;
    }

    private static void installEnterHook(JComponent root, Disposable disposable) {
        new AnAction(){

            @Override
            public void actionPerformed(AnActionEvent e) {
                Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (owner instanceof JButton && owner.isEnabled()) {
                    ((JButton)owner).doClick();
                }
            }

            @Override
            public void update(AnActionEvent e) {
                Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                e.getPresentation().setEnabled(owner instanceof JButton && owner.isEnabled());
            }
        }.registerCustomShortcutSet(CustomShortcutSet.fromString("ENTER"), root, disposable);
    }

    private void expandNextOptionButton() {
        if (this.myCurrentOptionsButtonIndex > 0) {
            this.myOptionsButtons.get(this.myCurrentOptionsButtonIndex).closePopup();
            ++this.myCurrentOptionsButtonIndex;
        } else if (!this.myOptionsButtons.isEmpty()) {
            this.myCurrentOptionsButtonIndex = 0;
        }
        if (this.myCurrentOptionsButtonIndex >= 0 && this.myCurrentOptionsButtonIndex < this.myOptionsButtons.size()) {
            this.myOptionsButtons.get(this.myCurrentOptionsButtonIndex).showPopup(null, true);
        }
    }

    void startTrackingValidation() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!DialogWrapper.this.myValidationStarted && !DialogWrapper.this.myDisposed) {
                    DialogWrapper.this.myValidationStarted = true;
                    DialogWrapper.this.initValidation();
                }
            }
        });
    }

    protected final void initValidation() {
        this.myValidationAlarm.cancelAllRequests();
        Runnable validateRequest = new Runnable(){

            @Override
            public void run() {
                if (DialogWrapper.this.myDisposed) {
                    return;
                }
                ValidationInfo result = DialogWrapper.this.doValidate();
                if (result == null) {
                    DialogWrapper.this.clearProblems();
                } else {
                    DialogWrapper.this.reportProblem(result);
                }
                if (!DialogWrapper.this.myDisposed) {
                    DialogWrapper.this.initValidation();
                }
            }
        };
        if (this.getValidationThreadToUse() == Alarm.ThreadToUse.SWING_THREAD) {
            JRootPane rootPane = this.getRootPane();
            this.myValidationAlarm.addRequest(validateRequest, this.myValidationDelay, rootPane == null ? ModalityState.current() : ModalityState.stateForComponent(rootPane));
        } else {
            this.myValidationAlarm.addRequest(validateRequest, this.myValidationDelay);
        }
    }

    protected boolean isNorthStrictedToPreferredSize() {
        return true;
    }

    protected boolean isCenterStrictedToPreferredSize() {
        return false;
    }

    protected boolean isSouthStrictedToPreferredSize() {
        return true;
    }

    @NotNull
    protected JComponent createContentPane() {
        JPanel jPanel = new JPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "createContentPane"));
        }
        return jPanel;
    }

    public void pack() {
        this.myPeer.pack();
    }

    public Dimension getPreferredSize() {
        return this.myPeer.getPreferredSize();
    }

    protected final void setButtonsAlignment(int alignment) {
        if (0 != alignment && 4 != alignment) {
            throw new IllegalArgumentException("unknown alignment: " + alignment);
        }
        this.myButtonAlignment = alignment;
    }

    public final void setButtonsMargin(@Nullable Insets insets) {
        this.myButtonMargins = insets;
    }

    public final void setCrossClosesWindow(boolean crossClosesWindow) {
        this.myCrossClosesWindow = crossClosesWindow;
    }

    protected final void setCancelButtonIcon(Icon icon) {
        if (!SystemInfo.isMac) {
            this.myCancelAction.putValue("SmallIcon", icon);
        }
    }

    protected final void setCancelButtonText(String text) {
        this.myCancelAction.putValue("Name", text);
    }

    public void setModal(boolean modal) {
        this.myPeer.setModal(modal);
    }

    public boolean isModal() {
        return this.myPeer.isModal();
    }

    protected void setOKActionEnabled(boolean isEnabled) {
        this.myOKAction.setEnabled(isEnabled);
    }

    protected final void setOKButtonIcon(Icon icon) {
        if (!SystemInfo.isMac) {
            this.myOKAction.putValue("SmallIcon", icon);
        }
    }

    protected final void setOKButtonText(String text) {
        this.myOKAction.putValue("Name", text);
    }

    protected final void setOKButtonMnemonic(int c) {
        this.myOKAction.putValue("MnemonicKey", c);
    }

    @Nullable
    protected String getHelpId() {
        return null;
    }

    protected void doHelpAction() {
        if (this.myHelpAction.isEnabled()) {
            String helpId = this.getHelpId();
            if (helpId != null) {
                HelpManager.getInstance().invokeHelp(helpId);
            } else {
                Messages.showMessageDialog(this.getContentPane(), UIBundle.message((String)"there.is.no.help.for.this.dialog.error.message", (Object[])new Object[0]), UIBundle.message((String)"no.help.available.dialog.title", (Object[])new Object[0]), Messages.getInformationIcon());
            }
        }
    }

    public boolean isOK() {
        return this.getExitCode() == 0;
    }

    public boolean isOKActionEnabled() {
        return this.myOKAction.isEnabled();
    }

    public boolean isVisible() {
        return this.myPeer.isVisible();
    }

    public boolean isShowing() {
        return this.myPeer.isShowing();
    }

    public void setSize(int width, int height) {
        this.myPeer.setSize(width, height);
    }

    public void setTitle(@Nls(capitalization=Nls.Capitalization.Title) String title) {
        this.myPeer.setTitle(title);
    }

    public void isResizable() {
        this.myPeer.isResizable();
    }

    public void setResizable(boolean resizable) {
        this.myPeer.setResizable(resizable);
    }

    @NotNull
    public Point getLocation() {
        Point point = this.myPeer.getLocation();
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "getLocation"));
        }
        return point;
    }

    public void setLocation(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/openapi/ui/DialogWrapper", "setLocation"));
        }
        this.myPeer.setLocation(p);
    }

    public void setLocation(int x, int y) {
        this.myPeer.setLocation(x, y);
    }

    public void centerRelativeToParent() {
        this.myPeer.centerInParent();
    }

    public void show() {
        this.invokeShow();
    }

    public boolean showAndGet() {
        if (!this.isModal()) {
            throw new IllegalStateException("The showAndGet() method is for modal dialogs only");
        }
        this.show();
        return this.isOK();
    }

    @NotNull
    public AsyncResult<Boolean> showAndGetOk() {
        if (this.isModal()) {
            throw new IllegalStateException("The showAndGetOk() method is for modeless dialogs only");
        }
        AsyncResult<Boolean> asyncResult = this.invokeShow();
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "showAndGetOk"));
        }
        return asyncResult;
    }

    @NotNull
    private AsyncResult<Boolean> invokeShow() {
        final AsyncResult<Boolean> result = new AsyncResult<Boolean>();
        DialogWrapper.ensureEventDispatchThread();
        this.registerKeyboardShortcuts();
        Disposable uiParent = Disposer.get((String)"ui");
        if (uiParent != null) {
            Disposer.register((Disposable)uiParent, (Disposable)this.myDisposable);
        }
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                result.setDone(DialogWrapper.this.isOK());
            }
        });
        this.myPeer.show();
        AsyncResult<Boolean> asyncResult = result;
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "invokeShow"));
        }
        return asyncResult;
    }

    @Nullable
    public Point getInitialLocation() {
        return this.myInitialLocationCallback == null ? null : (Point)this.myInitialLocationCallback.compute();
    }

    public void setInitialLocationCallback(@NotNull Computable<Point> callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/ui/DialogWrapper", "setInitialLocationCallback"));
        }
        this.myInitialLocationCallback = callback;
    }

    private void registerKeyboardShortcuts() {
        JRootPane rootPane = this.getRootPane();
        if (rootPane == null) {
            return;
        }
        ActionListener cancelKeyboardAction = this.createCancelAction();
        if (cancelKeyboardAction != null) {
            rootPane.registerKeyboardAction(cancelKeyboardAction, KeyStroke.getKeyStroke(27, 0), 2);
            this.registerForEveryKeyboardShortcut(cancelKeyboardAction, CommonShortcuts.getCloseActiveWindow());
        }
        if (ApplicationInfo.contextHelpAvailable()) {
            ActionListener helpAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogWrapper.this.doHelpAction();
                }
            };
            this.registerForEveryKeyboardShortcut(helpAction, CommonShortcuts.getContextHelp());
            rootPane.registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(156, 0), 2);
        }
        if (this.myButtons != null) {
            rootPane.registerKeyboardAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogWrapper.this.focusPreviousButton();
                }
            }, KeyStroke.getKeyStroke(37, 0), 1);
            rootPane.registerKeyboardAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogWrapper.this.focusNextButton();
                }
            }, KeyStroke.getKeyStroke(39, 0), 1);
        }
        if (this.myYesAction != null) {
            rootPane.registerKeyboardAction(this.myYesAction, KeyStroke.getKeyStroke(89, 0), 2);
        }
        if (this.myNoAction != null) {
            rootPane.registerKeyboardAction(this.myNoAction, KeyStroke.getKeyStroke(78, 0), 2);
        }
    }

    @Nullable
    protected ActionListener createCancelAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                MenuElement[] selectedPath = menuSelectionManager.getSelectedPath();
                if (selectedPath.length > 0) {
                    menuSelectionManager.clearSelectedPath();
                } else {
                    if (ApplicationManager.getApplication() == null) {
                        DialogWrapper.this.doCancelAction(e);
                        return;
                    }
                    StackingPopupDispatcher popupDispatcher = StackingPopupDispatcher.getInstance();
                    if (popupDispatcher != null && !popupDispatcher.isPopupFocused()) {
                        DialogWrapper.this.doCancelAction(e);
                    }
                }
            }
        };
    }

    private void registerForEveryKeyboardShortcut(ActionListener action, @NotNull ShortcutSet shortcuts) {
        if (shortcuts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcuts", "com/intellij/openapi/ui/DialogWrapper", "registerForEveryKeyboardShortcut"));
        }
        for (Shortcut shortcut : shortcuts.getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            KeyboardShortcut ks = (KeyboardShortcut)shortcut;
            KeyStroke first = ks.getFirstKeyStroke();
            KeyStroke second = ks.getSecondKeyStroke();
            if (second != null) continue;
            this.getRootPane().registerKeyboardAction(action, first, 2);
        }
    }

    private void focusPreviousButton() {
        for (int i = 0; i < this.myButtons.length; ++i) {
            if (!this.myButtons[i].hasFocus()) continue;
            if (i == 0) {
                this.myButtons[this.myButtons.length - 1].requestFocus();
                return;
            }
            this.myButtons[i - 1].requestFocus();
            return;
        }
    }

    private void focusNextButton() {
        for (int i = 0; i < this.myButtons.length; ++i) {
            if (!this.myButtons[i].hasFocus()) continue;
            if (i == this.myButtons.length - 1) {
                this.myButtons[0].requestFocus();
                return;
            }
            this.myButtons[i + 1].requestFocus();
            return;
        }
    }

    public long getTypeAheadTimeoutMs() {
        return 0L;
    }

    public boolean isToDispatchTypeAhead() {
        return this.isOK();
    }

    public static boolean isMultipleModalDialogs() {
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (c != null) {
            DialogWrapper wrapper = DialogWrapper.findInstance(c);
            return wrapper != null && wrapper.getPeer().getCurrentModalEntities().length > 1;
        }
        return false;
    }

    protected void setErrorText(@Nullable String text) {
        if (Comparing.equal((String)this.myLastErrorText, (String)text)) {
            return;
        }
        this.myLastErrorText = text;
        this.myErrorTextAlarm.cancelAllRequests();
        this.myErrorTextAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                String text = DialogWrapper.this.myLastErrorText;
                if (DialogWrapper.this.myActualSize == null && !DialogWrapper.this.myErrorText.isVisible()) {
                    DialogWrapper.this.myActualSize = DialogWrapper.this.getSize();
                }
                DialogWrapper.this.myErrorText.setError(text);
            }
        }, 300, (ModalityState)null);
    }

    @Nullable
    public static DialogWrapper findInstance(Component c) {
        while (c != null) {
            if (c instanceof DialogWrapperDialog) {
                return ((DialogWrapperDialog)((Object)c)).getDialogWrapper();
            }
            c = c.getParent();
        }
        return null;
    }

    @Nullable
    public static DialogWrapper findInstanceFromFocus() {
        return DialogWrapper.findInstance(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
    }

    private void resizeWithAnimation(final @NotNull Dimension size) {
        if (size == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "size", "com/intellij/openapi/ui/DialogWrapper", "resizeWithAnimation"));
        }
        this.myResizeInProgress = true;
        if (!Registry.is((String)"enable.animation.on.dialogs")) {
            this.setSize(size.width, size.height);
            this.myResizeInProgress = false;
            return;
        }
        new Thread("DialogWrapper resizer"){
            int time;
            int steps;
            {
                super(x0);
                this.time = 200;
                this.steps = 7;
            }

            @Override
            public void run() {
                int step = 0;
                Dimension cur = DialogWrapper.this.getSize();
                int h = (size.height - cur.height) / this.steps;
                int w = (size.width - cur.width) / this.steps;
                while (step++ < this.steps) {
                    DialogWrapper.this.setSize(cur.width + w * step, cur.height + h * step);
                    TimeoutUtil.sleep((long)(this.time / this.steps));
                }
                DialogWrapper.this.setSize(size.width, size.height);
                if (DialogWrapper.this.myErrorText.shouldBeVisible()) {
                    DialogWrapper.this.myErrorText.setVisible(true);
                }
                DialogWrapper.this.myResizeInProgress = false;
            }
        }.start();
    }

    @NotNull
    public final DialogWrapperPeer getPeer() {
        DialogWrapperPeer dialogWrapperPeer = this.myPeer;
        if (dialogWrapperPeer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "getPeer"));
        }
        return dialogWrapperPeer;
    }

    private static void ensureEventDispatchThread() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("The DialogWrapper can only be used in event dispatch thread. Current thread: " + Thread.currentThread());
        }
    }

    @NotNull
    public final Disposable getDisposable() {
        Disposable disposable = this.myDisposable;
        if (disposable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "getDisposable"));
        }
        return disposable;
    }

    @NotNull
    private ErrorPaintingType getErrorPaintingType() {
        ErrorPaintingType errorPaintingType = ErrorPaintingType.SIGN;
        if (errorPaintingType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper", "getErrorPaintingType"));
        }
        return errorPaintingType;
    }

    public static enum DialogStyle {
        NO_STYLE,
        COMPACT;

    }

    private static enum ErrorPaintingType {
        DOT,
        SIGN,
        LINE;

    }

    private class ErrorPainter
    extends AbstractPainter {
        private ValidationInfo myInfo;

        private ErrorPainter() {
        }

        @Override
        public void executePaint(Component component, Graphics2D g) {
            if (this.myInfo != null && this.myInfo.component != null) {
                JComponent comp = this.myInfo.component;
                int w = comp.getWidth();
                int h = comp.getHeight();
                switch (DialogWrapper.this.getErrorPaintingType()) {
                    case DOT: {
                        Point p = SwingUtilities.convertPoint(comp, 2, h / 2, component);
                        AllIcons.Ide.ErrorPoint.paintIcon(component, g, p.x, p.y);
                        break;
                    }
                    case SIGN: {
                        Point p = SwingUtilities.convertPoint(comp, w, 0, component);
                        AllIcons.General.Error.paintIcon(component, g, p.x - 8, p.y - 8);
                        break;
                    }
                    case LINE: {
                        Point p = SwingUtilities.convertPoint(comp, 0, h, component);
                        GraphicsConfig config = new GraphicsConfig((Graphics)g);
                        g.setColor(new Color(255, 0, 0, 100));
                        g.fillRoundRect(p.x, p.y - 2, w, 4, 2, 2);
                        config.restore();
                    }
                }
            }
        }

        @Override
        public boolean needsRepaint() {
            return true;
        }

        private void setValidationInfo(@Nullable ValidationInfo info) {
            this.myInfo = info;
        }
    }

    public static class PropertyDoNotAskOption
    implements DoNotAskOption {
        @NotNull
        private final String myProperty;

        public PropertyDoNotAskOption(@NotNull String property) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/openapi/ui/DialogWrapper$PropertyDoNotAskOption", "<init>"));
            }
            this.myProperty = property;
        }

        @Override
        public boolean isToBeShown() {
            return PropertiesComponent.getInstance().getBoolean(this.myProperty);
        }

        @Override
        public void setToBeShown(boolean value, int exitCode) {
            PropertiesComponent.getInstance().setValue(this.myProperty, value);
        }

        @Override
        public boolean canBeHidden() {
            return false;
        }

        @Override
        public boolean shouldSaveOptionsOnCancel() {
            return false;
        }

        @Override
        @NotNull
        public String getDoNotShowMessage() {
            String string = CommonBundle.message((String)"dialog.options.do.not.ask", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper$PropertyDoNotAskOption", "getDoNotShowMessage"));
            }
            return string;
        }
    }

    public static interface DoNotAskOption {
        public boolean isToBeShown();

        public void setToBeShown(boolean var1, int var2);

        public boolean canBeHidden();

        public boolean shouldSaveOptionsOnCancel();

        @NotNull
        public String getDoNotShowMessage();
    }

    private static class ErrorText
    extends JPanel {
        private final JLabel myLabel = new JLabel();
        private String myText;

        private ErrorText() {
            this.setLayout(new BorderLayout());
            this.myLabel.setIcon(AllIcons.Actions.Lightning);
            this.myLabel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10, (int)0, (int)2));
            JBScrollPane pane = new JBScrollPane(this.myLabel, 21, 31);
            pane.setBorder((Border)JBUI.Borders.empty());
            pane.setBackground(null);
            pane.getViewport().setBackground(null);
            pane.setOpaque(false);
            this.add((Component)pane, "Center");
        }

        public void setError(String text) {
            this.myText = text;
            this.myLabel.setBounds(0, 0, 0, 0);
            this.setVisible(text != null);
            this.myLabel.setText(text != null ? "<html><font color='#" + ColorUtil.toHex((Color)JBColor.RED) + "'><left>" + text + "</left></b></font></html>" : "");
        }

        public boolean shouldBeVisible() {
            return !StringUtil.isEmpty((String)this.myText);
        }

        public boolean isTextSet(@Nullable String text) {
            return StringUtil.equals((CharSequence)text, (CharSequence)this.myText);
        }
    }

    private class HelpAction
    extends AbstractAction {
        private HelpAction() {
            this.putValue("Name", CommonBundle.getHelpButtonText());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogWrapper.this.doHelpAction();
        }
    }

    protected class DialogWrapperExitAction
    extends DialogWrapperAction {
        protected final int myExitCode;

        public DialogWrapperExitAction(String name, int exitCode) {
            super(name);
            this.myExitCode = exitCode;
        }

        @Override
        protected void doAction(ActionEvent e) {
            if (this.isEnabled()) {
                DialogWrapper.this.close(this.myExitCode);
            }
        }
    }

    protected class CancelAction
    extends DialogWrapperAction {
        private CancelAction() {
            super(CommonBundle.getCancelButtonText());
        }

        @Override
        protected void doAction(ActionEvent e) {
            DialogWrapper.this.doCancelAction();
        }
    }

    protected class OkAction
    extends DialogWrapperAction {
        protected OkAction() {
            super(CommonBundle.getOkButtonText());
            this.putValue(DialogWrapper.DEFAULT_ACTION, Boolean.TRUE);
        }

        @Override
        protected void doAction(ActionEvent e) {
            ValidationInfo info = DialogWrapper.this.doValidate();
            if (info != null) {
                if (info.component != null && info.component.isVisible()) {
                    IdeFocusManager.getInstance(null).requestFocus(info.component, true);
                }
                DialogEarthquakeShaker.shake((JDialog)DialogWrapper.this.getPeer().getWindow());
                DialogWrapper.this.startTrackingValidation();
                return;
            }
            DialogWrapper.this.doOKAction();
        }
    }

    protected abstract class DialogWrapperAction
    extends AbstractAction {
        protected DialogWrapperAction(String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/ui/DialogWrapper$DialogWrapperAction", "<init>"));
            }
            this.putValue("Name", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DialogWrapper.this.myClosed) {
                return;
            }
            if (DialogWrapper.this.myPerformAction) {
                return;
            }
            try {
                DialogWrapper.this.myPerformAction = true;
                this.doAction(e);
            }
            finally {
                DialogWrapper.this.myPerformAction = false;
            }
        }

        protected abstract void doAction(ActionEvent var1);
    }

    public static enum IdeModalityType {
        IDE,
        PROJECT,
        MODELESS;


        @NotNull
        public Dialog.ModalityType toAwtModality() {
            switch (this) {
                case IDE: {
                    Dialog.ModalityType modalityType = Dialog.ModalityType.APPLICATION_MODAL;
                    if (modalityType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper$IdeModalityType", "toAwtModality"));
                    }
                    return modalityType;
                }
                case PROJECT: {
                    Dialog.ModalityType modalityType = Dialog.ModalityType.DOCUMENT_MODAL;
                    if (modalityType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper$IdeModalityType", "toAwtModality"));
                    }
                    return modalityType;
                }
                case MODELESS: {
                    Dialog.ModalityType modalityType = Dialog.ModalityType.MODELESS;
                    if (modalityType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper$IdeModalityType", "toAwtModality"));
                    }
                    return modalityType;
                }
            }
            throw new IllegalStateException(this.toString());
        }
    }
}

