/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class TemplateDataHighlighterWrapper
implements SyntaxHighlighter {
    private final SyntaxHighlighter myHighlighter;

    public TemplateDataHighlighterWrapper(SyntaxHighlighter highlighter) {
        this.myHighlighter = highlighter;
    }

    @Override
    @NotNull
    public Lexer getHighlightingLexer() {
        Lexer lexer = this.myHighlighter.getHighlightingLexer();
        if (lexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateDataHighlighterWrapper", "getHighlightingLexer"));
        }
        return lexer;
    }

    @Override
    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        if (tokenType == TokenType.BAD_CHARACTER) {
            TextAttributesKey[] textAttributesKeyArray = new TextAttributesKey[]{};
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateDataHighlighterWrapper", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = this.myHighlighter.getTokenHighlights(tokenType);
        if (textAttributesKeyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateDataHighlighterWrapper", "getTokenHighlights"));
        }
        return textAttributesKeyArray;
    }
}

