/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import kotlin.CollectionsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.jps.incremental.storage.StoragePackage$sam$ValueDataAppender$5847c6dd;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"H\b)YA*\u0019>z'R|'/Y4f\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'b\u00016qg*Y\u0011N\\2sK6,g\u000e^1m\u0015\u001d\u0019Ho\u001c:bO\u0016T\u0011a\u0013\u0006\u0004\u0003:L(\"\u0001,\u000b\rqJg.\u001b;?\u0015-\u0019Ho\u001c:bO\u00164\u0015\u000e\\3\u000b\t\u0019KG.\u001a\u0006\u0005U\u00064\u0018M\u0003\u0002j_*i1.Z=EKN\u001c'/\u001b9u_JTQbS3z\t\u0016\u001c8M]5qi>\u0014(bA2p[*A\u0011N\u001c;fY2L'N\u0003\u0003vi&d'\"\u0005<bYV,W\t\u001f;fe:\fG.\u001b>fe*\u0001B)\u0019;b\u000bb$XM\u001d8bY&TXM\u001d\u0006\u0005W\u0016L8O\u0003\u0006D_2dWm\u0019;j_:TqaZ3u\u0017\u0016L8OC\tQKJ\u001c\u0018n\u001d;f]RD\u0015m\u001d5NCBTa!\u00199qK:$'bA6fs*Ia)\u001e8di&|g.\r\u0006\u000b\t\u0006$\u0018mT;uaV$(\u0002B+oSRTA\u0001\\1oO*1qJ\u00196fGRT1A\u001b<n\u0015%1WO\\2uS>t7OC\u0003dY\u0016\fgNC\u0003dY>\u001cXM\u0003\u0005d_:$\u0018-\u001b8t\u0015\u001d\u0011un\u001c7fC:T\u0011b\u0019:fCR,W*\u00199\u000b\u000b\u0019dWo\u001d5\u000b!5,Wn\u001c:z\u0007\u0006\u001c\u0007.Z:P]2L(bA4fi*\u0011r-\u001a;Ti>\u0014\u0018mZ3JM\u0016C\u0018n\u001d;t\u0015U9W\r^*u_J\fw-Z(s\u0007J,\u0017\r^3OK^TaA]3n_Z,'bA:fi*)a/\u00197vK\u0002\u0010!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!\u0002\u0002\u0005\u0005!\u0019Qa\u0001C\u0003\u0011\u0001a\u0001!B\u0001\t\u0004\u0015\u0019Aq\u0001\u0005\u0005\u0019\u0001)\u0011\u0001#\u0004\u0006\u0005\u0011%\u0001bB\u0003\u0004\t\u0015Aa\u0001\u0004\u0001\u0006\u0003!EQA\u0001\u0003\u0007\u0011%)!\u0001\"\u0004\t\u0014\u0015\u0011Aa\u0002\u0005\b\u000b\r!y\u0001\u0003\u0005\r\u0001\u0015\u0019Aq\u0002E\u000b\u0019\u0001)!\u0001B\u0003\t\r\u0015\u0011Aq\u0002\u0005\t\u000b\t!y\u0001#\u0006\u0006\u0007\u0011\u001d\u0001r\u0003\u0007\u0001\u000b\t!I\u0001c\u0005\u0006\u0005\u0011Y\u0001rC\u0003\u0004\t\u001fAI\u0002\u0004\u0001\u0006\u0005\u0011=\u0001\u0012D\u0003\u0004\t\u000fAa\u0002\u0004\u0001\u0006\u0007\u0011)\u0001R\u0004\u0007\u0001\u000b\r!9\u0001C\b\r\u0001\u0015\u0011A\u0011\u0002E\u0010\u000b\t!i\u0002\u0003\t\u0006\u0005\u0011\u001d\u0001\u0012E\u0003\u0003\t?A\u0011#\u0002\u0002\u0005!!qQa\u0001C\u0004\u0011Ma\u0001\u0001\u0002\u0001\r\u0007U9A\u0001\u0001E\u0004+\u0011)\u0011\u0001\u0003\u0003\r\u0002a!Qc\u0002C\u0001\u0011\u0013)B!B\u0001\t\t1\u0005\u0001\u0004B\r\u0004\u000b\u0005AA\u0001\u0007\u0003.%\u0011\tG\u0001g\u0004\"\u0013\u0015\t\u0001\u0002C\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0001\u0004C+\u0004\t\u0015\u0019AqB\u0005\u0002\u0011'i3\u0003B2\u00051-\t\u0013\"B\u0001\t\u0016%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u0019\u0016\u0011\u001aSk\u0001\u0003\u000e\u0007\u0011a\u0011\"\u0001E\f[m!\u0019\u0019\u0004\r\u0004CA)\u0011\u0001\u0003\u0007\n\u000b%!QA\u0001C\u0001\u0011\u0001a\u0002!C\u0003\n\t\u0015\u0011A\u0011\u0001E\u00019\u0003a\t\u0001\u0007\u0007%\u0003!\nQk\u0001\u0003\u0006\u0007\u0011\u0019\u0011\"\u0001E\r[1!\u0011\r\u0002M\u0006C\r)\u0011\u0001c\u0003\u0019\fU\u001bA!B\u0002\u0005\f%\t\u0001\"C\u0017\u0013\t\u0005$\u0001DC\u0011\n\u000b\u0005A\t\"C\u0003\n\t\u0015\u0011A\u0011\u0001E\u00019\u0003A\n\"V\u0002\u0005\u000b\r!!\"C\u0001\t\u00155VCa\u0001\r\u000e;#!\u0001\u0001c\u0007\u000e\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001\u00016\u0001AO\u0012\t\u0001AQ\"D\u0007\u0006\u0003!i\u0011\u0002B\u0005\u0004\u000b\u0005AY\u0002g\u0007\n\t%\u0019Q!\u0001\u0005\u000f19AR\u0002UB\u0001C\r)\u0011\u0001\u0003\b\u0019\u001dE\u001bq\u0001B\u0007\n\u0003\u0011\u0001Q\"\u0001\u0005\u0010\u001b\u0005A\t#,\u0006\u0005\ba\r\u0012eA\u0003\u0002\u00119Ab\"U\u0002\u0004\tGI\u0011\u0001\u0002\u0001.\u0016\u0011\u001d\u0001DE\u0011\u0004\u000b\u0005Aa\u0002\u0007\bR\u0007\r!!#C\u0001\u0005\u000152Ba\u0001M\u0013;#!\u0001\u0001c\u0007\u000e\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001\u00016\u0001A\u0011\u0004\u000b\u0005A\u0011\u0003G\tR\u0007\u0015!)#C\u0001\u0005\u00025\t\u0001bDW\u0017\t\u0005A:#I\b\u0006\u0003!a\u0011\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001%)\u0011\u0002B\u0003\u0003\t\u0003A\t\u0001(\u0001\u0019\u0019E\u001b1\u0001b\n\n\u0003!eQ&\u0006C\u00041Qiz\u0001\u0002\u0001\t*5\u0019Q!\u0001\u0005\u00121E\u00016\u0001A\u0011\u0004\u000b\u0005Aa\u0002\u0007\bR\u0007\u0015!A#C\u0001\u0005\u00015\tA\u0011A\u0017\u0019\t\rAR#(\u0005\u0005\u0001!mQ\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001Q\u0007\u0001\tS!\u0002\u0002\u0005\u0002!\u0005A\u0012\u0001O\u0001#\u000e)A!F\u0005\u0002\u0011=i\u0011\u0001C\b.0\u0011\r\u00014F\u0011\u0011\u000b\u0005AA\"C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001IQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0012\u0001O\u0001\u0019\u0003AB\"U\u0002\u0004\tWI\u0011\u0001#\u0007..\u0011\r\u0001DF\u0011\u0010\u000b\u0005AA\"C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001IQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0012\u0001O\u000111\t6a\u0001\u0003\u0017\u0013\u0005AI\"\f\f\u0005\u0007a5R\u0014\u0003\u0003\u0001\u00117iA!\u0002\u0002\u0005\u0002!\u0001A\u0004\u0001)\u0004\u0001\u0005\u001aQ!\u0001\u0005\u000f19\t6!\u0002C\u0017\u0013\u0005!\u0001!D\u0001\t\u001f5\u000eCa\u0001\r\u0018;#!\u0001\u0001c\u0007\u000e\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001\u00016\u0001AO\t\t\u0001Ay#\u0004\u0003\u0006\u0005\u0011\u0005\u0001\u0012\u0001O\u0001!\u000e\u0005\u0011eA\u0003\u0002\u00119Ab\"U\u0002\b\t]I\u0011\u0001\u0002\u0001\u000e\u0003!yQ\"\u0001\u0005\u0010kQ\u0007QQ5\u0001\u0005G\u0004\tr\u0001\u0002\u0001\t\bU!Q!\u0001\u0005\u0005\u0019\u0003AB!E\u0004\u0005\u0002!%Q\u0003B\u0003\u0002\u0011\u0011a\t\u0001\u0007\u0003\u0019\u000bu=A\u0001\u0001E\u0006\u001b\r)\u0011\u0001c\u0003\u0019\fA\u001b\u0001!h\u0007\u0005\u0001!=Q\"C\u0003\u0002\u0011!IQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u00011!\u00016\u0011AO\u000e\t\u0001A!\"D\u0005\u0006\u0003!E\u0011\"B\u0005\u0005\u000b\t!\t\u0001#\u0001\u001d\u0002aE\u0001kA\u0001\"\u001f\u0015\t\u0001bA\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0011\"B\u0005\u0005\u000b\t!\t\u0001#\u0001\u001d\u0002a\u0019\u0011kA\u0005\u0005\u000b%\tA\u0001A\u0007\u0002\u0011%i\u0011\u0001c\u0005\u000e\u0003!Q\u0001"})
public final class LazyStorage<K, V> {
    public static final /* synthetic */ KClass $kotlinClass;
    private volatile PersistentHashMap<K, V> storage;
    private final File storageFile;
    private final KeyDescriptor<K> keyDescriptor;
    private final DataExternalizer<V> valueExternalizer;

    static {
        $kotlinClass = Reflection.createKotlinClass(LazyStorage.class);
    }

    private final synchronized PersistentHashMap<K, V> getStorageIfExists() {
        if (this.storage != null) {
            return this.storage;
        }
        if (this.storageFile.exists()) {
            this.storage = this.createMap();
            return this.storage;
        }
        return null;
    }

    private final synchronized PersistentHashMap<K, V> getStorageOrCreateNew() {
        if (this.storage == null) {
            this.storage = this.createMap();
        }
        PersistentHashMap<K, V> persistentHashMap = this.storage;
        if (persistentHashMap == null) {
            Intrinsics.throwNpe();
        }
        return persistentHashMap;
    }

    @NotNull
    public final Collection<K> getKeys() {
        Object object = this.getStorageIfExists();
        if (object == null || (object = object.getAllKeysWithExistingMapping()) == null) {
            object = CollectionsKt.listOf();
        }
        return object;
    }

    public final boolean contains(K key) {
        PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
        return persistentHashMap != null ? persistentHashMap.containsMapping(key) : false;
    }

    @Nullable
    public final V get(K key) {
        PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
        return (V)(persistentHashMap != null ? persistentHashMap.get(key) : null);
    }

    public final void set(K key, V value) {
        this.getStorageOrCreateNew().put(key, value);
    }

    public final void remove(K key) {
        Unit unit;
        PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
        if (persistentHashMap != null) {
            persistentHashMap.remove(key);
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
    }

    public final void append(K key, @NotNull Function1<? super DataOutput, ? extends Unit> append) {
        Intrinsics.checkParameterIsNotNull(append, (String)"append");
        Function1<? super DataOutput, ? extends Unit> function1 = append;
        this.getStorageOrCreateNew().appendData(key, (PersistentHashMap.ValueDataAppender)(function1 == null ? null : new StoragePackage$sam$ValueDataAppender$5847c6dd(function1)));
    }

    public final synchronized void clean() {
        try {
            Unit unit;
            PersistentHashMap<K, V> persistentHashMap = this.storage;
            if (persistentHashMap != null) {
                persistentHashMap.close();
                unit = Unit.INSTANCE$;
            } else {
                unit = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PersistentHashMap.deleteFilesStartingWith((File)this.storageFile);
        this.storage = null;
    }

    public final synchronized void flush(boolean memoryCachesOnly) {
        PersistentHashMap<K, V> persistentHashMap = this.storage;
        if (persistentHashMap == null) {
            return;
        }
        PersistentHashMap<K, V> existingStorage = persistentHashMap;
        if (memoryCachesOnly) {
            if (existingStorage.isDirty()) {
                existingStorage.dropMemoryCaches();
            }
        } else {
            existingStorage.force();
        }
    }

    public final synchronized void close() {
        Unit unit;
        PersistentHashMap<K, V> persistentHashMap = this.storage;
        if (persistentHashMap != null) {
            persistentHashMap.close();
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
    }

    private final PersistentHashMap<K, V> createMap() {
        return new PersistentHashMap(this.storageFile, this.keyDescriptor, this.valueExternalizer);
    }

    public LazyStorage(@NotNull File storageFile, @NotNull KeyDescriptor<K> keyDescriptor, @NotNull DataExternalizer<V> valueExternalizer) {
        Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
        Intrinsics.checkParameterIsNotNull(keyDescriptor, (String)"keyDescriptor");
        Intrinsics.checkParameterIsNotNull(valueExternalizer, (String)"valueExternalizer");
        this.storageFile = storageFile;
        this.keyDescriptor = keyDescriptor;
        this.valueExternalizer = valueExternalizer;
    }
}

