/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.model;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.util.ArrayUtil;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestNGTestClass;
import com.theoryinpractice.testng.model.TestNGTestGroup;
import com.theoryinpractice.testng.model.TestNGTestMethod;
import com.theoryinpractice.testng.model.TestNGTestPackage;
import com.theoryinpractice.testng.model.TestNGTestPattern;
import com.theoryinpractice.testng.model.TestNGTestSuite;
import com.theoryinpractice.testng.model.TestType;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class TestNGTestObject {
    private static final Logger LOG = Logger.getInstance((String)("#" + TestNGTestObject.class.getName()));
    protected final TestNGConfiguration myConfig;

    public TestNGTestObject(TestNGConfiguration config) {
        this.myConfig = config;
    }

    public static TestNGTestObject fromConfig(TestNGConfiguration config) {
        String testObject = config.getPersistantData().TEST_OBJECT;
        if (testObject.equals(TestType.PACKAGE.getType())) {
            return new TestNGTestPackage(config);
        }
        if (testObject.equals(TestType.CLASS.getType())) {
            return new TestNGTestClass(config);
        }
        if (testObject.equals(TestType.METHOD.getType())) {
            return new TestNGTestMethod(config);
        }
        if (testObject.equals(TestType.GROUP.getType())) {
            return new TestNGTestGroup(config);
        }
        if (testObject.equals(TestType.PATTERN.getType())) {
            return new TestNGTestPattern(config);
        }
        if (testObject.equals(TestType.SUITE.getType())) {
            return new TestNGTestSuite(config);
        }
        assert (false) : testObject;
        return null;
    }

    public abstract void fillTestObjects(Map<PsiClass, Map<PsiMethod, List<String>>> var1) throws CantRunException;

    public abstract String getGeneratedName();

    public abstract String getActionName();

    public abstract void checkConfiguration() throws RuntimeConfigurationException;

    public boolean isConfiguredByElement(PsiElement element) {
        return false;
    }

    protected static void calculateDependencies(PsiMethod[] methods, Map<PsiClass, Map<PsiMethod, List<String>>> results, GlobalSearchScope searchScope, PsiClass ... classes) {
        TestNGTestObject.calculateDependencies(methods, results, new LinkedHashSet<PsiMember>(), searchScope, classes);
    }

    private static void calculateDependencies(PsiMethod[] methods, final Map<PsiClass, Map<PsiMethod, List<String>>> results, final Set<PsiMember> alreadyMarkedToBeChecked, final GlobalSearchScope searchScope, final PsiClass ... classes) {
        block7: {
            if (classes == null || classes.length <= 0) break block7;
            final LinkedHashSet<String> groupDependencies = new LinkedHashSet<String>();
            TestNGUtil.collectAnnotationValues(groupDependencies, "dependsOnGroups", methods, classes);
            final LinkedHashSet<PsiMember> membersToCheckNow = new LinkedHashSet<PsiMember>();
            if (!groupDependencies.isEmpty()) {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        Project project = classes[0].getProject();
                        PsiClass testAnnotation = JavaPsiFacade.getInstance((Project)project).findClass(TestNGUtil.TEST_ANNOTATION_FQN, GlobalSearchScope.allScope((Project)project));
                        LOG.assertTrue(testAnnotation != null);
                        for (PsiMember psiMember : AnnotatedMembersSearch.search((PsiClass)testAnnotation, (SearchScope)searchScope)) {
                            PsiAnnotation annotation;
                            PsiClass containingClass = psiMember.getContainingClass();
                            if (containingClass == null || ArrayUtil.find((Object[])classes, (Object)containingClass) < 0 || !TestNGUtil.isAnnotatedWithParameter(annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiMember, (String[])new String[]{TestNGUtil.TEST_ANNOTATION_FQN}), "groups", groupDependencies) || !TestNGTestObject.appendMember(psiMember, alreadyMarkedToBeChecked, results)) continue;
                            membersToCheckNow.add(psiMember);
                        }
                    }
                });
            }
            TestNGTestObject.collectDependsOnMethods(results, alreadyMarkedToBeChecked, membersToCheckNow, methods, classes);
            if (methods == null) {
                for (PsiClass c : classes) {
                    results.put(c, new LinkedHashMap());
                }
            } else {
                for (PsiMember psiMember : membersToCheckNow) {
                    PsiClass psiClass;
                    PsiMethod[] meths = null;
                    if (psiMember instanceof PsiMethod) {
                        psiClass = psiMember.getContainingClass();
                        meths = new PsiMethod[]{(PsiMethod)psiMember};
                    } else {
                        psiClass = (PsiClass)psiMember;
                    }
                    TestNGTestObject.calculateDependencies(meths, results, alreadyMarkedToBeChecked, searchScope, psiClass);
                }
            }
        }
    }

    private static void collectDependsOnMethods(final Map<PsiClass, Map<PsiMethod, List<String>>> results, final Set<PsiMember> alreadyMarkedToBeChecked, final Set<PsiMember> membersToCheckNow, PsiMethod[] methods, PsiClass ... classes) {
        PsiClass[] psiClasses;
        if (methods != null && methods.length > 0) {
            LinkedHashSet<Object> containingClasses = new LinkedHashSet<Object>();
            PsiMethod[] psiMethodArray = methods;
            int n = psiMethodArray.length;
            for (int i = 0; i < n; ++i) {
                final PsiMethod method = psiMethodArray[i];
                containingClasses.add(ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

                    public PsiClass compute() {
                        return method.getContainingClass();
                    }
                }));
            }
            psiClasses = containingClasses.toArray(new PsiClass[containingClasses.size()]);
        } else {
            psiClasses = classes;
        }
        for (final PsiClass containingClass : psiClasses) {
            final LinkedHashSet<String> testMethodDependencies = new LinkedHashSet<String>();
            TestNGUtil.collectAnnotationValues(testMethodDependencies, "dependsOnMethods", methods, containingClass);
            if (testMethodDependencies.isEmpty()) continue;
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    Project project = containingClass.getProject();
                    JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
                    for (String dependency : testMethodDependencies) {
                        String className = StringUtil.getPackageName((String)dependency);
                        String methodName = StringUtil.getShortName((String)dependency);
                        if (StringUtil.isEmpty((String)className)) {
                            TestNGTestObject.checkClassMethods(methodName, containingClass, alreadyMarkedToBeChecked, membersToCheckNow, results);
                            continue;
                        }
                        PsiClass aClass = psiFacade.findClass(className, containingClass.getResolveScope());
                        if (aClass == null) continue;
                        TestNGTestObject.checkClassMethods(methodName, aClass, alreadyMarkedToBeChecked, membersToCheckNow, results);
                    }
                }
            });
        }
    }

    private static void checkClassMethods(String methodName, PsiClass containingClass, Set<PsiMember> alreadyMarkedToBeChecked, Set<PsiMember> membersToCheckNow, Map<PsiClass, Map<PsiMethod, List<String>>> results) {
        PsiMethod[] psiMethods;
        for (PsiMethod method : psiMethods = containingClass.findMethodsByName(methodName, true)) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)TestNGUtil.TEST_ANNOTATION_FQN, (boolean)false) || !TestNGTestObject.appendMember((PsiMember)method, alreadyMarkedToBeChecked, results)) continue;
            membersToCheckNow.add((PsiMember)method);
        }
    }

    private static boolean appendMember(PsiMember psiMember, Set<PsiMember> underConsideration, Map<PsiClass, Map<PsiMethod, List<String>>> results) {
        boolean result = false;
        PsiClass psiClass = psiMember instanceof PsiClass ? (PsiClass)psiMember : psiMember.getContainingClass();
        Map<PsiMethod, List<String>> psiMethods = results.get(psiClass);
        if (psiMethods == null) {
            psiMethods = new LinkedHashMap<PsiMethod, List<String>>();
            results.put(psiClass, psiMethods);
            if (psiMember instanceof PsiClass) {
                result = underConsideration.add(psiMember);
            }
        }
        if (psiMember instanceof PsiMethod) {
            boolean add;
            boolean bl = add = psiMethods.put((PsiMethod)psiMember, Collections.emptyList()) != null;
            if (add) {
                return underConsideration.add(psiMember);
            }
            return false;
        }
        return result;
    }

    @NotNull
    protected GlobalSearchScope getSearchScope() {
        TestData data = this.myConfig.getPersistantData();
        Module module = ((JavaRunConfigurationModule)this.myConfig.getConfigurationModule()).getModule();
        GlobalSearchScope globalSearchScope = data.TEST_OBJECT.equals(TestType.PACKAGE.getType()) ? this.myConfig.getPersistantData().getScope().getSourceScope((ModuleBasedConfiguration)this.myConfig).getGlobalSearchScope() : (module != null ? GlobalSearchScope.moduleWithDependenciesScope((Module)module) : GlobalSearchScope.projectScope((Project)this.myConfig.getProject()));
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/model/TestNGTestObject", "getSearchScope"));
        }
        return globalSearchScope;
    }

    public static void collectTestMethods(Map<PsiClass, Map<PsiMethod, List<String>>> classes, final PsiClass psiClass, final String methodName, GlobalSearchScope searchScope) {
        PsiMethod[] methods = (PsiMethod[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiMethod[]>(){

            public PsiMethod[] compute() {
                return psiClass.findMethodsByName(methodName, true);
            }
        });
        TestNGTestObject.calculateDependencies(methods, classes, searchScope, psiClass);
        Map<PsiMethod, List<String>> psiMethods = classes.get(psiClass);
        if (psiMethods == null) {
            psiMethods = new LinkedHashMap<PsiMethod, List<String>>();
            classes.put(psiClass, psiMethods);
        }
        for (PsiMethod method : methods) {
            if (psiMethods.containsKey(method)) continue;
            psiMethods.put(method, Collections.emptyList());
        }
    }
}

