/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.google.common.collect.Iterators;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.ClassDeclaration;
import lombok.ast.Expression;
import lombok.ast.ExpressionStatement;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.StrictListAccessor;

public class CustomViewDetector
extends Detector
implements Detector.JavaScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(CustomViewDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("CustomViewStyleable", "Mismatched Styleable/Custom View Name", "The convention for custom views is to use a `declare-styleable` whose name matches the custom view class name. The IDE relies on this convention such that for example code completion can be offered for attributes in a custom view in layout XML resource files.\n\n(Similarly, layout parameter classes should use the suffix `_Layout`.)", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);
    private static final String OBTAIN_STYLED_ATTRIBUTES = "obtainStyledAttributes";

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(OBTAIN_STYLED_ATTRIBUTES);
    }

    @Override
    public void visitMethod(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull MethodInvocation node) {
        if (node.getParent() instanceof ExpressionStatement) {
            if (!context.isContextMethod(node)) {
                return;
            }
            StrictListAccessor expressions = node.astArguments();
            int size = expressions.size();
            int parameterIndex = size == 1 ? 0 : 1;
            Expression expression = (Expression)Iterators.get((Iterator)node.astArguments().iterator(), (int)parameterIndex, null);
            if (expression == null) {
                return;
            }
            String s = expression.toString();
            if (!s.startsWith("R.styleable.")) {
                return;
            }
            String styleableName = s.substring("R.styleable.".length());
            ClassDeclaration cls = JavaContext.findSurroundingClass((Node)node);
            if (cls == null) {
                return;
            }
            JavaParser.ResolvedNode resolved = context.resolve((Node)cls);
            if (!(resolved instanceof JavaParser.ResolvedClass)) {
                return;
            }
            String className = cls.astName().astValue();
            JavaParser.ResolvedClass resolvedClass = (JavaParser.ResolvedClass)resolved;
            if (resolvedClass.isSubclassOf("android.view.View", false)) {
                if (!styleableName.equals(className)) {
                    String message = String.format("By convention, the custom view (`%1$s`) and the declare-styleable (`%2$s`) should have the same name (various editor features rely on this convention)", className, styleableName);
                    context.report(ISSUE, (Node)node, context.getLocation((Node)expression), message);
                }
            } else if (resolvedClass.isSubclassOf("android.view.ViewGroup.LayoutParams", false)) {
                ClassDeclaration outer = JavaContext.findSurroundingClass(cls.getParent());
                if (outer == null) {
                    return;
                }
                String layoutClassName = outer.astName().astValue();
                String expectedName = layoutClassName + "_Layout";
                if (!styleableName.equals(expectedName)) {
                    String message = String.format("By convention, the declare-styleable (`%1$s`) for a layout parameter class (`%2$s`) is expected to be the surrounding class (`%3$s`) plus \"`_Layout`\", e.g. `%4$s`. (Various editor features rely on this convention.)", styleableName, className, layoutClassName, expectedName);
                    context.report(ISSUE, (Node)node, context.getLocation((Node)expression), message);
                }
            }
        }
    }
}

