/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.PreconditionsKt;
import kotlin.Range;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"{\n)!2i\u001c3f\r\u0016t7-Z'be.,'O\u00117pG.T1a\u001c:h\u0015!Ig\u000e^3mY&T'\u0002C7be.$wn\u001e8\u000b\rA\f'o]3s\u00151i\u0017M]6fe\ndwnY6t\u0015\u0011IW\u000e\u001d7\u000b\u001f5\u000b'o[3s\u00052|7m[%na2Ta\u0001P5oSRt$\"D7z\u0007>t7\u000f\u001e:bS:$8OC\nNCJ\\Gm\\<o\u0007>t7\u000f\u001e:bS:$8OC\u0006d_:\u001cHO]1j]R\u001c(\u0002\u00059s_\u0012,8\r^5p]\"{G\u000eZ3s\u0015A\u0001&o\u001c3vGRLwN\u001c%pY\u0012,'O\u0003\u0006gK:\u001cWm\u0015;beRTaa\u0015;sS:<'BB6pi2LgN\u0003\u0003kCZ\f'\u0002\u00027b]\u001eTA\"\u001a8e\u0019&tWMU3hKbTQAU3hKbTA\u0001^3yi*)\"/Z1m\u0013:$XM]3ti&twm\u00144gg\u0016$(bA%oi*y\u0011\r\u001c7poN\u001cVO\u0019\"m_\u000e\\7OC\u0004C_>dW-\u00198\u000b3\r\fGn\u0019(fqRLe\u000e^3sKN$\u0018N\\4PM\u001a\u001cX\r\u001e\u0006\u0004a>\u001c(\u0002\u0003)pg&$\u0018n\u001c8\u000b\u001b1{wn[1iK\u0006$G+\u001a=u\u0015Yaun\\6bQ\u0016\fG\rV3yi\u0012\u0002vn]5uS>t'B\u00043p!J|7-Z:t)>\\WM\u001c\u0006\u0013GV\u0014(/\u001a8u\u0007>t7\u000f\u001e:bS:$8O\u0003\tQe>\u001cWm]:j]\u001e\u0014Vm];mi*YQ*\u0019:lKJ\u0014En\\2l\u0015qi\u0015M]6fe\ncwnY6%!J|7-Z:tS:<'+Z:vYRTQ\"\u001a8egRC\u0017n\u001d$f]\u000e,'\u0002\u00027j]\u0016TAb\u00115beN+\u0017/^3oG\u0016T\u0001cZ3u\t\u00164\u0017-\u001e7u\u0003\u000e$\u0018n\u001c8\u000b\u001b\rcwn]5oO\u0006\u001bG/[8o\u0015ei\u0015M]6fe\ncwnY6%\u00072|7/\u001b8h\u0003\u000e$\u0018n\u001c8\u000b%\u001d,G\u000fR3gCVdGOT8eKRK\b/\u001a\u0006\r\u0013\u0016cW-\\3oiRK\b/\u001a\u0006\u0014SNLe\u000e^3sKN$\u0018N\\4PM\u001a\u001cX\r\u001ev\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0011AA\u0001\u0005\u0004\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\u0019AA\u0001E\u0004\u0019\u0001)!\u0001b\u0001\t\f\u0015\u0019A\u0001\u0002\u0005\u0006\u0019\u0001)1\u0001b\u0001\t\u000e1\u0001Q!\u0001\u0005\t\u000b\r!Y\u0001c\u0004\r\u0001\u0015\u0011A\u0001\u0002\u0005\u0006\u000b\t!\u0019\u0001#\u0004\u0006\u0003!EQA\u0001C\b\u0011%)!\u0001\u0002\u0005\t\u0010\u0015\u0011A1\u0002E\u000b\u000b\r!\u0011\u0002\u0003\u0006\r\u0001\u0015\u0011A!\u0003\u0005\u000b\u000b\r!Y\u0001c\u0006\r\u0001\u0015\u0019A1\u0002E\r\u0019\u0001)1\u0001b\u0001\t\u001e1\u0001Qa\u0001C\f\u00119a\u0001!\u0002\u0002\u0005\u0004!yQa\u0001\u0003\u0003\u0011Ea\u0001!B\u0002\u0005\u001b!\u0005B\u0002A\u0003\u0003\t\tA\u0019#B\u0002\u0005\f!\u0019B\u0002A\u0003\u0003\t!A1#B\u0002\u0005\u001b!!B\u0002A\u0003\u0003\t\tAI#B\u0002\u0005\u0003!-B\u0002A\u0003\u0003\t\u0005AY\u0003B\u0002\r\u0007e\u0019Q!\u0001E\u00041\u000fiC\u0002B1\u00051'\t3!B\u0001\t\u0014aMQk\u0001\u0003\u0006\u0007\u0011M\u0011\"\u0001\u0005\u000b[1!\u0011\r\u0002\r\bC\r)\u0011\u0001\u0003\u0004\u0019\rU\u001bA!B\u0002\u0005\u000f%\t\u0001\u0012C\u0017\r\t\u0005$\u0001DB\u0011\u0004\u000b\u0005AQ\u0001G\u0003V\u0007\u0011)1\u0001\u0002\u0004\n\u0003!9Q\u0006\u0004\u0003B\u001aaY\u0011eA\u0003\u0002\u0011+A*\"V\u0002\u0005\u000b\r!1\"C\u0001\u0005\u00065VAa\u0003\r\rC\r)\u0011\u0001C\u0006\u0019\u0017E\u001b1\u0001\u0002\u0007\n\u0003\u0011\u0005Q&\u0006\u0003\u000b15iz\u0001\u0002\u0001\t\u001c5\u0019Q!\u0001\u0005\r11\u00016\u0001A\u0011\u0004\u000b\u0005A)\u0002'\u0006R\u0007\u0015!Q\"C\u0001\u0005\u00065\t\u0001\u0012DW \t)Az\"h\u0004\u0005\u0001!mQbA\u0003\u0002\u00111AB\u0002U\u0002\u0001;\u001f!\u0001\u0001\u0003\t\u000e\u0007\u0015\t\u0001\u0012\u0002M\u0005!\u000e\u0005\u0011eA\u0003\u0002\u00117AZ\"U\u0002\b\t?I\u0011\u0001\u0003\b\u000e\u0003!eQ\"\u0001E\u0007[U!\u0011\u0001\u0007\n\u001e\u0010\u0011\u0001\u0001RE\u0007\u0004\u000b\u0005Ai\u0002'\bQ\u0007\u0001\t3!B\u0001\t\u0017aY\u0011kA\u0003\u0005%%\tA\u0011A\u0007\u0002\u0011=i+\u0002\u0002\u0006\u0019(\u0005\u001aQ!\u0001E\u00101?\t6a\u0001C\u0014\u0013\u0005A\u0001#,\u0006\u0005\u0017a)\u0012eA\u0003\u0002\u0011CA\n#U\u0002\u0004\tUI\u0011\u0001C\t.+\u0011Y\u0001DFO\b\t\u0001AY\"D\u0002\u0006\u0003!a\u0001\u0004\u0004)\u0004\u0001\u0005\u001aQ!\u0001\u0005\f1-\t6!\u0002\u0003\u0017\u0013\u0005!\t!D\u0001\t\u001aU^SQ\u000b\u0003d\u0002a!Qt\u0002\u0003\u0001\u0011\u0013i1!B\u0001\t\na%\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001BB\u0007\u0004\u000b\u0005AQ\u0001G\u0003Q\u0007\u0003iz\u0001\u0002\u0001\t\u000f5\u0019Q!\u0001\u0005\u00071\u0019\u00016!A\u0011\u0004\u000b\u0005A1\u0001G\u0002R\u0007%!A!C\u0001\u0005\u00015\t\u0001RB\u0007\u0002\u0011\u001di\u0011\u0001#\u0005"})
public final class CodeFenceMarkerBlock
extends MarkerBlockImpl {
    public static final /* synthetic */ KClass $kotlinClass;
    private final Regex endLineRegex;
    private int realInterestingOffset;
    private final ProductionHolder productionHolder;
    private final String fenceStart;

    static {
        $kotlinClass = Reflection.createKotlinClass(CodeFenceMarkerBlock.class);
    }

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return true;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        int nextLineOffset;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)currentConstraints, (String)"currentConstraints");
        if (pos.getOffset() < this.realInterestingOffset) {
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        if (pos.getOffsetInCurrentLine() != -1) {
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        PreconditionsKt.assert((pos.getChar() == '\n' ? 1 : 0) != 0);
        MarkdownConstraints nextLineConstraints = MarkdownConstraints.Companion.fromBase(pos, this.getConstraints());
        if (!nextLineConstraints.extendsPrev(this.getConstraints())) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        this.realInterestingOffset = nextLineOffset = pos.getNextLineOrEofOffset();
        CharSequence currentLine = nextLineConstraints.eatItselfFromString(pos.getCurrentLine());
        if (this.endsThisFence(currentLine)) {
            this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node((Range<Integer>)((Range)new IntRange(pos.getOffset() + 1, pos.getNextLineOrEofOffset())), MarkdownTokenTypes.Companion.getCODE_FENCE_END())));
            this.scheduleProcessingResult(nextLineOffset, MarkerBlock.ProcessingResult.Companion.getDEFAULT());
        } else {
            IntRange contentRange = new IntRange(Math.min(pos.getOffset() + 1 + this.getConstraints().getCharsEaten(pos.getCurrentLine()), nextLineOffset), nextLineOffset);
            if (((Number)contentRange.getStart()).intValue() < ((Number)contentRange.getEnd()).intValue()) {
                this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node((Range<Integer>)((Range)contentRange), MarkdownTokenTypes.Companion.getCODE_FENCE_CONTENT())));
            }
        }
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    private final boolean endsThisFence(CharSequence line) {
        return this.endLineRegex.matches(line);
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return MarkdownElementTypes.Companion.getCODE_FENCE();
    }

    public CodeFenceMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder productionHolder, @NotNull String fenceStart) {
        Intrinsics.checkParameterIsNotNull((Object)myConstraints, (String)"myConstraints");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)fenceStart, (String)"fenceStart");
        super(myConstraints, productionHolder.mark());
        this.productionHolder = productionHolder;
        this.fenceStart = fenceStart;
        this.endLineRegex = new Regex("^ {0,3}" + this.fenceStart + "+ *" + "$");
        this.realInterestingOffset = -1;
    }
}

